#!/usr/bin/env ruby
# $Id: hdw.rb,v 1.8 2007/12/05 20:41:10 samurai20000 Exp $
$LOAD_PATH << 'lib'

$KCONV = 'euc-jp'

Version = '0.0.1'

require 'hatena_diary_writer'

if __FILE__ == $0
  log = Logger.new(STDOUT)
  log.level = Logger::INFO

  conf_file = 'hdw.conf'
  opts = {}
  OptionParser.new do |opt|
    opt.on('-c', '--config=FILE', 'set config file.') do |v|
      conf_file = v
    end
    opt.on('-d', '--diary-dir=DIR', 'set diary directory.') do |v|
      opts[:diary_dir] = v
    end
    opt.on('-t', '--upload-table=FILE', 'set upload table file') do |v|
      opts[:upload_table_file] = v
    end
    opt.on('-v', '--verbose', 'turn on verbose mode.') do |v|
      log.level = Logger::DEBUG
    end
    opt.parse!(ARGV)
  end
  
  conf = DiaryWriterConfig.load(conf_file)
  log.debug("config file '#{conf_file}' loaded.")
  conf.diary_dir = opts[:diary_dir] if opts[:diary_dir]
  conf.upload_table_file = opts[:upload_table_file] if opts[:upload_table_file]
  conf.freeze
  
  upload_table = DiaryUploadTable.new(conf.upload_table_file)
  log.debug("upload table '#{conf.upload_table_file}' loaded.")
  
  log.debug("dir '#{conf.diary_dir}' traversing...")
  dfiles = []
  Pathname.new(conf.diary_dir).find do |path|
    begin
      dfile = DiaryFile.new(path)
      dfiles << dfile unless upload_table.uploaded?(dfile)
    rescue DiaryInvalidFileException => ex
      # ignore
    end
  end
  exit 0 if dfiles.empty?

  dfiles.sort! do |f1, f2|
    f1.date <=> f2.date
  end

  writer = HatenaDiaryWriter.new(conf.id, conf.passwd, conf.group)
  writer.login
  log.debug('login finished.')
  
  dfiles.each do |dfile|
    log.info("upload '#{dfile.name}'")
    if dfile.image?
      writer.img_upload(dfile.date, dfile.name)
    else
      writer.edit(dfile.date, dfile.read)
    end
    log.debug('upload finished.')
    upload_table.update(dfile)
  end
  
  upload_table.store
  log.debug("upload table '#{conf.upload_table_file}' stored.")
end

