#!/usr/bin/env ruby
# $Id: hdw_edit.rb,v 1.3 2007/02/27 13:25:18 ha-tan Exp $

require 'optparse'
require 'pathname'
require 'win32ole'

Version = '0.0.1'

diary_dir = '.'

editor = 'notepad.exe' 
editor = ENV['EDITOR'] if ENV['EDITOR']

hdw_cmd = 'cmd /c "hdw.exe -v & pause -1"'

OptionParser.new do |opt|
  opt.on('-d', '--diary-dir=DIR', 'set diary directory.') do |v|
    diary_dir = v
  end
  opt.on('-e', '--editor=EDITOR', 'set editor.') do |v|
    editor = v
  end
  opt.on('-c', '--hdw-cmd=COMMAND', 'set hatena diary writer command.') do |v|
    hdw_cmd = v
  end
  opt.parse!(ARGV)  
end

diary_file = Pathname.new(diary_dir) + Time.now.strftime('%Y_%m/%d.txt')
month_dir = diary_file.parent
month_dir.mkpath
diary_file.open( 'w') {} unless diary_file.exist?
before_mtime = diary_file.mtime

sh = WIN32OLE.new('WScript.Shell')
sh.run("#{editor} \"#{diary_file}\"", 5, true)

if diary_file.zero?
  diary_file.delete
  month_dir.rmdir if month_dir.children.empty?
  exit 0
end

if diary_file.mtime > before_mtime
  ret = sh.popup("͂Ăȃ_CA[ɃAbv[h܂H", -1,
                 "Abv[hmF", 1)
  case ret
  when 1
    sh.run(hdw_cmd)
  end
end
