class Test_DiaryFile < Test::Unit::TestCase
  def setup
    @text_path = Pathname.new('2007-2-23.txt')
    @img_path = Pathname.new('2007-2-23.jpg')
    @text = DiaryFile.new(@text_path)
    @img = DiaryFile.new(@img_path)
  end
  
  def test_initialize_error
    dummy_text = Pathname.new('huga.txt')
    assert_raises (DiaryInvalidFileException) { DiaryFile.new(dummy_text)}
  end
  
  def test_date
    assert_match /\d+/, @text.date
    assert_equal '20070223', @text.date
  end
  
  def test_image?
    assert !@text.image?
    assert @img.image?
  end
end

