class Test_HatenaDiaryWriter < Test::Unit::TestCase
  def setup
    @conf = DiaryWriterConfig.load('../hdw.conf')
    @hdw = HatenaDiaryWriter.new(@conf.id, @conf.passwd, @conf.group)
    @hdw.login
  end
  
  def test_login
    assert_equal '200', @hdw.login.code
  end
  
  def test_edit
    assert_equal '200', @hdw.edit('20071203', '* hello world').code
  end
  
  def test_img_upload
    assert_equal '200', @hdw.img_upload('20071203', '2007-2-23.jpg').code
    File.utime(Time.now + 60, Time.now + 60, '2007-2-23.jpg')
    assert_equal '200', @hdw.img_upload('20071203', '2007-2-23.jpg').code
  end
end
