/*
 * Created on 2005/07/01
 *
 */
package jp.co.areaweb.tools.core;

import junit.framework.TestCase;

/**
 * @author y_hayashi
 *
 * 文字列のトリミングを行う．通常のjava.lang.String.trim()の機能に加えて、
 * 全角スペースもトリム対象の文字に加える。
 */
public class TestJapaneseString extends TestCase {

	/**
	 * テスト
	 * 通常のトリム動作
	 */
	public void test000() throws Exception {
		assertEquals("全角のスペースは空白文字か？", true, java.lang.Character.isWhitespace('　'));
	}
	
	/**
	 * テスト１
	 * 通常のトリム動作
	 */
	public void test001() throws Exception {
		assertEquals("", JapaneseString.trim(""));
		assertEquals("", JapaneseString.trim(" 	 "));
		assertEquals("ABC", JapaneseString.trim("ABC"));
		assertEquals("ABC", JapaneseString.trim(" ABC"));
		assertEquals("ABC", JapaneseString.trim("	ABC"));
		assertEquals("ABC", JapaneseString.trim("ABC  "));
		assertEquals("ABC", JapaneseString.trim("ABC	"));
		assertEquals("A	B C", JapaneseString.trim(" 	A	B C  "));
		assertEquals("A	B C", JapaneseString.trim("A	B C	 	"));
	}
	
	/**
	 * テスト2
	 * 全角スペース
	 */
	public void test002() throws Exception {
		assertEquals("", JapaneseString.trim("　　"));
		assertEquals("ABC", JapaneseString.trim("　ABC"));
		assertEquals("ABC", JapaneseString.trim("　　ABC"));
		assertEquals("ABC", JapaneseString.trim("ABC　"));
		assertEquals("ABC", JapaneseString.trim("ABC　　"));
		assertEquals("A　BC", JapaneseString.trim("　A　BC　　"));
		assertEquals("A	B　C", JapaneseString.trim("A	B　C	 　	"));
	}
	
	/**
	 * テスト３
	 * 日本語コード
	 */
	public void test003() throws Exception {
		assertEquals("", JapaneseString.trim("　		　"));
		assertEquals("いろは", JapaneseString.trim("　いろは"));
		assertEquals("いろは", JapaneseString.trim("　　いろは"));
		assertEquals("いろは", JapaneseString.trim("いろは　"));
		assertEquals("いろは", JapaneseString.trim("いろは　　"));
		assertEquals("い　ろ	は", JapaneseString.trim("　い　ろ	は　　"));
		assertEquals("い　　 ろ	は", JapaneseString.trim("い　　 ろ	は 　	"));
	}
}
