/*
 * WakeOnLan.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */
package jp.hrtdotnet.java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;


/**
 * WakeOnLANNXłB
 * 
 * @version 2.0
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.0
 */
public class WakeOnLan {

    /**
     * WakeOnLAÑpPbg𑗐M܂B
     * 
     * @param ipAddress MIPAhX
     * @param port M|[g
     * @param macAddress ΏMACAhX(؂蕶́u:v́u-v)
     * @throws UnknownHostException
     *          hostIPAhX擾łȂAIPv6̃AhXw肳ꂽꍇ
     * @throws SecurityException
     *          hostւ̃\PbgڑȂꍇ
     * @throws SocketException
     *          \PbgJƂłȂꍇ
     * @throws IOException
     *          o̓G[ꍇ
     */
    public static void execute(String ipAddress, int port, String macAddress)
            throws UnknownHostException, SocketException, IOException {
        byte[] magicPacket = createMagicPacket(macAddress);
        executeMagicPacket(ipAddress, port, magicPacket);
    }

    /**
     * WakeOnLAÑpPbg𑗐M܂B
     * 
     * @param ipAddress MIPAhX
     * @param port M|[g
     * @param macAddress ΏMACAhX
     * @param delim MACAhX̋؂蕶
     * @throws UnknownHostException
     *          hostIPAhX擾łȂAIPv6̃AhXw肳ꂽꍇ
     * @throws SecurityException
     *          hostւ̃\PbgڑȂꍇ
     * @throws SocketException
     *          \PbgJƂłȂꍇ
     * @throws IOException
     *          o̓G[ꍇ
     */
    public static void execute(String ipAddress, int port, String macAddress, String delim)
            throws UnknownHostException, SocketException, IOException {
        byte[] magicPacket = createMagicPacket(macAddress, delim);
        executeMagicPacket(ipAddress, port, magicPacket);
    }  

    /**
     * WakeOnLAÑpPbg𑗐M܂B
     * 
     * @param host MIPAhX
     * @param port M|[g
     * @param macAddress ΏMACAhX(INebgP)
     * @throws UnknownHostException
     *          hostIPAhX擾łȂAIPv6̃AhXw肳ꂽꍇ
     * @throws SecurityException
     *          hostւ̃\PbgڑȂꍇ
     * @throws SocketException
     *          \PbgJƂłȂꍇ
     * @throws IOException
     *          o̓G[ꍇ
     */
    public static void execute(String host, int port, byte[] macAddress)
            throws UnknownHostException, SocketException, IOException {
        byte[] magicPacket = createMagicPacket(macAddress);
        executeMagicPacket(host, port, magicPacket);
    }    

    /**
     * WakeOnLAÑpPbg𑗐M܂B
     * 
     * @param host MzXgAIPAhX
     * @param port M|[g
     * @param macAddress MagicPacket(INebgP)
     * @throws UnknownHostException
     *          hostIPAhX擾łȂAIPv6̃AhXw肳ꂽꍇ
     * @throws SecurityException
     *          hostւ̃\PbgڑȂꍇ
     * @throws SocketException
     *          \PbgJƂłȂꍇ
     * @throws IOException
     *          o̓G[ꍇ
     */
    protected static void executeMagicPacket(String host, int port, byte[] magicPacket)
            throws UnknownHostException, SecurityException, SocketException, IOException {
        
        if (magicPacket == null) {
            throw new NullPointerException("MagicPacket is null.");
        }
        
        InetAddress inetAddress = null;
        DatagramPacket packet = null;
        DatagramSocket socket = null;
        try {
            inetAddress = InetAddress.getByName(host);
            packet = new DatagramPacket(magicPacket, magicPacket.length, inetAddress, port);
            socket = new DatagramSocket();
            socket.send(packet);
        } finally {
            if (socket != null && socket.isClosed() == false) {
                socket.close();                            
            }
        }
    }    

    
    /**
     * MagicPacket𐶐܂B
     * 
     * @param macAddress MACAhX(؂蕶́u:v́u-v)
     * @return MagicPacket
     */
    protected static byte[] createMagicPacket(String macAddress) {
        //MACAhX
        byte[] macAddressBytes = NetUtil.octetMacAddress(macAddress);
        //MaggicPacket
        return createMagicPacket(macAddressBytes);
    }

    /**
     * MagicPacket𐶐܂B
     * 
     * @param macAddress MACAhX
     * @param delim ؂蕶
     * @return MagicPacket
     */
    protected static byte[] createMagicPacket(String macAddress, String delim) {
        //MACAhX
        byte[] macAddressBytes = NetUtil.octetMacAddress(macAddress, delim);
        //MaggicPacket
        return createMagicPacket(macAddressBytes);
    }

    /**
     * MagicPacket𐶐܂B
     * 
     * @param macAddress MACAhX(INebgP)
     * @return MagicPacket
     */
    protected static byte[] createMagicPacket(byte[] macAddress) {

        int macAddressLength = NetUtil.MAC_ADDRESS_LENGTH;
        
        //s`FbN
        if (macAddress == null) {
            throw new NullPointerException("Mac-Address is null.");
        } else if (macAddress.length != macAddressLength) {
            throw new IllegalArgumentException("Mac-Address-length is invalid.");
        }

        //u[hLXgAhX+MACAhX~16
        byte[] magicPacket = new byte[macAddressLength + macAddressLength * 16];
        
        //u[hLXgAhX
        for (int i = 0; i < macAddressLength; i++) {
            magicPacket[i] = (byte)0xFF;
        }

        //MACAhX~16
        for (int i = 1; i <= 16; i++) {
            System.arraycopy(macAddress, 0, magicPacket, i * macAddressLength, macAddressLength);
        }

        return magicPacket;
    }
}
