/*
 * DateUtil.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */
package jp.hrtdotnet.java.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

import jp.hrtdotnet.java.lang.DateFormatException;

/**
 * t֘A̋@\̃[eBeBNXłB
 * ̃NX2006N_ł̃OSIɍ쐬Ă܂B
 * ̊mFLocale.JAPANŊmFĂ܂B
 * 
 * @version 2.0
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.0
 */
public class DateUtil {

    /** YYYYMMDD `̃tH[}bglłB */
    public static final String FORMAT_YYYYMMDD = "yyyyMMdd";
    
    /** YYYYMM `̃tH[}bglłB */
    public final static String FORMAT_YYYYMM = "yyyyMM";
    
    /** YYMMDD `̃tH[}bglłB */
    public final static String FORMAT_YYMMDD = "yyMMdd";
    
    /** YYMM `̃tH[}bglłB */
    public final static String FORMAT_YYMM = "yyMM";
    
    /** MMDD `̃tH[}bglłB */
    public final static String FORMAT_MMDD = "MMdd";
    
    /** YYYY `̃tH[}bglłB */
    public final static String FORMAT_YYYY = "yyyy";
    
    /** YY `̃tH[}bglłB */
    public final static String FORMAT_YY = "yy";
    
    /** MM `̃tH[}bglłB */
    public final static String FORMAT_MM = "MM";
    
    /** DD `̃tH[}bglłB */
    public final static String FORMAT_DD = "dd";

    /** 1̓ */
    public static final int JANUARY_DAYS = 31;
    /** 2̓ */
    public static final int FEBRUARY_DAYS = 29;
    /** 2̓iʏNj */
    public static final int FEBRUARY_NORMAL_DAYS = 28;
    /** 2̓i邤Nj */
    public static final int FEBRUARY_LEAP_DAYS = 29;
    /** 3̓ */
    public static final int MARCH_DAYS = 31;
    /** 4̓ */
    public static final int APRIL_DAYS = 30;
    /** 5̓ */
    public static final int MAY_DAYS = 31;
    /** 6̓ */
    public static final int JUNE_DAYS = 30;
    /** 7̓ */
    public static final int JULY_DAYS = 31;
    /** 8̓ */
    public static final int AUGUST_DAYS = 31;
    /** 9̓ */
    public static final int SEPTEMBER_DAYS = 30;
    /** 10̓ */
    public static final int OCTOBER_DAYS = 31;
    /** 11̓ */
    public static final int NOVEMBER_DAYS = 30;
    /** 12̓ */
    public static final int DECEMBER_DAYS = 31;

    /** 1 */
    public static final int JANUARY = 1;
    /** 2iʁj */
    public static final int FEBRUARY = 2;
    /** 2i邤Nj */
    public static final int FEBRUARY_LEAP = 13;
    /** 2iʏNj */
    public static final int FEBRUARY_NORMAL = 14;
    /** 3 */
    public static final int MARCH = 3;
    /** 4 */
    public static final int APRIL = 4;
    /** 5 */
    public static final int MAY = 5;
    /** 6 */
    public static final int JUNE = 6;
    /** 7 */
    public static final int JULY = 7;
    /** 8 */
    public static final int AUGUST = 8;
    /** 9 */
    public static final int SEPTEMBER = 9;
    /** 10 */
    public static final int OCTOBER = 10;
    /** 11 */
    public static final int NOVEMBER = 11;
    /** 12 */
    public static final int DECEMBER = 12;
    /** ` */
    public static final int UNDEFINED_MONTH = 0;
    /** ̍ŏl */
    public final static int MIN_MONTH_OF_YEAR = 1;
    /** ̍ől */
    public final static int MAX_MONTH_OF_YEAR = 12;
    /** ̍ŏl */
    public final static int MIN_DAY_OF_MONTH = 1;
    /** ̍ől */
    public final static int MAX_DAY_OF_MONTH = 31;

    /** ؁F */
    public final static int VALIDATE_NORMAL = 0;
    /** ؁F͈͕̔s */
    public final static int VALIDATE_MONTH_OVERRANGE = 1;
    /** ؁F͈͕̔s */
    public final static int VALIDATE_DAY_OVERRANGE = 1;

    /**
     * ̃f[^Calendar擾܂B
     * 
     * @return CalendarIuWFNg
     * @since 2.0
     */
    public static Calendar getYesterday() {
        return getYesterday(null);
    }

    /**
     * w肵Calendar̈Õf[^Calendar擾܂B
     * 擾CalendarIuWFNg͎w肵IuWFNgƂ͕ʂ̂̂łB
     * 
     * @param c CalendarIuWFNgB
     *           null̏ꍇ͎sCalendarėp
     * @return OCalendarIuWFNg
     * @since 2.0
     */
    public static Calendar getYesterday(Calendar c) {        
        if (c == null) {
            c = Calendar.getInstance();
        } else {
            c = (Calendar)c.clone();
        }
        int y = c.get(Calendar.YEAR);
        int m = c.get(Calendar.MONTH);
        int d = c.get(Calendar.DAY_OF_MONTH);
        if (d == c.getActualMinimum(Calendar.DAY_OF_MONTH) && m == Calendar.JANUARY ) {
            c.set(Calendar.YEAR, y - 1);
            c.set(Calendar.MONTH, Calendar.DECEMBER);
            c.set(Calendar.DAY_OF_MONTH, c.getActualMaximum(Calendar.DAY_OF_MONTH));
        } else if (d == c.getActualMinimum(Calendar.DAY_OF_MONTH)) {
            c.set(Calendar.MONTH, m - 1);
            c.set(Calendar.DAY_OF_MONTH, c.getActualMaximum(Calendar.DAY_OF_MONTH));
        } else {
            c.set(Calendar.DAY_OF_MONTH, d - 1);            
        }
        return c;
    }

    /**
     * ̃f[^Calendar擾܂B
     * 擾CalendarIuWFNg͎w肵IuWFNgƂ͕ʂ̂̂łB
     * 
     * @return CalendarIuWFNg
     * @since 2.0
     */
    public static Calendar getTomorrow() {
        return getTomorrow(null);
    }

    /**
     * w肵Calendar̗̃f[^Calendar擾܂B
     * 擾CalendarIuWFNg͎w肵IuWFNgƂ͕ʂ̂̂łB
     * 
     * @param c Calendar IuWFNgB
     *           null̏ꍇ͎sCalendarėp
     * @return CalendarIuWFNg
     * @since 2.0
     */
    public static Calendar getTomorrow(Calendar c) {        
        if (c == null) {
            c = Calendar.getInstance();
        } else {
            c = (Calendar)c.clone();
        }
        int y = c.get(Calendar.YEAR);
        int m = c.get(Calendar.MONTH);
        int d = c.get(Calendar.DAY_OF_MONTH);
        if (d == c.getActualMaximum(Calendar.DAY_OF_MONTH) && m == Calendar.DECEMBER ) {
            c.set(Calendar.YEAR, y + 1);
            c.set(Calendar.MONTH, Calendar.JANUARY);
            c.set(Calendar.DAY_OF_MONTH, c.getActualMinimum(Calendar.DAY_OF_MONTH));
        } else if (d == c.getActualMaximum(Calendar.DAY_OF_MONTH)) {
            c.set(Calendar.MONTH, m + 1);
            c.set(Calendar.DAY_OF_MONTH, c.getActualMinimum(Calendar.DAY_OF_MONTH));
        } else {
            c.set(Calendar.DAY_OF_MONTH, d + 1);
        }
        return c;
    }
    
    /**
     * w肵Calendar̓t擾܂B
     * 
     * @param format ť`
     * @param c ΏۂCalendarIuWFNg
     * @return t
     * @since 2.0
     */
    public static String getString(Calendar c, String format) {        
        if (c == null) {
            c = Calendar.getInstance();
        } else {
            c = (Calendar)c.clone();
        }
        DateFormat df = new SimpleDateFormat(format);
        return df.format(c.getTime());
    }

    /**
     * w肵Calendar̓t擾܂B
     * 擾ť`YYYYMMDDłB
     * 
     * @param c Ώۂ Calendar IuWFNg
     * @return t
     * @since 2.0
     */
    public static String getString(Calendar c) {
        return getString(c, FORMAT_YYYYMMDD);
    }

    /**
     * ̓tw肵`Ŏ擾܂B
     * 
     * @param format ť`
     * @return t
     * @since 2.0
     */
    public static String getYesetdayString(String format) {
        Calendar c = getYesterday();
        return getString(c, format);
    }

    /**
     * ̓t擾܂B
     * 擾ť`YYYYMMDDłB
     * 
     * @return t
     * @since 2.0
     */
    public static String getYesetdayString() {
        return getYesetdayString(FORMAT_YYYYMMDD);
    }
    
    /**
     * ̓tw肵`Ŏ擾܂B
     * 
     * @param format ť`
     * @return t
     * @since 2.0
     */
    public static String getTomorrowString(String format) {
        Calendar c = getTomorrow();
        return getString(c, format);
    }

    /**
     * ̓t擾܂B
     * 擾ť`YYYYMMDDłB
     * 
     * @return t
     * @since 2.0
     */
    public static String getTomorrowString() {
        return getTomorrowString(FORMAT_YYYYMMDD);
    }
    
    
    /**
     * ̓tw肵`Ŏ擾܂B
     * 
     * @param format ť`
     * @return t
     * @since 2.0
     */
    public static String getTodayString(String format) {
        return getString(Calendar.getInstance(), format);
    }

    /**
     * ̓t擾܂B
     * 擾ť`YYYYMMDDłB
     * 
     * @return t
     * @since 2.0
     */
    public static String getTodayString() {
        return getTodayString(FORMAT_YYYYMMDD);
    }

    /**
     * w肵Calendar̐挎̃f[^Calendar擾܂B
     * 擾CalendarIuWFNg͎w肵IuWFNgƂ͕ʂ̂̂łB
     * 
     * @param c CalendarIuWFNgB
     *           null̏ꍇ͎sCalendarėp
     * @return 挎CalendarIuWFNg
     * @since 2.0
     */
    public static Calendar getLastMonth(Calendar c) {        
        if (c == null) {
            c = Calendar.getInstance();
        } else {
            c = (Calendar)c.clone();
        }
        int y = c.get(Calendar.YEAR);
        int m = c.get(Calendar.MONTH);
        if (m == Calendar.JANUARY ) {
            c.set(Calendar.YEAR, y - 1);
            c.set(Calendar.MONTH, Calendar.DECEMBER);
        } else {
            c.set(Calendar.MONTH, m - 1);
        }
        return c;
    }
    
    /**
     * 挎̃f[^ Calendar 擾܂B
     * 擾 Calendar IuWFNg͎w肵IuWFNgƂ͕ʂ̂̂łB
     * 
     * @return 挎CalendarIuWFNg
     * @since 2.0
     */
    public static Calendar getLastMonth() {        
        return getLastMonth(null);
    }
    
    
    /**
     * w肵Calendar̗̃f[^Calendar擾܂B
     * 擾CalendarIuWFNg͎w肵IuWFNgƂ͕ʂ̂̂łB
     * 
     * @param c CalendarIuWFNgB
     *           null̏ꍇ͎sCalendarėp
     * @return CalendarIuWFNg
     * @since 2.0
     */
    public static Calendar getNextMonth(Calendar c) {        
        if (c == null) {
            c = Calendar.getInstance();
        } else {
            c = (Calendar)c.clone();
        }
        int y = c.get(Calendar.YEAR);
        int m = c.get(Calendar.MONTH);
        if (m == Calendar.DECEMBER) {
            c.set(Calendar.YEAR, y + 1);
            c.set(Calendar.MONTH, Calendar.JANUARY);
        } else {
            c.set(Calendar.MONTH, m + 1);
        }
        return c;
    }
    
    /**
     * ̃f[^Calendar擾܂B
     * 擾CalendarIuWFNg͎w肵IuWFNgƂ͕ʂ̂̂łB
     * 
     * @return  Calendar IuWFNg
     * @since 2.0
     */
    public static Calendar getNextMonth() {        
        return getNextMonth(null);
    }
    
    /**
     * 挎̓tw肵`Ŏ擾܂B
     * 
     * @param format ť`
     * @return t
     * @since 2.0
     */
    public static String getLastMonthString(String format) {
        Calendar c = getLastMonth();
        return getString(c, format);
    }

    /**
     * 挎̓t擾܂B
     * 擾ť`YYYYMMłB
     * 
     * @return t
     * @since 2.0
     */
    public static String getLastMonthString() {
        return getLastMonthString(FORMAT_YYYYMM);
    }
    
    /**
     * ̓tw肵`Ŏ擾܂B
     * 
     * @param format ť`
     * @return t
     * @since 2.0
     */
    public static String getNextMonthString(String format) {
        Calendar c = getNextMonth();
        return getString(c, format);
    }

    /**
     * ̓t擾܂B
     * 擾ť`YYYYMMłB
     * 
     * @return t
     * @since 2.0
     */
    public static String getNextMonthString() {
        return getNextMonthString(FORMAT_YYYYMM);
    }
    
    
    /**
     * ̓tw肵`Ŏ擾܂B
     * 
     * @param format ť`
     * @return t
     * @since 2.0
     */
    public static String getThisMonthString(String format) {
        return getString(Calendar.getInstance(), format);
    }

    /**
     * ̓t擾܂B
     * 擾ť`YYYYMMDDłB
     * 
     * @return t
     * @since 2.0
     */
    public static String getThisMonthString() {
        return getThisMonthString(FORMAT_YYYYMM);
    }

    /**
     * {̗j񂩂jl擾܂B
     * 
     * @param str {̗j
     * @return jl
     * @since 2.0
     */
    public static int toDayOfWeek(String str) {
        if (str == null) {
            throw new IllegalArgumentException("Day-of-week-string is null.");            
        }
        if ("".equals(str)) {
            return Calendar.MONDAY;
        } else if ("".equals(str)) {
            return Calendar.TUESDAY;
        } else if ("".equals(str)) {
            return Calendar.WEDNESDAY;
        } else if ("".equals(str)) {
            return Calendar.THURSDAY;
        } else if ("".equals(str)) {
            return Calendar.FRIDAY;
        } else if ("y".equals(str)) {
            return Calendar.SATURDAY;
        } else if ("".equals(str)) {
            return Calendar.SUNDAY;
        } else {
            throw new IllegalArgumentException("Day-of-week-string is invalid.");
        }
    }

    /**
     * ť̕؂s܂B
     * 
     * @param date ؂t
     * @param format ttH[}bg({NX`̃tH[}bĝݑΉ)
     * @return ،
     * @throws DateFormatException t񂪃tH[}bgƈقȂꍇ
     * @since 2.0
     */
    public static int validate(String date, String format) throws DateFormatException {

        Integer[] iDate = dateSplit(date, format);
        Integer year = iDate[0];
        Integer month = iDate[1];
        Integer day = iDate[2];

        //month check
        if (month != null) {
            int iMonth = month.intValue();
            if (iMonth < MIN_MONTH_OF_YEAR || MAX_MONTH_OF_YEAR < iMonth) {
                return VALIDATE_MONTH_OVERRANGE;
            }
        }

        //day check
        if (day != null) {
            int iDay = day.intValue();
            if (iDay < MIN_DAY_OF_MONTH) {
                return VALIDATE_DAY_OVERRANGE;
            }
            
            if (month == null) {
                if (iDay < MIN_DAY_OF_MONTH || MAX_DAY_OF_MONTH < iDay) {
                    return VALIDATE_DAY_OVERRANGE;
                }

            } else {
                int iMonth = month.intValue();                

                if (iMonth == JANUARY) {                    
                    if (iDay > JANUARY_DAYS) {
                        return VALIDATE_DAY_OVERRANGE;
                    }

                } else if (iMonth == FEBRUARY) {
                    if (year == null) {
                        if (iDay > FEBRUARY_DAYS) {
                            return VALIDATE_DAY_OVERRANGE;
                        }
                    } else {
                        GregorianCalendar gc = new GregorianCalendar();
                        if (gc.isLeapYear(year.intValue())) {
                            if (iDay > FEBRUARY_LEAP_DAYS) {
                                return VALIDATE_DAY_OVERRANGE;
                            }
                        } else {
                            if (iDay > FEBRUARY_NORMAL_DAYS) {
                                return VALIDATE_DAY_OVERRANGE;
                            }
                        }
                    }                    

                } else if (iMonth == MARCH) {
                    if (iDay > MARCH_DAYS) {
                        return VALIDATE_DAY_OVERRANGE;
                    }

                } else if (iMonth == APRIL) {
                    if (iDay > APRIL_DAYS) {
                        return VALIDATE_DAY_OVERRANGE;
                    }

                } else if (iMonth == MAY) {
                    if (iDay > MAY_DAYS) {
                        return VALIDATE_DAY_OVERRANGE;
                    }

                } else if (iMonth == JUNE) {
                    if (iDay > JUNE_DAYS) {
                        return VALIDATE_DAY_OVERRANGE;
                    }

                } else if (iMonth == JULY) {
                    if (iDay > JULY_DAYS) {
                        return VALIDATE_DAY_OVERRANGE;
                    }

                } else if (iMonth == AUGUST) {
                    if (iDay > AUGUST_DAYS) {
                        return VALIDATE_DAY_OVERRANGE;
                    }

                } else if (iMonth == SEPTEMBER) {
                    if (iDay > SEPTEMBER_DAYS) {
                        return VALIDATE_DAY_OVERRANGE;
                    }

                } else if (iMonth == OCTOBER) {
                    if (iDay > OCTOBER_DAYS) {
                        return VALIDATE_DAY_OVERRANGE;
                    }

                } else if (iMonth == NOVEMBER) {
                    if (iDay > NOVEMBER_DAYS) {
                        return VALIDATE_DAY_OVERRANGE;
                    }

                } else if (iMonth == DECEMBER) {
                    if (iDay > DECEMBER_DAYS) {
                        return VALIDATE_DAY_OVERRANGE;
                    }
                }
            }
        }

        //
        return VALIDATE_NORMAL;
    }

    /**
     * tN,,Pʂɕ܂B
     * 
     * @param dateString t
     * @param format ttH[}bg
     * @return 
     * @throws DateFormatException t񂪃tH[}bgƈقȂꍇ
     * @since 2.0
     */    
    private static Integer[] dateSplit(String dateString, String format) throws DateFormatException {
        
        Integer[] ret = null;

        if (format.equals(FORMAT_YYYYMMDD)) {
            if (dateString.length() != FORMAT_YYYYMMDD.length()) {
                throw new DateFormatException("date is illegal-length. date = " + dateString + ", format = " + format);
            }
            try {
                ret = new Integer[] {new Integer(dateString.substring(0,4)),
                        new Integer(dateString.substring(4,6)),
                        new Integer(dateString.substring(6,8))};
            } catch (NumberFormatException e) {
                throw new DateFormatException("date is illegal-format. date = " + dateString + ", format = " + format);
            }
            
        } else if (format.equals(FORMAT_YYYYMM)) {
            if (dateString.length() != FORMAT_YYYYMM.length()) {
                throw new DateFormatException("date is illegal-length. date = " + dateString + ", format = " + format);
            }
            try {
                ret = new Integer[] {new Integer(dateString.substring(0,4)),
                        new Integer(dateString.substring(4,6)),
                        null};
            } catch (NumberFormatException e) {
                throw new DateFormatException("date is illegal-format. date = " + dateString + ", format = " + format);
            }

        } else if (format.equals(FORMAT_YYMMDD)) {
            if (dateString.length() != FORMAT_YYMMDD.length()) {
                throw new DateFormatException("date is illegal-length. date = " + dateString + ", format = " + format);
            }
            try {
                ret = new Integer[] {new Integer(dateString.substring(0,2)),
                        new Integer(dateString.substring(2,4)),
                        new Integer(dateString.substring(4,6))};
            } catch (NumberFormatException e) {
                throw new DateFormatException("date is illegal-format. date = " + dateString + ", format = " + format);
            }

        } else if (format.equals(FORMAT_YYMM)) {
            if (dateString.length() != FORMAT_YYMM.length()) {
                throw new DateFormatException("date is illegal-length. date = " + dateString + ", format = " + format);
            }
            try {
                ret = new Integer[] {new Integer(dateString.substring(0,2)),
                        new Integer(dateString.substring(2,4)),
                        null};
            } catch (NumberFormatException e) {
                throw new DateFormatException("date is illegal-format. date = " + dateString + ", format = " + format);
            }

        } else if (format.equals(FORMAT_MMDD)) {
            if (dateString.length() != FORMAT_MMDD.length()) {
                throw new DateFormatException("date is illegal-length. date = " + dateString + ", format = " + format);
            }
            try {
                ret = new Integer[] {null,
                        new Integer(dateString.substring(0,2)),
                        new Integer(dateString.substring(2,4))};
            } catch (NumberFormatException e) {
                throw new DateFormatException("date is illegal-format. date = " + dateString + ", format = " + format);
            }

        } else if (format.equals(FORMAT_YYYY)) {
            if (dateString.length() != FORMAT_YYYY.length()) {
                throw new DateFormatException("date is illegal-length. date = " + dateString + ", format = " + format);
            }
            try {
                ret = new Integer[] {new Integer(dateString),
                        null,
                        null};
            } catch (NumberFormatException e) {
                throw new DateFormatException("date is illegal-format. date = " + dateString + ", format = " + format);
            }

        } else if (format.equals(FORMAT_YY)) {
            if (dateString.length() != FORMAT_YY.length()) {
                throw new DateFormatException("date is illegal-length. date = " + dateString + ", format = " + format);
            }
            try {
                ret = new Integer[] {new Integer(dateString),
                        null,
                        null};
            } catch (NumberFormatException e) {
                throw new DateFormatException("date is illegal-format. date = " + dateString + ", format = " + format);
            }

        } else if (format.equals(FORMAT_MM)) {
            if (dateString.length() != FORMAT_MM.length()) {
                throw new DateFormatException("date is illegal-length. date = " + dateString + ", format = " + format);
            }
            try {
                ret = new Integer[] {null,
                        new Integer(dateString),
                        null};
            } catch (NumberFormatException e) {
                throw new DateFormatException("date is illegal-format. date = " + dateString + ", format = " + format);
            }

        } else if (format.equals(FORMAT_DD)) {
            if (dateString.length() != FORMAT_DD.length()) {
                throw new DateFormatException("date is illegal-length. date = " + dateString + ", format = " + format);
            }
            try {
                ret = new Integer[] {null,
                        null,
                        new Integer(dateString)};
            } catch (NumberFormatException e) {
                throw new DateFormatException("date is illegal-format. date = " + dateString + ", format = " + format);
            }
        } else {
            throw new DateFormatException("format is illegal. date = " + dateString + ", format = " + format);
        }

        return ret;
    }

}
