/*
 * StringUtil.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */
package jp.hrtdotnet.java.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/**
 * ̃`FbNNXłB
 * 
 * @version 2.0
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.0
 */
public class StringUtil {

    private static final int UNICODE_MULTIBYTE = 1;
    private static final int UNICODE_ALL = 2;

    /**
     * charpǂ̔܂B
     * p͔pp[a-zA-Z]ƑSpp[-`-y]Ƃ܂B
     * 
     * @param c 肷镶
     * @return płtrueAłȂfalse
     * @since 2.0
     */
    public static boolean isAlphabet(char c) {
        if ((c >= '\u0041' && c <= '\u005A') || (c >= '\u0061' && c <= '\u007A')
                        || (c >= '\uFF21' && c <= '\uFF3A') || (c >= '\uFF41' && c <= '\uFF5A')) {
                return true;
        }
        return false;
    }


    /**
     * 񂪉pǂ肵܂B
     * p͔pp[a-zA-Z]ƑSpp[-`-y]Ƃ܂B
     * 
     * @param str 肷镶
     * @return płtrueAłȂfalse
     * @since 2.0
     */
    public static boolean isAlphabet(String str) {
        if (str == null || str.length() < 1) {
            return false;
        }
        for (int i = 0; i < str.length(); i++) {
            if(!isAlphabet(str.charAt(i))){
                return false;
            }
        }
        return true;
    }


    /**
     * ̒Ɏw肵P܂܂Ă邩𕶎̑召̋ʂĔf܂B
     * P͑召ʂ܂B
     * null󕶎̏ꍇfalseԂ܂B
     * 
     * @param str Ώۂ̕
     * @param c ܂܂邩𔻒肷镶
     * @return ܂܂ĂtrueA܂܂ĂȂfalse
     * @since 2.0
     */
    public static boolean includeChar(String str, char c){
        return includeChar(str, c, true);
    }


    /**
     * ̒Ɏw肵P܂܂Ă邩𔻒f܂B
     * 召ʂ邩Ȃw肷邱Ƃł܂B
     * null󕶎̏ꍇfalseԂ܂B
     * 
     * @param str Ώۂ̕
     * @param c ܂܂邩𔻒肷镶
     * @param em 召ʂꍇtrueA召ʂȂ̂łfalse
     * @return ܂܂ĂtrueA܂܂ĂȂfalse
     * @since 2.0
     */
    public static boolean includeChar(String str, char c, boolean em){
        if (str == null || str.length() < 1) {
            return false;
        }
        
        char c1;
        char c2;        
        for (int i = 0; i < str.length(); i++) {
            
            // 召ʂȂŔr
            if (em == false) {
                c1 = Character.toLowerCase(str.charAt(i));
                c2 = Character.toLowerCase(c);
                if (c1 == c2) {
                    return true;
                }
            // 召ʂĔr
            } else {
                if (str.charAt(i) == c) {
                    return true;
                }
            }            
        }
        return false;
    }
    

    /**
     * ̑OpXy[Xǂ𔻒肵܂B
     * 
     * @param str Ώۂ̕
     * @return OpXy[XȂtrueAłȂfalse
     * @since 2.0
     */
    public static boolean checkFrontSpace(String str){
        return checkFrontSpace(str, false);
    }

    
    /**
     * ̑OSp󔒃Xy[Xǂ𔻒肵܂B
     * SpXy[X̔邩ǂw肷邱Ƃł܂B
     * 
     * @param str Ώۂ̕
     * @param em SptrueAp݂̂false
     * @return OXy[XȂtrueAłȂfalse
     * @since 2.0
     */
    public static boolean checkFrontSpace(String str, boolean em){
        
        // null󕶎ł΁A`FbN͂ȂfalseԂ
        if (str == null || str.equals("")) {
            return false;
        }

        // pXy[X̔
        if (str.substring(0, 1).equals(" ")) {
            return true;
        }

        // SpXy[X
        if (em == true) {
            if (str.substring(0, 1).equals("@")) {
                return true;
            }
        }
        
        return false;
    }

    
    /**
     * ̌pXy[Xǂ𔻒肵܂B
     * 
     * @param str Ώۂ̕
     * @return pXy[XȂtrueAłȂfalse
     * @since 2.0
     */
    public static boolean checkRearSpace(String str){
        return checkRearSpace(str, false);
    }


    /**
     * ̌Sp󔒃Xy[Xǂ𔻒肵܂B
     * SpXy[X̔邩ǂw肷邱Ƃł܂B
     * 
     * @param str Ώۂ̕
     * @param em SptrueAp݂̂false
     * @return Xy[XȂtrueAłȂfalse
     * @since 2.0
     */
    public static boolean checkRearSpace(String str, boolean em){        
        // null󕶎ł΁A`FbN͂ȂfalseԂ
        if (str == null || str.equals("")) {
            return false;
        }
        // pXy[X̔
        if (str.substring(str.length() - 1).equals(" ")) {
            return true;
        }
        // SpXy[X
        if (em == true) {
            if (str.substring(str.length() - 1).equals("@")) {
                return true;
            }
        }
        return false;
    }

    /**
     * Sp𔼊pɕϊ܂B
     * p̏ꍇ͂̂܂ܕԂ܂B
     * pɕϊłȂw肷邱Ƃ͂ł܂B
     * <br><br>
     * o[Wł͐lƁu|v̂ݑΉĂ܂B
     * 
     * @param c pɕϊ镶
     * @return pɕϊ
     * @throws IllegalArgumentException
     *          pɕϊłȂw肳ꂽꍇ
     * @since 2.0
     */
    public static char toSingleByteChar(char c) {
        // p̏ꍇ͂̂܂ܕԂ
        if (Character.toString(c).getBytes().length == 1){
            return c;
        }        
        // Spl𔼊plɕϊ
        if ((c >= '\uFF10' && c <= '\uFF19') || (c >= '\uFF21' && c <= '\uFF3A') || (c >= '\uFF41' && c <= '\uFF5A')) {
            return (char) (c - '\uFF10' + '\u0030');
        } else if(c == '\u2212' || c == '\uFF0D') {
            return '-';
        }else {
            throw new IllegalArgumentException("Char can't convert single-byte : " + c);
        }
    }

    /**
     * 񒆂̃}`oCgVOoCgɕϊ܂B
     * pɕϊł镶toSingleByteChar(char)Ɉˑ܂B
     * VOoCgɕϊłȂw肷邱Ƃ͂ł܂B
     * 
     * @param str pɕϊ镶
     * @return pɕϊꂽ
     * @throws NullPointerException
     *          strnull̏ꍇ
     * @throws IllegalArgumentException
     *          strpɕϊłȂ̏ꍇ
     * @since 2.0
     */
    public static String toSingleByteString(String str) {
        if (str == null) {
            throw new NullPointerException("Argument is null.");
        } else if (str.length() == 0) {
            throw new IllegalArgumentException("Argument is empty.");            
        }
        char[] c = str.toCharArray();
        for (int i = 0; i < c.length; i++) {
            c[i] = toSingleByteChar(c[i]);
        }
        return new String(c);
    }

    /**
     * 񒆂̃}`oCgUnicode 16iR[hɕϊ܂B
     * ϊꂽ͐VKɍ쐬ꂽIuWFNgłB
     * 
     * @param str ϊ镶
     * @return Unicode 16iR[hɕϊꂽ
     * @since 2.0
     */
    public static String toUnicodeHexMultiByte(String str) {
        return StringUtil.toUnicodeHex(str, UNICODE_MULTIBYTE);
    }

    /**
     * Unicode 16iR[hɕϊ܂B
     * ϊꂽ͐VKɍ쐬ꂽIuWFNgłB
     * 
     * @param str ϊ镶
     * @return Unicode 16iR[hɕϊꂽ
     * @since 2.0
     */
    public static String toUnicodeHex(String str) {
        return StringUtil.toUnicodeHex(str, UNICODE_ALL);
    }

    /**
     * Unicode 16iR[h𕶎ɕϊ܂B
     * ϊꂽ͐VKɍ쐬ꂽIuWFNgłB
     * 
     * @param str ϊUnicode 16iR[h
     * @return ϊꂽ
     * @since 1.0
     */
    public static String toUnicodeString(String str) {
        
        if (str == null) {
            return null;
        }
        if (str.length() < 1) {
            return "";
        }
        
        StringBuffer sb = new StringBuffer();
        int length = str.length();
        for (int i = 0; i < length; i++) {
            if ('\\' == str.charAt(i)) {
                int i2 = i + 1;
                if ('u' == str.charAt(i2) || 'U' == str.charAt(i2)) {
                    try {
                        i2++;
                        while ('u' == str.charAt(i2) || 'U' == str.charAt(i2)) {
                            i2++;
                        }
                        sb.append((char) Integer.parseInt(str.substring(i2, i2 + 4), 16));
                        i = i2 + 3;
                    } catch (Exception e) {
                        sb.append(str.charAt(i));
                    }
                } else {
                    sb.append(str.charAt(i));                    
                }
            } else {
                sb.append(str.charAt(i));
            }
        }        
        return sb.toString();
    }

    /**
     * CSV`̕𕪊܂B
     * _uNH[e[Vi"jň͂܂ꂽ̋؂蕶͖܂B
     * Ȃ_uNH[e[Vi"j͋؂蕶Ɏw肷邱Ƃ͂ł܂B
     * 
     * @param line CSV`̕
     * @param delim ؂蕶
     * @return ؂ꂽ̔z
     * @since 1.0
     */
    public static String[] csvSplit(String line, String delim) {
        return StringUtil.csvSplit(line, delim, '"');
    }

    /**
     * CSV`̕𕪊܂B
     * ͂ň͂܂ꂽ̋؂蕶͖܂B
     * Ȃ؂蕶ƈ͂𓙉̕w肷邱Ƃ͂ł܂B
     * 
     * @param line CSV`̕
     * @param delim ؂蕶
     * @param quot ͂
     * @return ؂ꂽ̔z
     * @since 2.0
     */
    public static String[] csvSplit(String line, String delim, char quot) {
        
        if (line == null) {
            return null;
        }
        
        if (delim == null || delim.length() < 1) {
            throw new IllegalArgumentException();
        }
        
        if (line.indexOf(quot) == -1) {
            return line.split(delim);
        }
        
        int index = 0;        
        int delimX = line.indexOf(delim);
        int quotX = line.indexOf(quot);
        final int delimLength = delim.length();
        final int quotLength = 1;
        ArrayList list = new ArrayList();
        
        while(true) {
            
            if (delimX == -1) {
                list.add(StringUtil.csvConvert(line.substring(index), quot));
                break;
            }
            
            if (delimX < quotX || quotX == -1) {
                list.add(StringUtil.csvConvert(line.substring(index, delimX), quot));
                index = delimX + delimLength;
                delimX = line.indexOf(delim, index);
                quotX = line.indexOf(quot, index);
                continue;
            }
            
            quotX = line.indexOf(quot, quotX + quotLength);
            if (quotX == -1) {
                list.add(StringUtil.csvConvert(line.substring(index), quot));
                break;
            }
            delimX = line.indexOf(delim, quotX + quotLength);
            quotX = line.indexOf(quot, quotX + quotLength);
            
        }
        
        return (String[]) list.toArray(new String[]{});
    }

    /**
     * K\gȂŕ؂蕶ŋ؂AzƂĎ擾܂B
     * Ώۂ̕ɋ󕶎w肳ꂽꍇ͒O̕z擾܂B
     * 
     * @param str 
     * @param delim ؂蕶
     * @return ؂z
     * @throws NullPointerException
     *          A͑Ώۂ̕ null ̏ꍇ
     * @since 2.0
     */
    public static String[] split(String str, String delim) {
        if (str == null || delim == null) {
            throw new NullPointerException("The values of argument are null.");
        }
        List l = new ArrayList();
        StringTokenizer st = new StringTokenizer(str, delim);
        while(st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        return (String[])l.toArray(new String[]{});
    }

    // Unicode 16 iϊ
    private static String toUnicodeHex(String str, int stat) {        
        if (str == null) {
            return null;
        }
        
        if (str.length() < 1) {
            return "";
        }
        
        char[] c = str.toCharArray();
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < c.length; i++) {
            if(c[i] <= 127){
                if(stat == UNICODE_ALL){
                    ret.append("\\u");
                    ret.append(StringUtil.toHexFromBytes(c[i]));
                } else if(stat == UNICODE_MULTIBYTE){
                    ret.append(c[i]);
                }
            } else {
                ret.append("\\u");
                ret.append(StringUtil.toHexFromBytes(c[i]));
            }
        }
        
        return ret.toString();
    }

    private static StringBuffer toHexFromBytes(char c) {
        StringBuffer sb = new StringBuffer(Integer.toHexString(c));
        for (int i = 0; sb.length() < 4; i++) {
            sb.insert(0, 0);
        }
        return sb;
    }

    private static String csvConvert(String str, char quot) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < str.length(); i++) {
            char c = str.charAt(i);
            if (c == quot) {
                if (i == str.length() - 1) {
                } else {
                    buf.append(str.charAt(++i));
                }
            } else {
                buf.append(c);
            }
        }
        
        return buf.toString();
    }


    /**
     * int^32rbg2ĩrbgɕϊ܂B
     * 
     * @param number rbgɕϊ鐮
     * @return ϊ̕
     * @since 2.0
     */
    public static String toBinaryString(int number) {
        StringBuffer sb = new StringBuffer(Integer.toBinaryString(number));
        for (int j = sb.length(); j < 32; j++) {
            sb.insert(0, 0);
        }
        return sb.toString();
    }


    /**
     * 0ȏ̐̌w茅܂ŒBĂȂꍇɐ擪0ĕ⊮܂B
     * ̌w肵傫ꍇ͉܂B
     * 
     * @param number 0⊮鐮
     * @param digit 0⊮錅
     * @return 0̕⊮̕
     * @throws IllegalArgumentException
     *          numberdigit̏ꍇ
     * @since 2.0
     */
    public static String completeZero(int number, int digit) {
        if (number < 0 || digit < 0) {
            throw new IllegalArgumentException("The argument can not specify a negative value.");
        }
        StringBuffer sb = new StringBuffer(Integer.toString(number));
        for (int j = sb.length(); j < digit; j++) {
            sb.insert(0, 0);
        }
        return sb.toString();
    }

    

}
