package jp.hrtdotnet.java.io;

import java.io.File;
import java.io.IOException;

import jp.hrtdotnet.java.HTestCase;

public class HDirectoryTest extends HTestCase {

    /* ( Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /* ( Javadoc)
     * @see junit.framework.TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * {@link jp.hrtdotnet.java.io.HDirectory#createNewFile()} ̂߂̃eXgE\bhB
     */
    public void testCreateNewFile() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.java.io.HDirectory#HDirectory(java.lang.String)} ̂߂̃eXgE\bhB
     * @throws IOException 
     */
    public void testHDirectory() throws IOException {
        String tmp = System.getProperty("java.io.tmpdir");
        File f = new File(tmp + "file");
        if (f.exists() && f.isDirectory()) {
            throw new RuntimeException();
        }
        if (!f.exists()) {
            f.createNewFile();
        }
        
        new HDirectory(tmp);

        try {
            new HDirectory(tmp + ".");
            fail();
        } catch (IOException e) {
        }

        try {
            new HDirectory(tmp + "file");
            fail();
        } catch (IOException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.java.io.HDirectory#checkDirectoryName(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testCheckDirectoryName() {
        assertTrue(HDirectory.checkDirectoryName("C:\\dir"));
        assertTrue(HDirectory.checkDirectoryName("/home/user"));
    }
}
