/*
 * Decompiled with CFR 0.152.
 */
package jp.hrtdotnet.java.net;

public class NetUtil {
    public static final int MAC_ADDRESS_LENGTH = 6;

    public static byte[] octetMacAddress(String macAddress) {
        return NetUtil.octetMacAddress(macAddress, "(\\:|\\-)");
    }

    public static byte[] octetMacAddress(String macAddress, String delim) {
        int i;
        byte[] byteMacAddress = null;
        String[] splitMacAddress = null;
        if (macAddress == null) {
            throw new NullPointerException("Mac-Address is null.");
        }
        if (delim == null || delim.length() == 0) {
            if (macAddress.length() != 12) {
                throw new IllegalArgumentException("Mac-Address is invalid : " + macAddress);
            }
            splitMacAddress = new String[6];
            for (i = 0; i < 6; ++i) {
                int index = i * 2;
                splitMacAddress[i] = macAddress.substring(index, index + 2);
            }
        } else {
            splitMacAddress = macAddress.split(delim);
            if (splitMacAddress.length != 6) {
                throw new IllegalArgumentException("Mac-Address is invalid : " + macAddress + ", " + delim);
            }
        }
        byteMacAddress = new byte[6];
        for (i = 0; i < 6; ++i) {
            byteMacAddress[i] = (byte)Integer.parseInt(splitMacAddress[i], 16);
        }
        return byteMacAddress;
    }
}

