/*
 * HWriterTest.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */

package jp.hrtdotnet.java.io;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import jp.hrtdotnet.java.HTestCase;

/**
 *
 * @version 
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 
 */
public class HWriterTest extends HTestCase {

    /* ( Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /* ( Javadoc)
     * @see junit.framework.TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * {@link jp.hrtdotnet.java.io.HWriter#write(java.io.InputStream, java.io.OutputStream)} ̂߂̃eXgE\bhB
     * @throws IOException 
     */
    public void testWrite() throws IOException {
        HWriter writer = new HWriter() {
        };
        
        FileInputStream fis = null;
        FileOutputStream fos = null;

        try {
            fis = new FileInputStream(getTestTxtPath());
            fos = new FileOutputStream(getTmpFilePath("HWriterTest_testWrite", "txt", true));
            writer.write(fis, fos);

            fis = new FileInputStream(getTestPngPath());
            fos = new FileOutputStream(getTmpFilePath("HWriterTest_testWrite", "png", true));
            writer.write(fis, fos);
            
        } finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }
}
