/*
 * SyetemUtil.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */
package jp.hrtdotnet.java.util;

import java.util.Timer;
import java.util.TimerTask;


/**
 * Ƀ`FbNɊւ鏈VXeǗNXłB
 * gpʂ̃`FbN݁A͒IɍsƂ\ŁA`FbNʂɉ邱Ƃł܂B
 * ܂`FbN̑Adl◘p\擾邱Ƃł܂B
 * <br><br>
 * {IɊg邱ƂlčĂ܂񂪁AIȃ`FbN
 * 邽߂ɂ̓`FbN̏I[o[ChēƎ̎Kv܂B
 * 
 * @version 2.0
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.0
 */
public class SystemUtil {

    /** ő僁gpʂ̃`FbNsXe[^XR[hłB */
    public final static int MAXIMIZE_USEDMEMORY_SIZE = 1;
    /** ő僁gp̃`FbNsXe[^XR[hłB */
    public final static int MAXIMIZE_USEDMEMORY_PERCENTAGE = 2;    

    /** ő僁gpʂłB */
    protected long maximizeMemorySize = 0L;
    /** ő僁gpłB */
    protected int maximizeMemoryPercentage = 0;

    // ̃oϐ͊gNXɒڎg킹Ȃ
    private int status = 0;
    private boolean maximizeUsedMemorySizeFlg = false;
    private boolean maximizeUsedMemoryPercentageFlg = false;    
    private Timer timer;
    
    /**
     * JavaVMp\ȃ̏l擾܂B
     * JavaVMl̃̈mۂĂ킯ł͂ȂA
     * ۂ̒l͕≼z̋󂫋ɂ܂B
     * 
     * @return mۂ邱Ƃŗp\ȃ̏l
     * @since 2.0
     */
    public static long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    /**
     * JavaVM݊mۂĂ郁̈̂p\ȃTCY擾܂B
     * 
     * @return ݗpł郁TCY
     * @since 2.0
     */
    public static long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    /**
     * JavaVM݊mۂĂ郁̈̃TCY擾܂B
     * 
     * @return ݊mۂĂ郁TCY
     * @since 2.0
     */
    public static long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();        
    }
 
    /**
     * JavaVMݗpĂ郁TCY擾܂B
     * 
     * @return pĂ郁TCY
     * @since 2.0
     */
    public static long getUsedMemory() {
        return getTotalMemory() - getFreeMemory();
    }

    
    /**
     * `FbNp̃IuWFNg𐶐܂B
     * `FbN鍀ڂ̃Xe[^XR[h⃁̎gpʂgp̏lݒ肵A
     * `FbN邱Ƃł܂BȂݒl̓RXgN^ł̂
     * ݒ肷邱Ƃł܂B
     * <br><br>
     * Xe[^XR[heڂ̃Xe[^XR[h̘_aw肵܂B
     * Xe[^XR[h͈ȉ̒ʂłB
     * <ul>
     * <li>MAXIMIZE_USEDMEMORY_SIZEFgpʂ̏l̃`FbN</li>
     * <li>MAXIMIZE_USEDMEMORY_PERCENTAGEFgp̏l̃`FbN</li>
     * </ul>
     * Ⴆ΃̎gpʂƎgp̗`FbNꍇ́A
     * statusMAXIMIZE_USEDMEMORY_SIZEMAXIMIZE_USEDMEMORY_PERCENTAGE̘aw肵܂B
     * 
     * @param status `FbN鍀ڂ̃Xe[^XR[h
     * @param maximizeMemorySize gpʂ̏l
     * @param maximizeMemoryPercentage gp̏l
     * @since 2.0
     */
    public SystemUtil(int status, long maximizeMemorySize, int maximizeMemoryPercentage) {
        this.status = status;
        setStatus();
        this.maximizeMemorySize = maximizeMemorySize;
        if (maximizeUsedMemorySizeFlg) {
            if (maximizeMemorySize <= 0) {
                throw new IllegalArgumentException();
            }
        }
        this.maximizeMemoryPercentage = maximizeMemoryPercentage;
        if (maximizeUsedMemoryPercentageFlg) {
            if (maximizeMemoryPercentage <= 0) {
                throw new IllegalArgumentException();
            }
        }
    }
    
    /**
     * ݒɃ̃`FbNǍʂ擾܂B
     * 
     * @return `FbNŔ͈͓łtrueA͈͊Ołfalse
     * @since 2.0
     */
    public boolean check() {
        if(this.maximizeUsedMemorySizeFlg) {
            if (!usedMemorySizeCheck()) {
                return false;
            }
        }        
        if (this.maximizeUsedMemoryPercentageFlg) {
            if (!usedMemoryPercentageCheck()) {
                return false;
            }
        }
        return true;
    }

    /**
     * ̎gpʂw肵l𒴂ĂȂ`FbN܂B
     * 
     * @return `FbNŔ͈͓łtrueA͈͊Ołfalse
     * @since 2.0
     */
    public boolean usedMemorySizeCheck() {
        try {
            return usedMemorySizeCheck(maximizeMemorySize);
        } catch (IllegalArgumentException et) {
            throw new IllegalStateException("The maximizeMemorySize is illegal status.");
        }
    }
    

    /**
     * ̎gpʂw肵l𒴂ĂȂ`FbN܂B
     * gpʂƏlꍇ͔͈͓ƂȂ܂B
     * 
     * @param maximizeMemorySize gpʂ̏l
     * @return `FbNŔ͈͓łtrueA͈͊Ołfalse
     * @since 2.0
     */
    public static boolean usedMemorySizeCheck(long maximizeMemorySize) {
        if(maximizeMemorySize <= 0) {
            throw new IllegalArgumentException("Memory-size <= 0.");
        }
        if(maximizeMemorySize < getUsedMemory()) {
            return false;
        }
        return true;
    }

    /**
     * ̎gpw肵w肵l𒴂ĂȂ`FbN܂B
     * 
     * @return `FbNŔ͈͓łtrueA͈͊Ołfalse
     * @since 2.0
     */
    public boolean usedMemoryPercentageCheck() {
        try {
            return usedMemoryPercentageCheck(maximizeMemoryPercentage);
        } catch (IllegalArgumentException et) {
            throw new IllegalStateException("The maximizeMemorySize is illegal status.");
        }        
    }

    /**
     * ̎gpw肵w肵l𒴂ĂȂ`FbN܂B
     * 
     * @param maximizeMemoryPercentage `FbN郁gp̏l
     * @return `FbNŔ͈͓łtrueA͈͊Ołfalse
     * @since 2.0
     */
    public static boolean usedMemoryPercentageCheck(int maximizeMemoryPercentage) {
        if(maximizeMemoryPercentage <= 0 || maximizeMemoryPercentage > 100) {
            throw new IllegalArgumentException("Memory-size <= 0 or Memory-size > 100.");
        }
        if(maximizeMemoryPercentage < (double)getUsedMemory() / getTotalMemory() * 100) {
            return false;
        }
        return true;
    }

    /**
     * `FbÑ^C}[Jn܂B
     * IuWFNg̃^C}[łɊJnĂꍇIllegalStateExceptionԂ܂B
     * ܂`FbNԊu0~bȉ̏ꍇIllegalArgumentExceptionԂ܂B
     * 
     * @param period `FbN^C}[̊Ԋui~bj
     * @throws IllegalArgumentException ^C}[̊Ԋu 0 ȉ (<= 0) ̏ꍇ
     * @throws IllegalStateException
     *          ^C}[łɊJnĂꍇ
     * @since 2.0
     */
    public synchronized void timerStart(long period) {
        if (period <= 0) {
            throw new IllegalArgumentException("Timer is equal to or less than 0 milliseconds.");
        }
        if (timer != null) {
            throw new IllegalStateException("Timer is starting now.");
        }
        TimerTask tt = new MemoryCheckTimerTask(this);
        timer = new Timer();
        timer.schedule(tt, 0, period);
    }
    

    /**
     * `FbÑ^C}[I܂B
     * IuWFNg̃^C}[JnĂȂꍇIllegalStateExceptionԂ܂B
     * 
     * @throws IllegalStateException
     *          ^C}[JnĂȂꍇ
     * @since 2.0
     */
    public synchronized void timerCancel() {
        if (timer == null) {
            throw new IllegalStateException("Timer is not starting now");
        }
        timer.cancel();
        timer = null;
    }
    
    /**
     * ^C}[쒆iJnĂjǂ𔻒肵܂B
     * 
     * @return 쒆łtrueAJnĂȂfalse
     * @since 2.0
     */
    public synchronized boolean isRunTimer() {
        return timer == null ? false : true;
    }
    
    
    /**
     * `FbNڂݒ肷邽߂̃Xe[^Xw肵܂B
     * 
     * @since 2.0
     */
    protected void setStatus() {
        int stat = status;
        if (stat % 2 == 1) {
            this.maximizeUsedMemorySizeFlg = true;
        }
        stat = stat / 2;
        if (stat % 2 == 1) {
            this.maximizeUsedMemoryPercentageFlg = true;
        }
    }
    
    /**
     * ^C}[ɂIȃ`FbNꍇ
     * ̏l͈͓ł΂̃\bh܂B
     * <br><br>
     * p҂œ̏ꍇ͂̃\bhI[o[ChKv܂B
     * 
     * @since 2.0
     */
    protected void runCheckFalse() {
    }

    /**
     * ^C}[ɂIȃ`FbNꍇ
     * ̏l͈͊Oł΂̃\bh܂B
     * <br><br>
     * p҂œ̏ꍇ͂̃\bhI[o[ChKv܂B
     * 
     * @since 2.0
     */
    protected void runCheckTrue() {
    }

}

class MemoryCheckTimerTask extends TimerTask {

    SystemUtil m = null;
    
    MemoryCheckTimerTask(SystemUtil m) {        
        if (m == null) {
            throw new IllegalStateException();
        }
        this.m = m;
    }
    
    public void run() {
        if (m.check()) {
            m.runCheckTrue();
        } else {
            m.runCheckFalse();
        }
    }
    
}