package jp.hrtdotnet.java;

import java.io.File;
import java.util.Calendar;

import junit.framework.TestCase;

public class HTestCase extends TestCase {

    protected TestResources testClassResources = null;
    protected TestResources testResources = null;
    
    public HTestCase() {
        testResources = TestResources.getInstance(this.getClass());
        testClassResources = TestClassResources.getInstance(this.getClass());
    }
    
    public String getTestTxtPath() {
        return testResources.getString("test.txt");
    }
    
    public String getTestPngPath() {
        return testResources.getString("test.png");
    }

    public String getTmpFilePath(String fileName, String kakuchoshi, boolean time) {
        return getTmpFilePath(fileName, kakuchoshi, time, null);
    }

    public String getTmpFilePath(String fileName, String kakuchoshi, boolean time, boolean dirTime) {
        String directory = null;
        if (dirTime) {
            directory = String.valueOf(Calendar.getInstance().getTime().getTime());
        }
        return getTmpFilePath(fileName, kakuchoshi, time, directory);
    }
    
    
    public String getTmpFilePath(String fileName, String kakuchoshi, boolean time, String directory) {
        
        String tmpFilePath = getTmpDirectoryPath() + File.separator;
        if (directory != null && directory.length() != 0) {
            tmpFilePath += directory + File.separator;
        }
        tmpFilePath += fileName;
        if (time) {
            tmpFilePath += "." + Calendar.getInstance().getTime().getTime();
        }
        if (kakuchoshi != null && kakuchoshi.length() != 0 ) {
            tmpFilePath += "." + kakuchoshi;
        }
        return tmpFilePath;
    }

    public String getTmpDirectoryPath(boolean time) {
        String path = System.getProperty("java.io.tmpdir");
        if (time) {
            path += File.separator + Calendar.getInstance().getTime().getTime();
        }
        return path;
    }
    
    public String getTmpDirectoryPath() {
        return getTmpDirectoryPath(false);
    }
    
}
