/*
 * HExceptionResources.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */
package jp.hrtdotnet.fw;

import jp.hrtdotnet.fw.util.HResourceBundleResources;

/**
 * ÕbZ[W̃\[XłB
 * 
 * @version 2.0
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.0
 */
public class HExceptionResources extends HResourceBundleResources {

    protected static final String DEFAULT_MESSAGE = "Undefined error occured.";

    /**
     * RXgN^B
     * @param baseName \[Xoh(NXpX̃pX)
     * @since 2.0
     */
    public HExceptionResources(String baseName) {
        super(baseName);
    }

    /**
     * vpeBt@CG[bZ[W擾܂B
     * `ĂȂꍇAw肵bZ[W擾܂B
     * 
     * @param cls NX(vpeBt@C̃L[ɒ`)
     * @param errorCode L[(G[R[h)
     * @param msg L[݂Ȃꍇ̃bZ[W
     * @return bZ[W
     * @since 2.0
     */
    public String getString(Class cls, String errorCode, String msg) {
        return getString(cls.getName() + "." + errorCode, msg);
    }

    /**
     * vpeBt@CG[bZ[W擾܂B
     * `ĂȂꍇAftHgbZ[W(DEFAULT_MESSAGE)擾܂B
     * 
     * @param cls NX(vpeBt@C̃L[ɒ`)
     * @param errorCode L[(G[R[h)
     * @return bZ[W
     * @since 2.0
     */
    public String getString(Class cls, String errorCode) {
        return getString(cls, errorCode, DEFAULT_MESSAGE);
    }
    
    /**
     * vpeBt@CG[bZ[W擾܂B
     * `ĂȂꍇAw肵bZ[W擾܂B
     * 
     * @param errorCode L[(G[R[h)
     * @param msg L[݂Ȃꍇ̃bZ[W
     * @return bZ[W
     * @since 2.0
     */
    public String getString(String errorCode, String msg) {
        String retMsg = super.getString(errorCode);
        if (retMsg == null) {
            retMsg = msg;
        }
        return retMsg;
    }

    /**
     * vpeBt@CG[bZ[W擾܂B
     * `ĂȂꍇAftHgbZ[W(DEFAULT_MESSAGE)擾܂B
     * 
     * @param errorCode L[
     * @return bZ[W
     * @since 2.0
     */
    public String getString(String errorCode) {
        return getString(errorCode, DEFAULT_MESSAGE);
    }

    /**
     * vpeBt@CG[bZ[W擾܂B
     * `ĂȂꍇAw肵bZ[W擾܂B
     * 
     * @param cls NX(vpeBt@C̃L[ɒ`)
     * @param errorCode L[(G[R[h)
     * @param msg L[݂Ȃꍇ̃bZ[W
     * @return bZ[W
     * @since 2.0
     */
    public String getString(Class cls, int errorCode, String msg) {
        return getString(cls.getName() + "." + String.valueOf(errorCode), msg);
    }

    /**
     * vpeBt@CG[bZ[W擾܂B
     * `ĂȂꍇAftHgbZ[W(DEFAULT_MESSAGE)擾܂B
     * 
     * @param cls NX(vpeBt@C̃L[ɒ`)
     * @param errorCode L[(G[R[h)
     * @return bZ[W
     * @since 2.0
     */
    public String getString(Class cls, int errorCode) {
        return getString(cls, errorCode, DEFAULT_MESSAGE);
    }
    
    /**
     * vpeBt@CG[bZ[W擾܂B
     * `ĂȂꍇAw肵bZ[W擾܂B
     * 
     * @param errorCode L[(G[R[h)
     * @param msg L[݂Ȃꍇ̃bZ[W
     * @return bZ[W
     * @since 2.0
     */
    public String getString(int errorCode, String msg) {
        String retMsg = super.getString(String.valueOf(errorCode));
        if (retMsg == null) {
            retMsg = msg;
        }
        return retMsg;
    }

    /**
     * vpeBt@CG[bZ[W擾܂B
     * `ĂȂꍇAftHgbZ[W(DEFAULT_MESSAGE)擾܂B
     * 
     * @param errorCode L[
     * @return bZ[W
     * @since 2.0
     */
    public String getString(int errorCode) {
        return getString(errorCode, DEFAULT_MESSAGE);
    }
    
}
