package jp.hrtdotnet.fw;

import jp.hrtdotnet.java.HTestCase;

public class HRuntimeExceptionTest extends HTestCase {

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * {@link jp.hrtdotnet.fw.HRuntimeException#HRuntimeException(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testHRuntimeExceptionString() {
        String msg = "testmsg";
        HRuntimeExceptionTest1 e = new HRuntimeExceptionTest1(msg);
        assertEquals(msg, e.getMessage());
    }

    /**
     * {@link jp.hrtdotnet.fw.HRuntimeException#HRuntimeException(java.lang.Throwable)} ̂߂̃eXgE\bhB
     */
    public void testHRuntimeExceptionThrowable() {
        String msg = "e1-msg";
        Exception e1 = new Exception(msg);
        HRuntimeExceptionTest1 e = new HRuntimeExceptionTest1(e1);
        assertEquals("java.lang.Exception: " + msg, e.getMessage());
    }

    /**
     * {@link jp.hrtdotnet.fw.HRuntimeException#HRuntimeException(java.lang.String, java.lang.Throwable)} ̂߂̃eXgE\bhB
     */
    public void testHRuntimeExceptionStringThrowable() {
        String msg1 = "e1-msg1";
        String msg2 = "e1-msg2";
        Exception e1 = new Exception(msg1);
        HRuntimeExceptionTest1 e = new HRuntimeExceptionTest1(msg2, e1);
        assertEquals(msg2, e.getMessage());
    }

    /**
     * {@link jp.hrtdotnet.fw.HRuntimeException#HRuntimeException()} ̂߂̃eXgE\bhB
     */
    public void testHRuntimeException() {
        HRuntimeExceptionTest1 e = new HRuntimeExceptionTest1();
        assertEquals(null, e.getMessage());
    }

    /**
     * {@link jp.hrtdotnet.fw.HRuntimeException#HRuntimeException(java.lang.Class, java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testHRuntimeExceptionClassString() {
        String msg1 = "e1-msg1";
        String errorCode = "test11";
        Exception e1 = new Exception(msg1);
        HRuntimeExceptionTest1 e = new HRuntimeExceptionTest1(this.getClass(), errorCode, e1);
        assertEquals("eXgPP", e.getMessage());
        assertEquals("test11", e.getErrorCode());
    }

    /**
     * {@link jp.hrtdotnet.fw.HRuntimeException#HRuntimeException(java.lang.Class, java.lang.String, java.lang.Throwable)} ̂߂̃eXgE\bhB
     */
    public void testHRuntimeExceptionClassStringThrowable() {
        String errorCode = "test12";
        HRuntimeExceptionTest1 e = new HRuntimeExceptionTest1(this.getClass(), errorCode);
        assertEquals("eXgPQ", e.getMessage());
        assertEquals("test12", e.getErrorCode());
    }

    /**
     * {@link jp.hrtdotnet.fw.HRuntimeException#getErrorCode()} ̂߂̃eXgE\bhB
     */
    public void testGetErrorCode() {
        String errorCode = "test13";
        HRuntimeExceptionTest1 e = new HRuntimeExceptionTest1(this.getClass(), errorCode);
        assertEquals("test13", e.getErrorCode());
    }

    /**
     * {@link jp.hrtdotnet.fw.HRuntimeException#getMessage()} ̂߂̃eXgE\bhB
     */
    public void testGetMessage() {
        String errorCode = "test14";
        HRuntimeExceptionTest1 e = new HRuntimeExceptionTest1(this.getClass(), errorCode);
        assertEquals("eXgPS", e.getMessage());
    }

    /**
     * {@link jp.hrtdotnet.fw.HRuntimeException#getMessage(java.lang.Class, java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testGetMessageClassString() {
        String errorCode = "test15";
        HRuntimeExceptionTest1 e = new HRuntimeExceptionTest1(this.getClass(), errorCode);
        assertEquals("eXgPT", e.getMessage(this.getClass(), errorCode));

        errorCode = "test16";
        e = new HRuntimeExceptionTest1(this.getClass(), errorCode);
        assertEquals("eXgPU", e.getMessage(null, errorCode));
    }    

    class HRuntimeExceptionTest1 extends HRuntimeException {

        /**
         * 
         */
        private static final long serialVersionUID = -5775772247392081859L;

        public HRuntimeExceptionTest1() {
            super();
        }

        public HRuntimeExceptionTest1(Class cls, String errorCode, Throwable cause) {
            super(cls, errorCode, cause);
        }

        public HRuntimeExceptionTest1(Class cls, String errorCode) {
            super(cls, errorCode);
        }

        public HRuntimeExceptionTest1(String message, Throwable cause) {
            super(message, cause);
        }

        public HRuntimeExceptionTest1(String message) {
            super(message);
        }

        public HRuntimeExceptionTest1(Throwable cause) {
            super(cause);
        }        
    
    }
    
    
}
