/*
 * HPasswordDigestTest.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */

package jp.hrtdotnet.fw.util.password;

import jp.hrtdotnet.java.HTestCase;


/**
 *
 * @version 
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 
 */
public class HPasswordDigestTest extends HTestCase {

    /* ( Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /* ( Javadoc)
     * @see junit.framework.TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * {@link jp.hrtdotnet.fw.util.password.HPasswordDigest#encrypt(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testEncrypt() {
        HPasswordDigest password = null;
        String test1 = null;
        String test2 = null;

        password = new HPasswordDigest(HPasswordDigest.BYTE32);
        test1 = password.encrypt("test");
        test2 = password.encrypt("test");
        assertEquals(test1, test2);
        assertEquals(32, test1.length());

        password = new HPasswordDigest(HPasswordDigest.BYTE40);
        test1 = password.encrypt("test");
        test2 = password.encrypt("test");
        assertEquals(test1, test2);
        assertEquals(40, test1.length());

        password = new HPasswordDigest(HPasswordDigest.BYTE64);
        test1 = password.encrypt("test");
        test2 = password.encrypt("test");
        assertEquals(test1, test2);
        assertEquals(64, test1.length());

        password = new HPasswordDigest(HPasswordDigest.BYTE96);
        test1 = password.encrypt("test");
        test2 = password.encrypt("test");
        assertEquals(test1, test2);
        assertEquals(96, test1.length());

        password = new HPasswordDigest(HPasswordDigest.BYTE128);
        test1 = password.encrypt("test");
        test2 = password.encrypt("test");
        assertEquals(test1, test2);
        assertEquals(128, test1.length());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.password.HPasswordDigest#HPasswordDigest(int)} ̂߂̃eXgE\bhB
     */
    public void testHPasswordDigest() {
        new HPasswordDigest(HPasswordDigest.BYTE32);
        new HPasswordDigest(HPasswordDigest.BYTE40);
        new HPasswordDigest(HPasswordDigest.BYTE64);
        new HPasswordDigest(HPasswordDigest.BYTE96);
        new HPasswordDigest(HPasswordDigest.BYTE128);
        try {
            new HPasswordDigest(-1);
            fail();
        } catch (IllegalArgumentException e) {
            
        }
    }

}
