/*
 * Decompiled with CFR 0.152.
 */
package jp.hrtdotnet.java.util;

import java.util.ArrayList;

public class CSVUtil {
    private char delim;
    private char enclosingChar;
    private boolean enclosing = false;

    public CSVUtil(char delim) {
        this.delim = delim;
    }

    public CSVUtil(char delim, char enclosingChar) {
        this.delim = delim;
        this.enclosingChar = enclosingChar;
        this.enclosing = true;
    }

    public String[] split(String str) {
        if (str == null) {
            throw new NullPointerException("str is null.");
        }
        ArrayList<String> retList = new ArrayList<String>();
        boolean enclosingFlag = false;
        StringBuffer oneData = new StringBuffer("");
        char[] strChars = str.toCharArray();
        for (int index = 0; index < strChars.length; ++index) {
            if (strChars[index] == this.enclosingChar) {
                if (enclosingFlag) {
                    enclosingFlag = false;
                    continue;
                }
                enclosingFlag = true;
                continue;
            }
            if (strChars[index] == this.delim && !enclosingFlag) {
                retList.add(oneData.toString());
                oneData = new StringBuffer("");
                continue;
            }
            oneData.append(strChars[index]);
        }
        retList.add(oneData.toString());
        return retList.toArray(new String[0]);
    }

    public String toCSV(String[] data) {
        if (data == null) {
            throw new NullPointerException("data is null.");
        }
        StringBuffer retCSV = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            if (i != 0) {
                retCSV.append(this.delim);
            }
            if (this.enclosing) {
                retCSV.append(this.enclosingChar);
            }
            retCSV.append(data[i]);
            if (!this.enclosing) continue;
            retCSV.append(this.enclosingChar);
        }
        return retCSV.toString();
    }

    public String[] toCSV(String[][] data) {
        if (data == null) {
            throw new NullPointerException("data is null.");
        }
        String[] retCSV = new String[data.length];
        for (int i = 0; i < data.length; ++i) {
            retCSV[i] = this.toCSV(data[i]);
        }
        return retCSV;
    }
}

