/*
 * Decompiled with CFR 0.152.
 */
package jp.hrtdotnet.java.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import jp.hrtdotnet.java.io.HDirectory;
import jp.hrtdotnet.java.io.HFile;

public class HProperties
extends Properties {
    private static final long serialVersionUID = 8613893331398624211L;
    protected Map map = Collections.synchronizedMap(new LinkedHashMap());

    public HProperties() {
        this((HProperties)null);
    }

    public HProperties(HProperties prop) {
        if (prop != null) {
            Enumeration e = prop.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.setProperty(key, prop.getProperty(key));
            }
        }
    }

    public synchronized Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    public synchronized Object put(Object key, Object value) {
        return this.map.put(key, value);
    }

    public synchronized Enumeration keys() {
        return Collections.enumeration(this.map.keySet());
    }

    public synchronized Enumeration propertyNames() {
        return this.keys();
    }

    public String getProperty(String key) {
        return (String)this.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    public void store(String filePath, String header) throws IOException {
        this.store(filePath, header, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String filePath, String header, boolean b) throws IOException {
        if (filePath == null) {
            throw new NullPointerException("filePath == null");
        }
        HProperties prop = new HProperties();
        if (b) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(filePath);
                prop.load(is);
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
        }
        prop.map.putAll(this.map);
        OutputStream os = null;
        try {
            HFile f = null;
            f = new HFile(filePath);
            HDirectory d = new HDirectory(f.getParent());
            if (!d.exists()) {
                d.mkdirs();
            }
            os = new FileOutputStream(f);
            prop.store(os, header);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    public void store(OutputStream out, String header) throws IOException {
        super.store(out, header);
    }

    public void list(PrintStream out) {
        out.println("-- listing properties --");
        LinkedHashMap map = new LinkedHashMap();
        this.enumerate(map);
        Enumeration e = Collections.enumeration(map.keySet());
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)map.get(key);
            out.println(key + "=" + value);
        }
        out.flush();
    }

    public void list(PrintWriter out) {
        out.println("-- listing properties --");
        LinkedHashMap map = new LinkedHashMap();
        this.enumerate(map);
        Enumeration e = Collections.enumeration(map.keySet());
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)map.get(key);
            out.println(key + "=" + value);
        }
        out.flush();
    }

    private synchronized void enumerate(Map m) {
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            m.put(key, this.get(key));
        }
    }
}

