/*
 * CSVUtil.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */
package jp.hrtdotnet.java.util;

import java.util.ArrayList;
import java.util.List;

/**
 * CSṼ[eBeBNXłB
 * 
 * @version 2.2
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.2
 */
public class CSVUtil {

    private char delim;
    private char enclosingChar;
    private boolean enclosing = false;
//    private String delimString = null;
//    private String enclosingString = null;
//    private boolean stringFlag = false;
    
    public CSVUtil(char delim) {
        this.delim = delim;
    }
    
    public CSVUtil(char delim, char enclosingChar) {
        this.delim = delim;
        this.enclosingChar = enclosingChar;
        this.enclosing = true;
    }
    
//    public CSVUtil(String delimString) {
//        this.delimString = delimString;
//        this.stringFlag = true;
//    }
//    
//    public CSVUtil(String delimString, String enclosingString) {
//        this.delimString = delimString;
//        this.enclosingString = enclosingString;
//        this.stringFlag = true;
//    }

    /**
     * CSV𕪊܂B
     * @param str 镶
     * @return ꂽz
     * @throws NullPointerException strnull
     */
    public String[] split(String str) {
        //񂪋
        if (str == null) {
            throw new NullPointerException("str is null.");
        }
        //ʂ̔z
        List/*<String>*/ retList = new ArrayList/*<String>*/();

        //ʒu
        int index = 0;
        //͂
        boolean enclosingFlag = false;
        //؂P
        StringBuffer oneData = new StringBuffer("");
        
        char[] strChars = str.toCharArray();
        while (index < strChars.length) {

            //͂
            if (strChars[index] == this.enclosingChar) {
                //I
                if (enclosingFlag == true) {
                    enclosingFlag = false;
                //Jn
                } else {
                    enclosingFlag = true;
                }

            //؂蕶͂ł͂Ȃ
            } else if (strChars[index] == this.delim && enclosingFlag == false) {
                retList.add(oneData.toString());
                oneData = new StringBuffer("");

            //ȊO
            } else {
                oneData.append(strChars[index]);
            }
            index++;
        }

        //Ō̌ʂǉ
        retList.add(oneData.toString());
        return (String[])retList.toArray(new String[0]);
    }

    /**
     * CSV̕쐬܂B
     * @param data CSVf[^z[f[^]
     * @return CSV
     * @throws NullPointerException datanull
     */
    public String toCSV(String[] data) {
        //CSṼf[^
        if (data == null) {
            throw new NullPointerException("data is null.");
        }
        //
        StringBuffer retCSV = new StringBuffer();

        //CSV̍쐬
        for (int i = 0; i < data.length; i++) {
            //؂蕶
            if (i != 0) {
                retCSV.append(delim);
            }

            //͂(O)
            if (enclosing == true) {
                retCSV.append(enclosingChar);
            }

            //CSVo
            retCSV.append(data[i]);

            //͂()
            if (enclosing == true) {
                retCSV.append(enclosingChar);
            }
        }
        return retCSV.toString();
    }

    /**
     * sCSV`̕쐬܂B
     * @param data CSVf[^z[s][f[^]
     * @return CSV̔z
     * @throws NullPointerException datanull
     */
    public String[] toCSV(String[][] data) {
        //CSṼf[^
        if (data == null) {
            throw new NullPointerException("data is null.");
        }
        //
        String[] retCSV = new String[data.length];

        //CSV
        for (int i = 0; i < data.length; i++) {
            retCSV[i] = toCSV(data[i]);
        }
        return retCSV;
    }
}
