/*
 * NetUtilTest.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */

package jp.hrtdotnet.java.net;

import junit.framework.TestCase;

/**
 *
 * @version 
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 
 */
public class NetUtilTest extends TestCase {

    /* ( Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /* ( Javadoc)
     * @see junit.framework.TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }
    
    private static final String MAC_ADDRESS = "01:23:45:67:89:AB";
    private static final String MAC_ADDRESS2 = "01-23-45-67-89-AB";
    private static final String MAC_ADDRESS3 = "01;23;45;67;89;AB";
    private static final String MAC_ADDRESS4 = "0123456789AB";
    private static final byte[] OCTET_MAC_ADDRESS = {(byte)0x01,(byte)0x23,(byte)0x45,(byte)0x67,(byte)0x89,(byte)0xAB};

    /**
     * {@link jp.hrtdotnet.java.net.NetUtil#octetMacAddress(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSplitMacAddress_String() {
        byte[] b = NetUtil.octetMacAddress(MAC_ADDRESS);
        for (int i = 0; i < 6; i++) {
            assertEquals(b[i], OCTET_MAC_ADDRESS[i]);
        }
        b = NetUtil.octetMacAddress(MAC_ADDRESS2);
        for (int i = 0; i < 6; i++) {
            assertEquals(b[i], OCTET_MAC_ADDRESS[i]);
        }
    }

    /**
     * {@link jp.hrtdotnet.java.net.NetUtil#octetMacAddress(java.lang.String, java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSplitMacAddress_StringString() {
        byte[] b = NetUtil.octetMacAddress(MAC_ADDRESS3,";");
        for (int i = 0; i < 6; i++) {
            assertEquals(b[i], OCTET_MAC_ADDRESS[i]);
        }
        b = NetUtil.octetMacAddress(MAC_ADDRESS4,"");
        for (int i = 0; i < 6; i++) {
            assertEquals(b[i], OCTET_MAC_ADDRESS[i]);
        }
        b = NetUtil.octetMacAddress(MAC_ADDRESS4,null);
        for (int i = 0; i < 6; i++) {
            assertEquals(b[i], OCTET_MAC_ADDRESS[i]);
        }
    }

}
