package jp.hrtdotnet.java.util;

import jp.hrtdotnet.java.HTestCase;

public class CSVUtilTest extends HTestCase {

    /* ( Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /* ( Javadoc)
     * @see junit.framework.TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * {@link jp.hrtdotnet.java.util.CSVUtil#CSVUtil(char)} ̂߂̃eXgE\bhB
     */
    public void testCSVUtilChar() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.java.util.CSVUtil#CSVUtil(char, char)} ̂߂̃eXgE\bhB
     */
    public void testCSVUtilCharChar() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.java.util.CSVUtil#split(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSplit() {
        CSVUtil csv = new CSVUtil(',');
        String[] ret = csv.split("a,b,c,de,f");
        assertEquals("a", ret[0]);
        assertEquals("b", ret[1]);
        assertEquals("c", ret[2]);
        assertEquals("de", ret[3]);
        assertEquals("f", ret[4]);

        csv = new CSVUtil('\t', '"');
        ret = csv.split("a,b\tc\t\"de\tf\"");
        assertEquals("a,b", ret[0]);
        assertEquals("c", ret[1]);
        assertEquals("de\tf", ret[2]);
        
    
    }

    /**
     * {@link jp.hrtdotnet.java.util.CSVUtil#toCSV(java.lang.String[])} ̂߂̃eXgE\bhB
     */
    public void testToCSVStringArray() {
        CSVUtil csv = new CSVUtil(',');
        String ret = csv.toCSV(new String[]{"12","3456","789","0"});
        assertEquals("12,3456,789,0", ret);
        ret = csv.toCSV(new String[]{"1","2",""});
        assertEquals("1,2,", ret);
        ret = csv.toCSV(new String[]{"","",""});
        assertEquals(",,", ret);
        ret = csv.toCSV(new String[]{});
        assertEquals("", ret);
        ret = csv.toCSV(new String[]{""});
        assertEquals("", ret);
        csv = new CSVUtil('a');
        ret = csv.toCSV(new String[]{"12","3456","789","0"});
        assertEquals("12a3456a789a0", ret);
        csv = new CSVUtil(',','"');
        ret = csv.toCSV(new String[]{"12","34,56","789","0"});
        assertEquals("\"12\",\"34,56\",\"789\",\"0\"", ret);
        csv = new CSVUtil('"','"');
        ret = csv.toCSV(new String[]{"12","34,56","789","0"});
        assertEquals("\"12\"\"\"34,56\"\"\"789\"\"\"0\"", ret);
        
        String[] a = null;
        try {
            ret = csv.toCSV(a);
            fail();
        } catch (NullPointerException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.java.util.CSVUtil#toCSV(java.lang.String[][])} ̂߂̃eXgE\bhB
     */
    public void testToCSVStringArrayArray() {
        CSVUtil csv = new CSVUtil(',');
        String[] ret = csv.toCSV(new String[][]{{"12","34"},{"a","b"}});
        assertEquals("12,34", ret[0]);
        assertEquals("a,b", ret[1]);
        assertEquals(2, ret.length);
        ret = csv.toCSV(new String[][]{});
        assertEquals(0, ret.length);

        String[][] a = null;
        try {
            ret = csv.toCSV(a);
            fail();
        } catch (NullPointerException e) {
        }
    }
}
