/*
 * HDigestUtilsTest.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */

package jp.hrtdotnet.fw.util;

import jp.hrtdotnet.java.HTestCase;

/**
 *
 * @version 
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 
 */
public class HDigestUtilsTest extends HTestCase {

    /* ( Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /* ( Javadoc)
     * @see junit.framework.TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * {@link jp.hrtdotnet.fw.util.HDigestUtils#hash32(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testHash32() {
        assertEquals(HDigestUtils.md5("test"), HDigestUtils.hash32("test"));
        assertEquals(32, HDigestUtils.hash32("test").length());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.HDigestUtils#hash40(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testHash40() {
        assertEquals(HDigestUtils.sha1("test"), HDigestUtils.hash40("test"));
        assertEquals(40, HDigestUtils.hash40("test").length());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.HDigestUtils#hash64(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testHash64() {
        assertEquals(HDigestUtils.sha256("test"), HDigestUtils.hash64("test"));
        assertEquals(64, HDigestUtils.hash64("test").length());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.HDigestUtils#hash96(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testHash96() {
        assertEquals(HDigestUtils.sha384("test"), HDigestUtils.hash96("test"));
        assertEquals(96, HDigestUtils.hash96("test").length());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.HDigestUtils#hash128(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testHash128() {
        assertEquals(HDigestUtils.sha512("test"), HDigestUtils.hash128("test"));
        assertEquals(128, HDigestUtils.hash128("test").length());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.HDigestUtils#md5(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testMd5() {
        assertEquals("098f6bcd4621d373cade4e832627b4f6", HDigestUtils.md5("test"));
    }

    /**
     * {@link jp.hrtdotnet.fw.util.HDigestUtils#sha1(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSha1() {
        assertEquals("a94a8fe5ccb19ba61c4c0873d391e987982fbbd3", HDigestUtils.sha1("test"));
    }

    /**
     * {@link jp.hrtdotnet.fw.util.HDigestUtils#sha256(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSha256() {
        assertEquals("9f86d081884c7d659a2feaa0c55ad015a3bf4f1b2b0b822cd15d6c15b0f00a08", HDigestUtils.sha256("test"));
    }

    /**
     * {@link jp.hrtdotnet.fw.util.HDigestUtils#sha384(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSha384() {
        assertEquals("768412320f7b0aa5812fce428dc4706b3cae50e02a64caa16a782249bfe8efc4b7ef1ccb126255d196047dfedf17a0a9", HDigestUtils.sha384("test"));
    }

    /**
     * {@link jp.hrtdotnet.fw.util.HDigestUtils#sha512(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSha512() {
        assertEquals("ee26b0dd4af7e749aa1a8ee3c10ae9923f618980772e473f8819a5d4940e0db27ac185f8a0e1d5f84f88bc887fd67b143732c304cc5fa9ad8e6f57f50028a8ff", HDigestUtils.sha512("test"));
    }

}
