/*
 * Decompiled with CFR 0.152.
 */
package jp.hrtdotnet.fw.util.mail;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.Format;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.mail.Authenticator;
import jp.hrtdotnet.fw.common.HMailDefine;
import jp.hrtdotnet.fw.common.HNetCheck;
import jp.hrtdotnet.fw.util.mail.HMailAddress;
import jp.hrtdotnet.fw.util.mail.HMailException;
import jp.hrtdotnet.fw.util.mail.HSendMailServerModel;
import jp.hrtdotnet.java.text.FileFormat;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;

public abstract class HSendMail {
    private HSendMailServerModel serverModel = null;
    private boolean auth = false;
    private String hostName = null;
    private int smtpPort = HMailDefine.SMTP_PORT;
    private String userName = null;
    private String password = null;
    private Authenticator authenticator = null;
    private boolean sslSmtp = false;
    private int sslSmtpPort = HMailDefine.SMTP_PORT_SSL;
    private boolean tls = false;
    private HMailAddress from = null;
    private List to = null;
    private List cc = null;
    private List bcc = null;
    private List replyTo = null;
    private String charset = HMailDefine.SEND_CHARSET;
    private Date sentDate = null;
    private String subject = null;
    private String msg = null;
    private Format msgFormat = null;
    private Object msgFormatParams = null;
    private boolean debug = false;
    private boolean popBeforeSmtp = false;
    private String popHostName = null;
    private String popUserName = null;
    private String popPassword = null;

    public HSendMail() {
    }

    public HSendMail(HSendMailServerModel serverModel) {
        this.serverModel = serverModel;
    }

    public abstract void send() throws HMailException;

    protected boolean checkMailAddress(String mailAddress) {
        return true;
    }

    protected void setServerInfo(Email mail) throws HMailException {
        HSendMailServerModel serverModel = this.getServerModel();
        String hostName = null;
        int smtpPort = 0;
        String userName = null;
        String password = null;
        boolean auth = false;
        Authenticator authenticator = null;
        boolean sslSmtp = false;
        int sslSmtpPort = 0;
        boolean tls = false;
        boolean popBeforeSmtp = false;
        String popHostName = null;
        String popUserName = null;
        String popPassword = null;
        if (serverModel != null) {
            auth = serverModel.isAuth();
            hostName = serverModel.getHostName();
            smtpPort = serverModel.getSmtpPort();
            userName = serverModel.getUserName();
            password = serverModel.getPassword();
            authenticator = serverModel.getAuthenticator();
            sslSmtp = serverModel.isSslSmtp();
            sslSmtpPort = serverModel.getSslSmtpPort();
            tls = serverModel.isTls();
            popBeforeSmtp = serverModel.isPopBeforeSmtp();
            popHostName = serverModel.getPopHostName();
            popUserName = serverModel.getPopUserName();
            popPassword = serverModel.getPopPassword();
        } else {
            auth = this.isAuth();
            hostName = this.getHostName();
            smtpPort = this.getSmtpPort();
            userName = this.getUserName();
            password = this.getPassword();
            authenticator = this.getAuthenticator();
            sslSmtp = this.isSslSmtp();
            sslSmtpPort = this.getSslSmtpPort();
            tls = this.isTls();
            popBeforeSmtp = this.isPopBeforeSmtp();
            popHostName = this.getPopHostName();
            popUserName = this.getPopUserName();
            popPassword = this.getPopPassword();
        }
        if (hostName == null) {
            throw new HMailException("Host-name is null.");
        }
        if (hostName.length() == 0) {
            throw new HMailException("Host-name is empty-string.");
        }
        if (!HNetCheck.isRangeOfPort((int)smtpPort)) {
            throw new HMailException("SMTP PORT invalid Range.");
        }
        mail.setHostName(hostName);
        mail.setSmtpPort(smtpPort);
        mail.setSSL(sslSmtp);
        mail.setSslSmtpPort(String.valueOf(sslSmtpPort));
        mail.setTLS(tls);
        if (auth) {
            if (authenticator != null) {
                mail.setAuthenticator(authenticator);
            } else {
                mail.setAuthentication(userName, password);
            }
        }
        mail.setPopBeforeSmtp(popBeforeSmtp, popHostName, popUserName, popPassword);
    }

    protected void setSendInfo(Email mail) throws HMailException {
        String name;
        String addr;
        HMailAddress address;
        boolean debug = this.isDebug();
        List to = this.getTo();
        List cc = this.getCc();
        List bcc = this.getBcc();
        List replyTo = this.getReplyTo();
        HMailAddress from = this.getFrom();
        String subject = this.getSubject();
        String charset = this.getCharset();
        Date sentDate = this.getSentDate();
        mail.setDebug(debug);
        if (charset == null) {
            throw new HMailException("charset is null.");
        }
        if (!Charset.isSupported(charset)) {
            throw new HMailException("charset is un-supported.");
        }
        if (from == null) {
            throw new HMailException("from is null.");
        }
        String fromAddress = from.getAddress();
        String fromName = from.getName();
        if (fromAddress == null) {
            throw new HMailException("from-address is null.");
        }
        if (fromAddress.length() == 0) {
            throw new HMailException("from-address is empty-string.");
        }
        if (to == null || to.size() == 0) {
            throw new HMailException("to is null or empty-string.");
        }
        Iterator it = to.iterator();
        while (it.hasNext()) {
            String toAddress = ((HMailAddress)it.next()).getAddress();
            if (toAddress == null) {
                throw new HMailException("to-address is null.");
            }
            if (toAddress.length() == 0) {
                throw new HMailException("to-address is empty-string.");
            }
            if (this.checkMailAddress(toAddress)) continue;
            throw new HMailException("to-address is invalid-format.");
        }
        if (cc != null && cc.size() != 0) {
            it = cc.iterator();
            while (it.hasNext()) {
                String ccAddress = ((HMailAddress)it.next()).getAddress();
                if (ccAddress == null) {
                    throw new HMailException("cc-address is null.");
                }
                if (ccAddress.length() == 0) {
                    throw new HMailException("cc-address is empty-string.");
                }
                if (this.checkMailAddress(ccAddress)) continue;
                throw new HMailException("cc-address is invalid-format.");
            }
        }
        if (bcc != null && bcc.size() != 0) {
            it = bcc.iterator();
            while (it.hasNext()) {
                String bccAddress = ((HMailAddress)it.next()).getAddress();
                if (bccAddress == null) {
                    throw new HMailException("bcc-address is null.");
                }
                if (bccAddress.length() == 0) {
                    throw new HMailException("bcc-address is empty-string.");
                }
                if (this.checkMailAddress(bccAddress)) continue;
                throw new HMailException("bcc-address is invalid-format.");
            }
        }
        if (replyTo != null && replyTo.size() != 0) {
            it = replyTo.iterator();
            while (it.hasNext()) {
                String replyToAddress = ((HMailAddress)it.next()).getAddress();
                if (replyToAddress == null) {
                    throw new HMailException("ReplyTo-address is null.");
                }
                if (replyToAddress.length() == 0) {
                    throw new HMailException("ReplyTo-address is empty-string.");
                }
                if (this.checkMailAddress(replyToAddress)) continue;
                throw new HMailException("ReplyTo-address is invalid-format.");
            }
        }
        mail.setCharset(charset);
        if (sentDate != null) {
            mail.setSentDate(sentDate);
        } else {
            mail.setSentDate(Calendar.getInstance().getTime());
        }
        if (subject != null) {
            mail.setSubject(subject);
        } else {
            mail.setSubject("");
        }
        try {
            if (fromName != null) {
                mail.setFrom(fromAddress, fromName);
            } else {
                mail.setFrom(fromAddress);
            }
        }
        catch (EmailException e) {
            throw new HMailException(e);
        }
        it = to.iterator();
        while (it.hasNext()) {
            address = (HMailAddress)it.next();
            addr = address.getAddress();
            name = address.getName();
            try {
                if (name != null) {
                    mail.addTo(addr, name);
                    continue;
                }
                mail.addTo(addr);
            }
            catch (EmailException e) {
                throw new HMailException(e);
            }
        }
        if (cc != null && cc.size() != 0) {
            it = cc.iterator();
            while (it.hasNext()) {
                address = (HMailAddress)it.next();
                addr = address.getAddress();
                name = address.getName();
                try {
                    if (name != null) {
                        mail.addCc(addr, name);
                        continue;
                    }
                    mail.addCc(addr);
                }
                catch (EmailException e) {
                    throw new HMailException(e);
                }
            }
        }
        if (bcc != null && bcc.size() != 0) {
            it = bcc.iterator();
            while (it.hasNext()) {
                address = (HMailAddress)it.next();
                addr = address.getAddress();
                name = address.getName();
                try {
                    if (name != null) {
                        mail.addBcc(addr, name);
                        continue;
                    }
                    mail.addBcc(addr);
                }
                catch (EmailException e) {
                    throw new HMailException(e);
                }
            }
        }
        if (replyTo != null && replyTo.size() != 0) {
            it = replyTo.iterator();
            while (it.hasNext()) {
                address = (HMailAddress)it.next();
                addr = address.getAddress();
                name = address.getName();
                try {
                    if (name != null) {
                        mail.addReplyTo(addr, name);
                        continue;
                    }
                    mail.addReplyTo(addr);
                }
                catch (EmailException e) {
                    throw new HMailException(e);
                }
            }
        }
    }

    public HSendMailServerModel getServerModel() {
        return this.serverModel;
    }

    public void setServerModel(HSendMailServerModel serverModel) {
        this.serverModel = serverModel;
    }

    public boolean isAuth() {
        return this.auth;
    }

    public void setAuth(boolean auth) {
        this.auth = auth;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        if (hostName == null) {
            throw new NullPointerException("Host-name is null.");
        }
        if (hostName.length() == 0) {
            throw new IllegalArgumentException("Host-name is empty.");
        }
        this.hostName = hostName;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(int smtpPort) {
        if (!HNetCheck.isRangeOfPort((int)smtpPort)) {
            throw new IllegalArgumentException("SMTP PORT invalid Range.");
        }
        this.smtpPort = smtpPort;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public boolean isSslSmtp() {
        return this.sslSmtp;
    }

    public void setSslSmtp(boolean sslSmtp) {
        this.sslSmtp = sslSmtp;
    }

    public int getSslSmtpPort() {
        return this.sslSmtpPort;
    }

    public void setSslSmtpPort(int sslSmtpPort) {
        if (!HNetCheck.isRangeOfPort((int)sslSmtpPort)) {
            throw new IllegalArgumentException("SMTP(SSL) PORT invalid Range.");
        }
        this.sslSmtpPort = sslSmtpPort;
    }

    public boolean isTls() {
        return this.tls;
    }

    public void setTls(boolean tls) {
        this.tls = tls;
    }

    public HMailAddress getFrom() {
        return this.from;
    }

    public void setFrom(String fromAddress, String fromName) {
        if (fromAddress == null) {
            throw new NullPointerException("fromAddress is null.");
        }
        if (fromAddress.length() == 0) {
            throw new IllegalArgumentException("fromAddress is empty-string.");
        }
        this.from = new HMailAddress();
        this.from.setAddress(fromAddress);
        this.from.setName(fromName);
    }

    public void setFrom(String fromAddress) {
        this.setFrom(fromAddress, null);
    }

    public List getTo() {
        return this.to;
    }

    public List getCc() {
        return this.cc;
    }

    public List getBcc() {
        return this.bcc;
    }

    public void setTo(List toAddress) {
        this.setTo(toAddress, null);
    }

    public void setTo(String toAddress) {
        this.setTo(toAddress, null);
    }

    public void setTo(String[] toAddress) {
        this.setTo(toAddress, null);
    }

    public void setTo(List toAddress, List toName) {
        if (this.to != null) {
            this.to.clear();
        }
        this.to = this.getAddress(toAddress, toName);
    }

    public void setTo(String toAddress, String toName) {
        if (this.to != null) {
            this.to.clear();
        }
        this.to = this.getAddress(toAddress, toName);
    }

    public void setTo(String[] toAddress, String[] toName) {
        if (this.to != null) {
            this.to.clear();
        }
        this.to = this.getAddress(toAddress, toName);
    }

    public void setCc(List ccAddress) {
        this.setCc(ccAddress, null);
    }

    public void setCc(String ccAddress) {
        this.setCc(ccAddress, null);
    }

    public void setCc(String[] ccAddress) {
        this.setCc(ccAddress, null);
    }

    public void setCc(List ccAddress, List ccName) {
        if (this.cc != null) {
            this.cc.clear();
        }
        this.cc = this.getAddress(ccAddress, ccName);
    }

    public void setCc(String ccAddress, String ccName) {
        if (this.cc != null) {
            this.cc.clear();
        }
        this.cc = this.getAddress(ccAddress, ccName);
    }

    public void setCc(String[] ccAddress, String[] ccName) {
        if (this.cc != null) {
            this.cc.clear();
        }
        this.cc = this.getAddress(ccAddress, ccName);
    }

    public void setBcc(List bcc) {
        this.setBcc(bcc, null);
    }

    public void setBcc(String bcc) {
        this.setBcc(bcc, null);
    }

    public void setBcc(String[] bcc) {
        this.setBcc(bcc, null);
    }

    public void setBcc(List bccAddress, List bccName) {
        if (this.bcc != null) {
            this.bcc.clear();
        }
        this.bcc = this.getAddress(bccAddress, bccName);
    }

    public void setBcc(String bccAddress, String bccName) {
        if (this.bcc != null) {
            this.bcc.clear();
        }
        this.bcc = this.getAddress(bccAddress, bccName);
    }

    public void setBcc(String[] bccAddress, String[] bccName) {
        this.bcc = this.getAddress(bccAddress, bccName);
    }

    protected List getAddress(String srcAddress, String srcName) {
        if (srcAddress == null) {
            return new Vector();
        }
        if (srcAddress.length() == 0) {
            return new Vector();
        }
        String[] srcAddressArray = new String[]{srcAddress};
        String[] srcNameArray = null;
        if (srcName != null) {
            srcNameArray = new String[]{srcName};
        }
        return this.getAddress(srcAddressArray, srcNameArray);
    }

    protected List getAddress(List srcAddress, List srcName) {
        if (srcAddress == null) {
            return new Vector();
        }
        if (srcAddress.size() == 0) {
            return new Vector();
        }
        String[] srcAddressArray = srcAddress.toArray(new String[0]);
        String[] srcNameArray = null;
        if (srcName != null) {
            srcNameArray = srcName.toArray(new String[0]);
        }
        return this.getAddress(srcAddressArray, srcNameArray);
    }

    protected List getAddress(String[] srcAddress, String[] srcName) {
        if (srcAddress == null) {
            return new Vector();
        }
        if (srcAddress.length == 0) {
            return new Vector();
        }
        Vector<HMailAddress> retAddress = new Vector<HMailAddress>();
        if (srcName != null && srcAddress.length != srcName.length) {
            throw new IllegalArgumentException("Address-length != Name-length.");
        }
        for (int i = 0; i < srcAddress.length; ++i) {
            if (srcAddress[i] != null && srcAddress[i].length() != 0 && !this.checkMailAddress(srcAddress[i])) {
                throw new IllegalArgumentException("Address is invalid format.");
            }
            HMailAddress address = new HMailAddress();
            address.setAddress(srcAddress[i]);
            if (srcName != null) {
                address.setName(srcName[i]);
            }
            retAddress.add(address);
        }
        return retAddress;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setMsg(File file, String fileCharsetName, Object[] params) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        if (file == null) {
            throw new NullPointerException("file is null.");
        }
        if (fileCharsetName == null) {
            throw new NullPointerException("file-charset-name is null.");
        }
        if (fileCharsetName.length() == 0) {
            throw new IllegalArgumentException("file-charset-name is empty-string.");
        }
        FileFormat format = new FileFormat(file, fileCharsetName);
        this.msg = format.format((Object)params);
    }

    public void setMsg(File file, String fileCharsetName, String formatLineSeparator, Object[] params) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        if (file == null) {
            throw new NullPointerException("file is null.");
        }
        if (fileCharsetName == null) {
            throw new NullPointerException("file-charset-name is null.");
        }
        if (fileCharsetName.length() == 0) {
            throw new IllegalArgumentException("file-charset-name is empty-string.");
        }
        if (formatLineSeparator == null) {
            throw new NullPointerException("format-line-separator is null.");
        }
        if (formatLineSeparator.length() == 0) {
            throw new IllegalArgumentException("format-line-separator is empty-string.");
        }
        FileFormat format = new FileFormat(file, fileCharsetName, formatLineSeparator);
        this.msg = format.format((Object)params);
    }

    public void setMsg(Format format, Object[] params) {
        if (format == null) {
            throw new NullPointerException("format is null.");
        }
        this.msg = format.format(params);
    }

    public void setMsgFormat(File file, String fileCharsetName) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        if (file == null) {
            throw new NullPointerException("file is null.");
        }
        if (fileCharsetName == null) {
            throw new NullPointerException("file-charset-name is null.");
        }
        if (fileCharsetName.length() == 0) {
            throw new IllegalArgumentException("file-charset-name is empty-string.");
        }
        this.msgFormat = new FileFormat(file, fileCharsetName);
    }

    public void setMsgFormat(File file, String fileCharsetName, String formatLineSeparator) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        if (file == null) {
            throw new NullPointerException("file is null.");
        }
        if (fileCharsetName == null) {
            throw new NullPointerException("file-charset-name is null.");
        }
        if (fileCharsetName.length() == 0) {
            throw new IllegalArgumentException("file-charset-name is empty-string.");
        }
        if (formatLineSeparator == null) {
            throw new NullPointerException("format-line-separator is null.");
        }
        if (formatLineSeparator.length() == 0) {
            throw new IllegalArgumentException("format-line-separator is empty-string.");
        }
        this.msgFormat = new FileFormat(file, fileCharsetName, formatLineSeparator);
    }

    public void setMsgFormat(Format format) {
        this.msgFormat = format;
    }

    public Format getMsgFormat() {
        return this.msgFormat;
    }

    public void setMsgFormatParams(Object msgFormatParams) {
        this.msgFormatParams = msgFormatParams;
    }

    public Object getMsgFormatParams() {
        return this.msgFormatParams;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public List getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(List replyToAddress) {
        this.setReplyTo(replyToAddress, null);
    }

    public void setReplyTo(String replyToAddress) {
        this.setReplyTo(replyToAddress, null);
    }

    public void setReplyTo(String[] replyToAddress) {
        this.setReplyTo(replyToAddress, null);
    }

    public void setReplyTo(List replyToAddress, List replyToName) {
        if (this.replyTo != null) {
            this.replyTo.clear();
        }
        this.replyTo = this.getAddress(replyToAddress, replyToName);
    }

    public void setReplyTo(String replyToAddress, String replyToName) {
        if (this.replyTo != null) {
            this.replyTo.clear();
        }
        this.replyTo = this.getAddress(replyToAddress, replyToName);
    }

    public void setReplyTo(String[] replyToAddress, String[] replyToName) {
        if (this.replyTo != null) {
            this.replyTo.clear();
        }
        this.replyTo = this.getAddress(replyToAddress, replyToName);
    }

    public Date getSentDate() {
        return this.sentDate;
    }

    public void setSentDate(Date sentDate) {
        this.sentDate = sentDate;
    }

    public boolean isPopBeforeSmtp() {
        return this.popBeforeSmtp;
    }

    public void setPopBeforeSmtp(boolean popBeforeSmtp) {
        this.popBeforeSmtp = popBeforeSmtp;
    }

    public String getPopHostName() {
        return this.popHostName;
    }

    public void setPopHostName(String popHostName) {
        this.popHostName = popHostName;
    }

    public String getPopUserName() {
        return this.popUserName;
    }

    public void setPopUserName(String popUserName) {
        this.popUserName = popUserName;
    }

    public String getPopPassword() {
        return this.popPassword;
    }

    public void setPopPassword(String popPassword) {
        this.popPassword = popPassword;
    }
}

