/*
 * Decompiled with CFR 0.152.
 */
package jp.hrtdotnet.fw.util.mail;

import javax.mail.Authenticator;
import jp.hrtdotnet.fw.common.HMailDefine;
import jp.hrtdotnet.fw.common.HNetCheck;

public class HSendMailServerModel {
    private boolean auth = false;
    private String hostName = null;
    private int smtpPort = HMailDefine.SMTP_PORT;
    private String userName = null;
    private String password = null;
    private Authenticator authenticator = null;
    private boolean sslSmtp = false;
    private int sslSmtpPort = HMailDefine.SMTP_PORT_SSL;
    private boolean tls = false;
    private boolean popBeforeSmtp = false;
    private String popHostName = null;
    private String popUserName = null;
    private String popPassword = null;

    public HSendMailServerModel(String hostName, int smtpPort) {
        if (hostName == null) {
            throw new NullPointerException("Host-name is null.");
        }
        if (hostName.length() == 0) {
            throw new IllegalArgumentException("Host-name is empty-string.");
        }
        if (!HNetCheck.isRangeOfPort((int)smtpPort)) {
            throw new IllegalArgumentException("SMTP PORT invalid range.");
        }
        this.hostName = hostName;
        this.smtpPort = smtpPort;
    }

    public HSendMailServerModel(String hostName) {
        this(hostName, HMailDefine.SMTP_PORT);
    }

    public boolean isAuth() {
        return this.auth;
    }

    public void setAuth(boolean auth) {
        this.auth = auth;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAuthentication(String userName, String password) {
        this.setUserName(userName);
        this.setPassword(password);
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public boolean isSslSmtp() {
        return this.sslSmtp;
    }

    public void setSslSmtp(boolean sslSmtp) {
        this.sslSmtp = sslSmtp;
    }

    public int getSslSmtpPort() {
        return this.sslSmtpPort;
    }

    public void setSslSmtpPort(int sslSmtpPort) {
        if (!HNetCheck.isRangeOfPort((int)sslSmtpPort)) {
            throw new IllegalArgumentException("SMTP(SSL) PORT invalid Range.");
        }
        this.sslSmtpPort = sslSmtpPort;
    }

    public boolean isTls() {
        return this.tls;
    }

    public void setTls(boolean tls) {
        this.tls = tls;
    }

    public boolean isPopBeforeSmtp() {
        return this.popBeforeSmtp;
    }

    public void setPopBeforeSmtp(boolean popBeforeSmtp) {
        this.popBeforeSmtp = popBeforeSmtp;
    }

    public String getPopHostName() {
        return this.popHostName;
    }

    public void setPopHostName(String popHostName) {
        this.popHostName = popHostName;
    }

    public String getPopUserName() {
        return this.popUserName;
    }

    public void setPopUserName(String popUserName) {
        this.popUserName = popUserName;
    }

    public String getPopPassword() {
        return this.popPassword;
    }

    public void setPopPassword(String popPassword) {
        this.popPassword = popPassword;
    }

    public void setPopAuthentication(String popUserName, String popPassword) {
        this.setPopUserName(popUserName);
        this.setPopPassword(popPassword);
    }
}

