/*
 * Decompiled with CFR 0.152.
 */
import controlP5.Button;
import controlP5.ControlEvent;
import controlP5.ControlP5;
import controlP5.ControlWindow;
import controlP5.Slider;
import controlP5.Textlabel;
import processing.core.PApplet;
import processing.core.PImage;

public class HDRHolic
extends PApplet {
    ControlP5 cp5;
    ControlWindow controlWindow;
    ControlWindow viewWindow;
    Textlabel readmeText;
    PImage img0;
    PImage img1;
    PImage img2;
    PImage writeImg;
    float scope_ratio = 5.0f;
    final int low_scope_speed_ratio = 20;
    final float low_average_speed_ratio = 0.1f;
    final int high_scope_speed_ratio = 5;
    final float high_average_speed_ratio = 0.1f;
    int scope_speed_ratio = 20;
    float average_speed_ratio = 0.1f;
    final int max_lum_class = 30;
    int class_th = 15;
    float a_value = 0.27f;
    float gamma_u = 0.5f;
    float gamma_n = 1.0f;
    float gamma_o = 0.5f;
    float color_gain = 1.0f;
    final float delta = 0.01f;
    float[] lut_u = new float[256];
    float[] lut_n = new float[256];
    float[] lut_o = new float[256];
    float[] hdr_img_r;
    float[] hdr_img_g;
    float[] hdr_img_b;
    int size_x = 1024;
    int size_y = 768;
    int view_width;
    int view_height;

    public void setup() {
        this.size(this.size_x, this.size_y);
        this.cp5 = new ControlP5((PApplet)this);
        this.controlWindow = this.cp5.addControlWindow("Tunewindow", 100, 100, 360, 600).hideCoordinates().setBackground(this.color(40));
        ((Textlabel)((Textlabel)this.cp5.addTextlabel("guide").setText("Guide:").setPosition(40.0f, 40.0f)).setColorValue(-1)).setFont(this.createFont("Georgia", 20.0f)).moveTo(this.controlWindow);
        this.readmeText = (Textlabel)((Textlabel)((Textlabel)this.cp5.addTextlabel("label").setText("Select an under exposed photo.").setPosition(40.0f, 80.0f)).setColorValue(-1)).setFont(this.createFont("Georgia", 18.0f)).moveTo(this.controlWindow);
        ((Slider)this.cp5.addSlider("gamma_u").setRange(0.0f, 2.0f).setPosition(40.0f, 140.0f)).setSize(200, 29).moveTo(this.controlWindow);
        ((Slider)this.cp5.addSlider("gamma_n").setRange(0.0f, 2.0f).setPosition(40.0f, 180.0f)).setSize(200, 29).moveTo(this.controlWindow);
        ((Slider)this.cp5.addSlider("gamma_o").setRange(0.0f, 2.0f).setPosition(40.0f, 220.0f)).setSize(200, 29).moveTo(this.controlWindow);
        ((Slider)this.cp5.addSlider("a_value").setRange(0.0f, 0.5f).setPosition(40.0f, 300.0f)).setSize(200, 29).moveTo(this.controlWindow);
        ((Slider)this.cp5.addSlider("color_gain").setRange(0.0f, 5.0f).setPosition(40.0f, 340.0f)).setSize(200, 29).moveTo(this.controlWindow);
        ((Slider)this.cp5.addSlider("scope_ratio").setRange(0.0f, 20.0f).setPosition(40.0f, 380.0f)).setSize(200, 29).moveTo(this.controlWindow);
        ((Slider)this.cp5.addSlider("class_th").setRange(0.0f, 30.0f).setPosition(40.0f, 420.0f)).setSize(200, 29).moveTo(this.controlWindow);
        ((Button)((Button)this.cp5.addButton("Save Image").setPosition(40.0f, 500.0f)).setSize(100, 39)).moveTo(this.controlWindow);
        ((Button)((Button)this.cp5.addButton("Exit").setPosition(160.0f, 500.0f)).setSize(100, 39)).moveTo(this.controlWindow);
        String string = this.selectInput();
        this.img0 = this.loadImage(string);
        this.readmeText.setText("Select a normal exposed photo.");
        string = this.selectInput();
        this.img1 = this.loadImage(string);
        this.readmeText.setText("Select an over exposed photo.");
        string = this.selectInput();
        this.img2 = this.loadImage(string);
        this.writeImg = this.createImage(this.img0.width, this.img0.height, 1);
        this.MakeHDR();
        this.ToneMapping();
        this.readmeText.setText("Completed.");
        if (this.img0.width > this.size_x || this.img0.height > this.size_y) {
            float f = this.img0.width / this.size_x;
            float f2 = this.img0.height / this.size_y;
            float f3 = f > f2 ? f : f2;
            this.view_width = (int)((float)this.img0.width / f3);
            this.view_height = (int)((float)this.img0.height / f3);
        } else {
            this.view_width = this.img0.width;
            this.view_height = this.img0.height;
        }
    }

    public void controlEvent(ControlEvent controlEvent) {
        if (controlEvent.isFrom("color_gain")) {
            this.MakeHDR();
        }
        if (controlEvent.isFrom("gamma_u")) {
            this.MakeHDR();
        }
        if (controlEvent.isFrom("gamma_n")) {
            this.MakeHDR();
        }
        if (controlEvent.isFrom("gamma_o")) {
            this.MakeHDR();
        }
        if (controlEvent.isFrom("Save Image")) {
            String string = this.selectOutput();
            this.writeImg.save(string);
        }
        if (controlEvent.isFrom("Exit")) {
            this.exit();
        }
    }

    public void draw() {
        this.ToneMapping();
        this.image(this.writeImg, 0.0f, 0.0f, this.view_width, this.view_height);
    }

    public void MakeHDR() {
        this.hdr_img_r = new float[this.img0.height * this.img0.width];
        this.hdr_img_g = new float[this.img0.height * this.img0.width];
        this.hdr_img_b = new float[this.img0.height * this.img0.width];
        this.img0.loadPixels();
        this.img1.loadPixels();
        this.img2.loadPixels();
        int n = 0;
        while (n < 256) {
            this.lut_u[n] = 255.0f * HDRHolic.pow((float)((float)n / 255.0f), (float)(1.0f / this.gamma_u));
            ++n;
        }
        n = 0;
        while (n < 256) {
            this.lut_n[n] = 255.0f * HDRHolic.pow((float)((float)n / 255.0f), (float)(1.0f / this.gamma_n));
            ++n;
        }
        n = 0;
        while (n < 256) {
            this.lut_o[n] = 255.0f * HDRHolic.pow((float)((float)n / 255.0f), (float)(1.0f / this.gamma_o));
            ++n;
        }
        n = 0;
        while (n < this.img0.width * this.img0.height) {
            int n2 = this.img0.pixels[n];
            int n3 = this.img1.pixels[n];
            int n4 = this.img2.pixels[n];
            this.hdr_img_r[n] = this.lut_u[(int)this.red(n2)] + this.lut_n[(int)this.red(n3)] + this.lut_o[(int)this.red(n4)];
            this.hdr_img_g[n] = this.lut_u[(int)this.green(n2)] + this.lut_n[(int)this.green(n3)] + this.lut_o[(int)this.green(n4)];
            this.hdr_img_b[n] = this.lut_u[(int)this.blue(n2)] + this.lut_n[(int)this.blue(n3)] + this.lut_o[(int)this.blue(n4)];
            this.hdr_img_r[n] = this.hdr_img_r[n] / 3.0f * this.color_gain;
            this.hdr_img_g[n] = this.hdr_img_g[n] / 3.0f * this.color_gain;
            this.hdr_img_b[n] = this.hdr_img_b[n] / 3.0f * this.color_gain;
            ++n;
        }
    }

    public void ToneMapping() {
        int n;
        int n2;
        int n3;
        int n4 = (int)(HDRHolic.sqrt((float)(this.img0.height * this.img0.width)) * this.scope_ratio / 100.0f);
        int n5 = n4 * this.scope_speed_ratio / 100 + 1;
        int n6 = (int)(HDRHolic.sqrt((float)(this.img0.height * this.img0.width)) * this.average_speed_ratio / 100.0f);
        int[] cfr_ignored_0 = new int[this.img0.height * this.img0.width];
        int n7 = n6;
        float f = 0.0f;
        float[] fArray = new float[this.img0.height * this.img0.width];
        float[] fArray2 = new float[this.img0.height * this.img0.width];
        int[] nArray = new int[this.img0.height * this.img0.width];
        float[] fArray3 = new float[this.img0.height * this.img0.width];
        float[] fArray4 = new float[this.img0.height * this.img0.width];
        int n8 = 0;
        while (n8 < this.img0.height) {
            n3 = 0;
            while (n3 < this.img0.width) {
                n2 = n3 + n8 * this.img0.width;
                fArray[n2] = 0.3f * this.hdr_img_r[n2] + 0.59f * this.hdr_img_g[n2] + 0.11f * this.hdr_img_b[n2];
                fArray2[n2] = HDRHolic.log((float)((0.3f * this.hdr_img_r[n2] + 0.59f * this.hdr_img_g[n2] + 0.11f * this.hdr_img_b[n2]) / 256.0f + 0.01f));
                fArray3[n2] = -0.17f * this.hdr_img_r[n2] - 0.33f * this.hdr_img_g[n2] + 0.5f * this.hdr_img_b[n2];
                fArray4[n2] = 0.5f * this.hdr_img_r[n2] - 0.42f * this.hdr_img_g[n2] - 0.08f * this.hdr_img_b[n2];
                ++n3;
            }
            ++n8;
        }
        n8 = (int)HDRHolic.max((float[])fArray);
        n3 = 0;
        while (n3 < this.img0.height) {
            n2 = 0;
            while (n2 < this.img0.width) {
                n = n2 + n3 * this.img0.width;
                nArray[n] = (int)(fArray[n] / (float)((n8 + 1) / 30));
                ++n2;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.img0.height) {
            n7 = n6;
            n2 = 0;
            while (n2 < this.img0.width) {
                n = n2 + n3 * this.img0.width;
                float f2 = 0.0f;
                int n9 = 0;
                if (++n7 > n6) {
                    n7 = 0;
                    int n10 = n3 - n4;
                    while (n10 < n3 + n4) {
                        int n11 = n2 - n4;
                        while (n11 < n2 + n4) {
                            int n12;
                            if (n10 >= 0 && n10 < this.img0.height && n11 >= 0 && n11 < this.img0.width && HDRHolic.abs((int)(nArray[n] - nArray[n12 = n11 + n10 * this.img0.width])) < this.class_th) {
                                ++n9;
                                f2 += fArray2[n12];
                            }
                            n11 += n5;
                        }
                        n10 += n5;
                    }
                    f = HDRHolic.exp((float)(f2 / (float)n9));
                }
                float f3 = fArray[n] / f * this.a_value;
                float f4 = f3 + 1.4f * fArray4[n];
                float f5 = f3 - 0.34f * fArray3[n] - 0.71f * fArray4[n];
                float f6 = f3 + 1.77f * fArray3[n];
                this.writeImg.pixels[n] = this.color(f4, f5, f6);
                ++n2;
            }
            ++n3;
        }
        this.writeImg.updatePixels();
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#FFFFFF", "HDRHolic"});
    }
}

