/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

public class ControlTimer {
    long millisOffset;
    int ms;
    int s;
    int m;
    int h;
    int d;
    float _mySpeed = 1.0f;
    int current;
    int previous;

    public ControlTimer() {
        this.reset();
    }

    public String toString() {
        this.update();
        return (this.h < 10 ? "0" + this.h : "" + this.h) + " : " + (this.m < 10 ? "0" + this.m : "" + this.m) + " : " + (this.s < 10 ? "0" + this.s : "" + this.s);
    }

    public void update() {
        this.current = (int)this.time();
        if (this.current > this.previous + 10) {
            this.ms = (int)((float)this.current * this._mySpeed);
            this.s = (int)((float)this.current * this._mySpeed / 1000.0f);
            this.m = this.s / 60;
            this.h = this.m / 60;
            this.d = this.h / 24;
            this.ms %= 1000;
            this.s %= 60;
            this.m %= 60;
            this.h %= 24;
            this.previous = this.current;
        }
    }

    public long time() {
        return System.currentTimeMillis() - this.millisOffset;
    }

    public void reset() {
        this.millisOffset = System.currentTimeMillis();
        this.previous = 0;
        this.current = 0;
        this.s = 0;
        this.m = 0;
        this.h = 0;
        this.update();
    }

    public void setSpeedOfTime(float f) {
        this._mySpeed = f;
        this.update();
    }

    public int millis() {
        return this.ms;
    }

    public int second() {
        return this.s;
    }

    public int minute() {
        return this.m;
    }

    public int hour() {
        return this.h;
    }

    public int day() {
        return this.d;
    }
}

