/*
 * Decompiled with CFR 0.152.
 */
package ergo;

import ergo.server.GoServer;
import ergo.ui.Optionizer;
import ergo.ui.TerminalWindow;
import ergo.ui.TextColorManager;
import ergo.util.Debug;
import ergo.util.Util;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Button;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import org.unitarou.io.SnifferPrintStream;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogAgency;

public class Ergo
extends Applet
implements ActionListener {
    private static Log log_s_ = LogAgency.getLog();
    public static boolean inApplet = false;
    private static URL ergoDocumentBase = null;
    private static URL defaultURL;
    private static final Hashtable mmCache;
    public static final String mmdir = "mm/";
    public static final Optionizer opser;
    private TerminalWindow window;
    private Button startButton;
    private AudioClip thwak = null;
    private boolean thwakChecked = false;
    static /* synthetic */ Class class$ergo$Ergo;

    public static void main(String[] stringArray) throws FileNotFoundException {
        final SnifferPrintStream snifferPrintStream = new SnifferPrintStream((OutputStream)new FileOutputStream("hErgo.log", true), System.out);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                snifferPrintStream.close();
            }
        });
        System.setOut(snifferPrintStream);
        Ergo.mainImpl(stringArray);
    }

    private static void mainImpl(String[] stringArray) {
        Object object;
        String string = null;
        int n = 9696;
        String string2 = "NNGS";
        String string3 = "Ergo.ini";
        String string4 = null;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if ("-help".equalsIgnoreCase((String)object)) {
                Ergo.displayHelpMessage();
                System.exit(0);
                continue;
            }
            if ("-nngs".equalsIgnoreCase((String)object)) {
                string = "nngs.cosmic.org";
                n = 9696;
                string2 = "NNGS";
                continue;
            }
            if ("-igs".equalsIgnoreCase((String)object)) {
                string = "igs.nuri.net";
                n = 6969;
                string2 = "IGS";
                continue;
            }
            if ("-wing".equalsIgnoreCase((String)object)) {
                string = "wing.blrnet.net";
                n = 1515;
                string2 = "WING";
                continue;
            }
            if ("-debug".equalsIgnoreCase((String)object)) {
                Debug.setDebug(true);
                bl = true;
                continue;
            }
            if (i + 1 >= stringArray.length) {
                System.err.println("Unmatched command-line arg " + (String)object + " ignored.");
                break;
            }
            if ("-server".equalsIgnoreCase((String)object)) {
                string = stringArray[++i];
                continue;
            }
            if ("-type".equalsIgnoreCase((String)object)) {
                string2 = stringArray[++i];
                continue;
            }
            if ("-init".equalsIgnoreCase((String)object)) {
                string3 = stringArray[++i];
                continue;
            }
            if ("-port".equalsIgnoreCase((String)object)) {
                object = stringArray[++i];
                try {
                    int n2 = Integer.parseInt((String)object);
                    if (n2 < 0) {
                        throw new NumberFormatException();
                    }
                    n = n2;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Error: invalid port number " + (String)object + " ignored.");
                }
                continue;
            }
            if (!"-root".equalsIgnoreCase((String)object)) continue;
            string4 = stringArray[++i];
        }
        Ergo ergo = new Ergo();
        object = null;
        if (string != null) {
            if (string2 == null) {
                switch (n) {
                    case 9696: {
                        string2 = "NNGS";
                        break;
                    }
                    case 6969: 
                    case 7777: {
                        string2 = "IGS";
                        break;
                    }
                    case 1515: 
                    case 2525: {
                        string2 = "WING";
                    }
                }
            }
            object = new GoServer(string, n, string2, string2);
        }
        Ergo.setDocumentBase(string4, string3);
        ergo.startErgo((GoServer)object, true, string3, bl);
    }

    private static void displayHelpMessage() {
        String string = "Ergo options:\n  -help              Display this message.\n  -debug             Enable debug messages.  Default = false.\n  -igs               Connect to IGS upon startup.\n  -nngs              Connect to NNGS upon startup.\n  -wing              Connect to WING upon startup.\n  -server <host>     Connect to <host> upon startup.\n  -port <port>       Use <port> when connecting to <host>.  Default = 9696.\n  -init <file>       Use <file> as the Ergo init file.  Default = Ergo.ini\n";
        System.out.println(string);
    }

    public static String version() {
        return "1.0.4";
    }

    public static Image loadImage(String string) {
        Image image = (Image)mmCache.get(string);
        if (image != null) {
            return image;
        }
        try {
            int n;
            InputStream inputStream = (class$ergo$Ergo == null ? (class$ergo$Ergo = Ergo.class$("ergo.Ergo")) : class$ergo$Ergo).getResourceAsStream(string);
            byte[] byArray = new byte[inputStream.available()];
            for (int i = 0; i != byArray.length; i += n) {
                n = inputStream.read(byArray, i, byArray.length - i);
                Thread.sleep(100L);
            }
            Image image2 = Toolkit.getDefaultToolkit().createImage(byArray);
            mmCache.put(string, image2);
            return image2;
        }
        catch (IOException iOException) {
            Debug.backtrace(iOException);
            throw new RuntimeException("Unable to load resource " + string + ": " + iOException);
        }
        catch (InterruptedException interruptedException) {
            Debug.backtrace(interruptedException);
            throw new RuntimeException("Unable to load resource " + string + ": " + interruptedException);
        }
    }

    public static void flushCache() {
        mmCache.clear();
    }

    private static void setDocumentBase(String string, String string2) {
        if (string != null) {
            ergoDocumentBase = Ergo.makeFileURL(string, true);
        } else if (string2 != null) {
            try {
                ergoDocumentBase = Ergo.makeFileURL(new File(string2).getCanonicalPath(), true);
            }
            catch (IOException iOException) {}
        } else {
            ergoDocumentBase = Ergo.makeFileURL(System.getProperty("user.dir"), true);
        }
    }

    private static URL makeFileURL(String string, boolean bl) {
        log_s_.info("filename = " + string + ", isDir = " + bl);
        string = string.replace(System.getProperty("file.separator").charAt(0), '/');
        if (string.charAt(0) != '/') {
            string = "/" + string;
        }
        String string2 = "file://" + string;
        if (bl && string2.charAt(string2.length() - 1) != '/') {
            int n = string2.lastIndexOf(47);
            string2 = n == -1 ? string2 + "/" : string2.substring(0, n + 1);
        }
        try {
            URL uRL = new URL(string2);
            log_s_.info("url = " + uRL);
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            Debug.backtrace(malformedURLException);
            return null;
        }
    }

    public Ergo() {
        try {
            defaultURL = new URL("http://www.thecia.net/users/sigue/ergo/");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void init() {
        inApplet = true;
        this.setLayout(null);
        this.setSize(200, 30);
        this.startButton = new Button("Start hErgo");
        this.startButton.setBounds(0, 0, 149, 29);
        this.startButton.setFont(new Font("Dialog", 0, 14));
        this.add(this.startButton);
        this.startButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.getParameter("DOMAINNAME", "wing.gr.jp");
        String string2 = this.getParameter("PORT", "2525");
        String string3 = this.getParameter("SHORTNAME", "WING");
        String string4 = this.getParameter("TYPE", "WING");
        String string5 = this.getParameter("CONNECT", "true");
        String string6 = this.getParameter("DEBUG", "false");
        boolean bl = "true".equalsIgnoreCase(string5);
        int n = 9696;
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("BAD PORT NUMBER:" + string2);
            }
        }
        Debug.setDebug("true".equalsIgnoreCase(string6));
        this.startErgo(new GoServer(string, n, string3, string4), bl, null, Debug.getDebug());
    }

    private String getParameter(String string, String string2) {
        String string3 = this.getParameter(string);
        return string3 != null ? string3 : string2;
    }

    private URL getErgoDocumentBase() {
        if (inApplet) {
            return this.getDocumentBase();
        }
        if (ergoDocumentBase != null) {
            return ergoDocumentBase;
        }
        return defaultURL;
    }

    private void startErgo(GoServer goServer, boolean bl, String string, boolean bl2) {
        this.readInitFile(string);
        if (bl2) {
            opser.expressOwnership("Debug Mode", 2, null, new Boolean(Debug.getDebug()));
            opser.expressOwnership("Debug Menu", 2, null, new Boolean(Debug.getDebug()));
        }
        this.window = new TerminalWindow(this, goServer, bl);
        new Thread((Runnable)this.window, "Ergo main window").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readInitFile(String string) {
        log_s_.info("init file name = " + string);
        if (inApplet) {
            return;
        }
        InputStream inputStream = this.openInitFile(string);
        if (inputStream == null) {
            log_s_.warn("Init file not found.");
            return;
        }
        try {
            opser.inSuck(inputStream);
        }
        catch (Exception exception) {
            log_s_.warn(exception, "Error reading init file.");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private InputStream openInitFile(String string) {
        if (!inApplet) {
            opser.setInitFile(string);
            if (Util.isUnix()) {
                String string2 = System.getProperty("user.home", "");
                String string3 = System.getProperty("file.separator");
                try {
                    String string4 = string2 + string3 + string;
                    FileInputStream fileInputStream = new FileInputStream(string4);
                    opser.setInitFile(string4);
                    return fileInputStream;
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                opser.setInitFile(string);
                return fileInputStream;
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else {
            try {
                return new URL(this.getErgoDocumentBase(), string).openStream();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public void thwak() {
        if (!this.thwakChecked) {
            this.thwak = this.getAudioClip();
            this.thwakChecked = true;
        }
        if (this.thwak != null) {
            this.thwak.stop();
            this.thwak.play();
        }
    }

    private AudioClip getAudioClip() {
        try {
            if (inApplet) {
                return this.getAudioClip(this.makeMMURL("pok.au"));
            }
            URL uRL = ClassLoader.getSystemResource("mm/pok.au");
            return Applet.newAudioClip(uRL);
        }
        catch (Exception exception) {
            Debug.backtrace(exception);
            return null;
        }
    }

    private URL makeMMURL(String string) {
        try {
            if (inApplet) {
                return new URL(this.getCodeBase(), mmdir + string);
            }
            return new URL(ergoDocumentBase, mmdir + string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        mmCache = new Hashtable();
        opser = new Optionizer();
        TextColorManager.setOpser(opser);
    }
}

