/*
 * Decompiled with CFR 0.152.
 */
package ergo.logic;

import ergo.Ergo;
import ergo.logic.GameResultMove;
import ergo.logic.HandicapMove;
import ergo.logic.Move;
import ergo.logic.PassMove;
import ergo.logic.RootMove;
import ergo.logic.StoneStasher;
import ergo.server.GoServer;
import ergo.ui.GameWindow;
import ergo.ui.TerminalWindow;
import ergo.util.Debug;
import ergo.util.ILMV;
import ergo.util.Position;
import ergo.util.PositionVector;
import ergo.util.SimpleGroup;
import ergo.util.SimpleGroupVector;
import java.io.PrintWriter;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class Game {
    private GameWindow window = null;
    public StoneStasher ss;
    private SimpleGroup[][] groupArray;
    private RootMove root = new RootMove();
    private Move currentMove = this.root;
    private char scoringRules = (char)74;
    private boolean scoringMode = false;
    private boolean scoringLocally = false;
    private Move scoringEntry = null;
    private boolean scoringEntryFollowedByNewMove = false;
    private int blackTerritory = 0;
    private int whiteTerritory = 0;
    private int dame = 0;
    private Date startTime = new Date();
    private int size = 0;
    public String blackName = "";
    public String blackRank = "";
    public String whiteName = "";
    public String whiteRank = "";
    public String SGFlocation = null;
    private double komi = 5.5;
    private GoServer server = null;
    private int capturedWhite = 0;
    private int capturedBlack = 0;
    private Position koPosition = null;
    String result = null;
    private int byotime = 0;
    private boolean isFree = false;
    protected Vector unhandledSGFproperties = null;
    ILMV isLegalResult = new ILMV();
    private PositionVector scoringQueue = new PositionVector(50, 50);

    public Game(GameWindow gameWindow, int n, String string, String string2, String string3, String string4, double d) {
        this.window = gameWindow;
        this.whiteName = string;
        this.whiteRank = string2;
        this.blackName = string3;
        this.blackRank = string4;
        this.komi = d;
        this.size = n;
        this.init();
    }

    public Game(GameWindow gameWindow, int n, String string, String string2, String string3, String string4, double d, int n2, boolean bl, GoServer goServer) {
        this(gameWindow, n, string, string2, string3, string4, d);
        this.server = goServer;
        this.byotime = n2;
        this.isFree = bl;
    }

    public Game() {
        this.init();
    }

    private void init() {
        if (this.whiteRank == null) {
            this.whiteRank = "NR";
        }
        if (this.blackRank == null) {
            this.blackRank = "NR";
        }
        this.ss = new StoneStasher(this.size);
        if (this.size > 0) {
            this.groupArray = new SimpleGroup[this.size][this.size];
        }
        this.root.setChild(null);
        this.goToBeginning();
    }

    public void setWindow(GameWindow gameWindow) {
        this.window = gameWindow;
    }

    public boolean setSize(int n) {
        if (this.root.child() != null || n < 1) {
            return false;
        }
        this.size = n;
        this.ss = new StoneStasher(n);
        this.groupArray = new SimpleGroup[n][n];
        return true;
    }

    public int byotime() {
        return this.byotime;
    }

    public boolean isFree() {
        return this.isFree;
    }

    public RootMove rootMove() {
        return this.root;
    }

    public boolean isNetGame() {
        return this.server != null;
    }

    public Move firstMove() {
        Move move = this.getCurrentMove();
        if (move == this.rootMove()) {
            return this.rootMove().child();
        }
        while (move.parent() != this.rootMove()) {
            move = move.parent();
        }
        return move;
    }

    public Move finalMove() {
        return this.root.finalMove(false);
    }

    public Move finalServerMove() {
        return this.root.finalMove(this.isNetGame());
    }

    public Move currentMove() {
        return this.currentMove;
    }

    public Move getCurrentMove() {
        return this.currentMove;
    }

    private void setCurrentMove(Move move) {
        this.currentMove = move;
        this.ss.setCurrentMove(move);
    }

    public Move findMove(int n) {
        for (Move move = this.firstMove(); move != null; move = move.child()) {
            if (move.moveNumber() != n) continue;
            return move;
        }
        return null;
    }

    public Move findMove(int n, int n2) {
        Position position = new Position(n, n2);
        if (this.ss.readStone(n, n2) != 3) {
            Move move = this.currentMove;
            while (!(move instanceof RootMove)) {
                if (move.occupiesPosition(position)) {
                    return move;
                }
                move = move.parent();
            }
        } else {
            Vector vector = new Vector(5, 10);
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public int getSize() {
        return this.size;
    }

    public Position koPosition() {
        return this.koPosition;
    }

    public void setKoPosition(Position position) {
        this.koPosition = position;
        if (this.window != null) {
            this.window.setKoPosition(position);
        }
        this.ss.setKoPosition(position);
    }

    public void clearKo() {
        this.koPosition = null;
        if (this.window != null) {
            this.window.setKoPosition(null);
        }
        this.ss.setKoPosition(null);
    }

    public int handicap() {
        if (this.firstMove() instanceof HandicapMove) {
            return this.firstMove().numberOfStones();
        }
        return 0;
    }

    public int capturedWhite() {
        return this.capturedWhite;
    }

    public int capturedBlack() {
        return this.capturedBlack;
    }

    public double komi() {
        return this.komi;
    }

    public void setKomi(double d) {
        this.komi = d;
    }

    public String result() {
        return this.result;
    }

    public void setResult(String string) {
        this.result = string;
    }

    public int blackTerritory() {
        return this.blackTerritory;
    }

    public int whiteTerritory() {
        return this.whiteTerritory;
    }

    public int dame() {
        return this.dame;
    }

    public SimpleGroup groupAt(int n, int n2) {
        if (n < 0 || n >= this.size || n2 < 0 || n2 >= this.size) {
            return null;
        }
        return this.groupArray[n][n2];
    }

    public int stoneAt(int n, int n2) {
        if (n < 0 || n >= this.size || n2 < 0 || n2 >= this.size) {
            return 3;
        }
        return this.ss.readStone(n, n2);
    }

    public void addSGFproperty(String string, Vector vector) {
        if (this.unhandledSGFproperties == null) {
            this.unhandledSGFproperties = new Vector(10);
        }
        Vector<Object> vector2 = new Vector<Object>(2);
        vector2.addElement(string);
        vector2.addElement(vector);
        this.unhandledSGFproperties.addElement(vector2);
    }

    public synchronized boolean placeMove(Move move, TerminalWindow terminalWindow, boolean bl, boolean bl2) {
        boolean bl3;
        if (this.scoringMode() && move instanceof GameResultMove) {
            this.exitScoringMode();
        }
        this.isLegalResult.newGroups = null;
        this.isLegalResult.opponentGroups = null;
        this.isLegalResult.failureReason = null;
        boolean bl4 = bl3 = !move.isCommitted();
        if (bl && bl2) {
            move.link();
            return true;
        }
        SimpleGroupVector simpleGroupVector = null;
        if (move.isCommitted()) {
            simpleGroupVector = move.newGroups(this);
            this.updateArrays(move, simpleGroupVector, this.groupsAbutting(move));
        } else if (move.isLegal(this, false, this.isLegalResult)) {
            move.commit();
            simpleGroupVector = this.isLegalResult.newGroups;
            this.updateArrays(move, simpleGroupVector, this.isLegalResult.opponentGroups);
        } else if (this.isLegalResult.failureReason != null) {
            String string = "Illegal move: " + move + " " + this.isLegalResult.failureReason;
            if (terminalWindow == null) {
                Debug.println(string);
            } else {
                terminalWindow.displayString(string);
            }
            return false;
        }
        this.clearKo();
        SimpleGroupVector simpleGroupVector2 = move.capturedGroups();
        if (simpleGroupVector2 != null && simpleGroupVector2.size() == 1 && simpleGroupVector2.elementAt(0).size() == 1 && simpleGroupVector != null && simpleGroupVector.elementAt(0).size() == 1 && simpleGroupVector.elementAt(0).numberOfLiberties() == 1) {
            this.setKoPosition(simpleGroupVector2.elementAt(0).positionAt(0));
        }
        this.setCurrentMove(move);
        if (this.scoringMode()) {
            if (this.scoringLocally && this.scoringEntry == move.parent()) {
                this.scoringEntryFollowedByNewMove = bl3;
            }
            this.scoreGame();
        } else if (move instanceof PassMove && move.parent() instanceof PassMove && (!this.isNetGame() || this.server.isNNGStype() || (this.server.isIGStype() || this.server.isWINGtype()) && move.parent().parent() instanceof PassMove)) {
            this.enterScoringMode(true);
        }
        move.noteMovePlaced(this.ss);
        return true;
    }

    private synchronized void backup(boolean bl) {
        if (this.currentMove != this.root) {
            SimpleGroupVector simpleGroupVector;
            Object object;
            Object object2;
            PositionVector positionVector;
            Move move = this.currentMove;
            if (bl && this.scoringMode()) {
                if (this.currentMove == this.scoringEntry) {
                    this.exitScoringMode();
                } else if (this.currentMove instanceof PassMove && this.currentMove.parent() instanceof PassMove && (!this.isNetGame() || this.server.isNNGStype() || (this.server.isIGStype() || this.server.isWINGtype()) && this.currentMove.parent().parent() instanceof PassMove)) {
                    this.exitScoringMode();
                }
            }
            if ((positionVector = this.currentMove.placedPositions(this.size())) != null) {
                for (int i = 0; i < positionVector.size(); ++i) {
                    Position position = positionVector.elementAt(i);
                    this.ss.writeStone(position.row, position.column, 3);
                    this.groupArray[position.row][position.column] = null;
                    object2 = new SimpleGroupVector(0, 4);
                    PositionVector positionVector2 = this.positionsAbutting(position);
                    if (positionVector2 == null) continue;
                    for (int j = 0; j < positionVector2.size(); ++j) {
                        object = positionVector2.elementAt(j);
                        SimpleGroup simpleGroup = this.groupArray[((Position)object).row][((Position)object).column];
                        if (((SimpleGroupVector)object2).indexOf(simpleGroup) != -1) continue;
                        if (simpleGroup.color() != this.currentMove.color()) {
                            simpleGroup.addLiberty(position);
                            continue;
                        }
                        ((SimpleGroupVector)object2).addElement(this.recomputeGroupAt((Position)object));
                    }
                }
            }
            if ((simpleGroupVector = this.currentMove.capturedGroups()) != null) {
                for (int i = 0; i < simpleGroupVector.size(); ++i) {
                    this.uncaptureGroup(simpleGroupVector.elementAt(i));
                    if (positionVector == null || positionVector.size() != 1) continue;
                    simpleGroupVector.elementAt(i).addLiberty(positionVector.elementAt(0));
                }
            }
            SimpleGroupVector simpleGroupVector2 = this.currentMove.parent().capturedGroups();
            object2 = this.currentMove.parent().placedPositions(this.getSize());
            boolean bl2 = false;
            if (this.currentMove.parent() != this.root && simpleGroupVector2 != null && simpleGroupVector2.size() == 1 && simpleGroupVector2.elementAt(0).size() == 1 && object2 != null && ((PositionVector)object2).size() == 1) {
                Position position = ((PositionVector)object2).elementAt(0);
                object = this.groupAt(position.row, position.column);
                if (object != null && ((SimpleGroup)object).size() == 1 && ((SimpleGroup)object).numberOfLiberties() == 1) {
                    this.setKoPosition(simpleGroupVector2.elementAt(0).positionAt(0));
                    bl2 = true;
                }
            }
            if (!bl2) {
                this.clearKo();
            }
            move.noteMoveUndone(this.ss);
            this.setCurrentMove(this.currentMove.parent());
            if (bl) {
                if (this.scoringMode()) {
                    this.scoreGame();
                } else if (move instanceof GameResultMove) {
                    this.enterScoringMode(false);
                }
            }
        }
    }

    private SimpleGroup recomputeGroupAt(Position position) {
        int[] nArray = new int[]{-1, 1, 0, 0};
        int[] nArray2 = new int[]{0, 0, -1, 1};
        int n = this.ss.readStone(position.row, position.column);
        SimpleGroup simpleGroup = new SimpleGroup(n);
        PositionVector positionVector = new PositionVector(20, 30);
        PositionVector positionVector2 = new PositionVector(30, 40);
        positionVector.addElement(position);
        while (positionVector.size() != 0) {
            int n2;
            Position position2 = positionVector.elementAt(0);
            PositionVector positionVector3 = this.getLiberties(position2);
            int n3 = position2.row;
            int n4 = position2.column;
            simpleGroup.addPosition(position2);
            for (n2 = 0; n2 < positionVector3.size(); ++n2) {
                simpleGroup.addLiberty(positionVector3.elementAt(n2));
            }
            this.groupArray[n3][n4] = simpleGroup;
            positionVector.removeElementAt(0);
            positionVector2.addElement(position2);
            for (n2 = 0; n2 < 4; ++n2) {
                int n5 = n3 - nArray2[n2];
                int n6 = n4 - nArray[n2];
                if (n5 < 0 || n6 < 0 || n5 >= this.size || n6 >= this.size || this.ss.readStone(n5, n6) != n || positionVector2.isMember(n5, n6)) continue;
                positionVector.addElement(new Position(n5, n6));
            }
        }
        return simpleGroup;
    }

    public void goBackward(int n, boolean bl) {
        do {
            this.backup(true);
        } while (this.currentMove != this.root && --n != 0 && (!bl || !this.currentMove.isBranch()));
    }

    public void goBackward(Move move) {
        while (this.currentMove != this.root && this.currentMove != move) {
            this.backup(true);
        }
    }

    public void goForward(int n, Move move, boolean bl, Move move2, boolean bl2) {
        if (this.currentMove != this.finalMove()) {
            if (move != null && this.currentMove.isVariation(move)) {
                this.placeMove(move, null, true, false);
                --n;
            }
            for (Move move3 = this.currentMove.child(); move3 != null && n != 0; move3 = move3.child(), --n) {
                this.placeMove(move3, null, true, false);
                if (move3 == move2 || bl && move3 != null && move3.isBranch() || bl2 && move3 != null && move3.hasKibitzes()) break;
            }
        }
    }

    public void goToEnd() {
        this.goForward(-1, null, false, null, false);
    }

    public void goToBeginning() {
        this.exitScoringMode();
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                this.ss.writeStone(i, j, 3);
                this.groupArray[i][j] = null;
            }
        }
        this.clearKo();
        this.capturedBlack = 0;
        this.capturedWhite = 0;
        this.setCurrentMove(this.root);
    }

    public void goBackToKibitz() {
        do {
            this.backup(true);
        } while (this.currentMove != this.root && (this.currentMove.kibitzes() == null || this.currentMove.kibitzes().size() == 0));
    }

    public void undo() {
        Move move = this.finalServerMove();
        move.setIsVariation(true);
        if (move == this.currentMove) {
            this.goBackward(1, false);
            this.ss.emit();
        }
    }

    private PositionVector positionsAbutting(Position position) {
        PositionVector positionVector = new PositionVector(0, 4);
        int n = position.row;
        int n2 = position.column;
        if (this.stoneAt(n + 1, n2) != 3) {
            positionVector.addElement(new Position(n + 1, n2));
        }
        if (this.stoneAt(n - 1, n2) != 3) {
            positionVector.addElement(new Position(n - 1, n2));
        }
        if (this.stoneAt(n, n2 + 1) != 3) {
            positionVector.addElement(new Position(n, n2 + 1));
        }
        if (this.stoneAt(n, n2 - 1) != 3) {
            positionVector.addElement(new Position(n, n2 - 1));
        }
        return positionVector.size() == 0 ? null : positionVector;
    }

    public SimpleGroupVector groupsAbutting(Move move) {
        SimpleGroupVector simpleGroupVector = null;
        PositionVector positionVector = move.placedPositions(this.size);
        if (positionVector != null) {
            simpleGroupVector = new SimpleGroupVector(1, 2);
            for (int i = 0; i < positionVector.size(); ++i) {
                this.groupsAbutting(positionVector.elementAt(i), Move.nextColor(move.color()), simpleGroupVector);
            }
        }
        return simpleGroupVector;
    }

    public SimpleGroupVector groupsAbutting(Position position, int n) {
        return this.groupsAbutting(position, n, null);
    }

    public SimpleGroupVector groupsAbutting(Position position, int n, SimpleGroupVector simpleGroupVector) {
        int n2;
        int n3;
        SimpleGroup simpleGroup;
        if (simpleGroupVector == null) {
            simpleGroupVector = new SimpleGroupVector(1, 2);
        }
        if ((simpleGroup = this.groupAt((n3 = position.row) - 1, n2 = position.column)) != null && simpleGroup.color() == n && simpleGroupVector.indexOf(simpleGroup) == -1) {
            simpleGroupVector.addElement(simpleGroup);
        }
        if ((simpleGroup = this.groupAt(n3 + 1, n2)) != null && simpleGroup.color() == n && simpleGroupVector.indexOf(simpleGroup) == -1) {
            simpleGroupVector.addElement(simpleGroup);
        }
        if ((simpleGroup = this.groupAt(n3, n2 - 1)) != null && simpleGroup.color() == n && simpleGroupVector.indexOf(simpleGroup) == -1) {
            simpleGroupVector.addElement(simpleGroup);
        }
        if ((simpleGroup = this.groupAt(n3, n2 + 1)) != null && simpleGroup.color() == n && simpleGroupVector.indexOf(simpleGroup) == -1) {
            simpleGroupVector.addElement(simpleGroup);
        }
        if (simpleGroupVector.size() == 0) {
            return null;
        }
        return simpleGroupVector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureGroup(SimpleGroup simpleGroup) {
        int n = Move.nextColor(simpleGroup.color());
        StoneStasher stoneStasher = this.ss;
        synchronized (stoneStasher) {
            for (int i = 0; i < simpleGroup.size(); ++i) {
                Position position = simpleGroup.positionAt(i);
                this.ss.writeStone(position.row, position.column, 3);
                this.groupArray[position.row][position.column] = null;
                SimpleGroupVector simpleGroupVector = this.groupsAbutting(position, n);
                if (simpleGroupVector == null) continue;
                for (int j = 0; j < simpleGroupVector.size(); ++j) {
                    SimpleGroup simpleGroup2 = simpleGroupVector.elementAt(j);
                    simpleGroup2.addLiberty(position);
                }
            }
            if (simpleGroup.color() == 0) {
                this.capturedBlack += simpleGroup.size();
            } else {
                this.capturedWhite += simpleGroup.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uncaptureGroup(SimpleGroup simpleGroup) {
        if (Debug.debugGameLogicp) {
            Debug.println("uncaptureGroup(): " + simpleGroup);
        }
        int n = simpleGroup.color();
        int n2 = Move.nextColor(n);
        StoneStasher stoneStasher = this.ss;
        synchronized (stoneStasher) {
            for (int i = 0; i < simpleGroup.size(); ++i) {
                Position position = simpleGroup.positionAt(i);
                this.ss.writeStone(position.row, position.column, n);
                this.groupArray[position.row][position.column] = simpleGroup;
                SimpleGroupVector simpleGroupVector = this.groupsAbutting(position, n2);
                if (simpleGroupVector == null) continue;
                for (int j = 0; j < simpleGroupVector.size(); ++j) {
                    SimpleGroup simpleGroup2 = simpleGroupVector.elementAt(j);
                    simpleGroup2.removeLiberty(position);
                }
            }
            SimpleGroup simpleGroup3 = this.recomputeGroupAt(simpleGroup.positionAt(0));
            if (Debug.debugGameLogicp && !simpleGroup.equals(simpleGroup3)) {
                Debug.println("newGroup = " + simpleGroup3);
            }
            if (n == 0) {
                this.capturedBlack -= simpleGroup.size();
            } else {
                this.capturedWhite -= simpleGroup.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateArrays(Move move, SimpleGroupVector simpleGroupVector, SimpleGroupVector simpleGroupVector2) {
        StoneStasher stoneStasher = this.ss;
        synchronized (stoneStasher) {
            int n;
            SimpleGroup simpleGroup;
            int n2;
            if (simpleGroupVector != null) {
                for (n2 = 0; n2 < simpleGroupVector.size(); ++n2) {
                    simpleGroup = simpleGroupVector.elementAt(n2);
                    n = simpleGroup.color();
                    for (int i = 0; i < simpleGroup.size(); ++i) {
                        Position position = simpleGroup.positionAt(i);
                        this.groupArray[position.row][position.column] = simpleGroup;
                        this.ss.writeStone(position.row, position.column, n);
                    }
                }
            }
            if (move.capturedGroups() != null) {
                for (n2 = 0; n2 < move.capturedGroups().size(); ++n2) {
                    this.captureGroup(move.capturedGroups().elementAt(n2));
                }
            }
            if (simpleGroupVector2 != null) {
                for (n2 = 0; n2 < simpleGroupVector2.size(); ++n2) {
                    simpleGroup = simpleGroupVector2.elementAt(n2);
                    for (n = 0; n < move.placedPositions(this.size).size(); ++n) {
                        Position position = move.placedPositions(this.size).elementAt(n);
                        simpleGroup.removeLiberty(position);
                    }
                }
            }
        }
    }

    public SimpleGroup composeGroups(SimpleGroupVector simpleGroupVector, int n, Position position) {
        SimpleGroup simpleGroup = new SimpleGroup(n);
        if (simpleGroupVector != null) {
            int n2;
            SimpleGroup simpleGroup2;
            int n3;
            for (n3 = 0; n3 < simpleGroupVector.size(); ++n3) {
                simpleGroup2 = simpleGroupVector.elementAt(n3);
                for (n2 = 0; n2 < simpleGroup2.size(); ++n2) {
                    simpleGroup.addPosition(simpleGroup2.positionAt(n2));
                }
            }
            for (n3 = 0; n3 < simpleGroupVector.size(); ++n3) {
                simpleGroup2 = simpleGroupVector.elementAt(n3);
                for (n2 = 0; n2 < simpleGroup2.numberOfLiberties(); ++n2) {
                    simpleGroup.addLiberty(simpleGroup2.libertyAt(n2));
                }
            }
        }
        simpleGroup.addPosition(position);
        PositionVector positionVector = this.getLiberties(position);
        for (int i = 0; i < positionVector.size(); ++i) {
            simpleGroup.addLiberty(positionVector.elementAt(i));
        }
        return simpleGroup;
    }

    public PositionVector getLiberties(Position position) {
        PositionVector positionVector = new PositionVector(2, 4);
        int n = position.row;
        int n2 = position.column;
        int n3 = this.size - 1;
        if (n > 0 && this.ss.readStone(n - 1, n2) == 3) {
            positionVector.addElement(new Position(n - 1, n2));
        }
        if (n < n3 && this.ss.readStone(n + 1, n2) == 3) {
            positionVector.addElement(new Position(n + 1, n2));
        }
        if (n2 < n3 && this.ss.readStone(n, n2 + 1) == 3) {
            positionVector.addElement(new Position(n, n2 + 1));
        }
        if (n2 > 0 && this.ss.readStone(n, n2 - 1) == 3) {
            positionVector.addElement(new Position(n, n2 - 1));
        }
        return positionVector;
    }

    public int numberOfLiberties(Position position) {
        int n = 0;
        int n2 = position.row;
        int n3 = position.column;
        int n4 = this.size - 1;
        if (n2 > 0 && this.ss.readStone(n2 - 1, n3) == 3) {
            ++n;
        }
        if (n2 < n4 && this.ss.readStone(n2 + 1, n3) == 3) {
            ++n;
        }
        if (n3 < n4 && this.ss.readStone(n2, n3 + 1) == 3) {
            ++n;
        }
        if (n3 > 0 && this.ss.readStone(n2, n3 - 1) == 3) {
            ++n;
        }
        return n;
    }

    public boolean scoringMode() {
        return this.scoringMode;
    }

    public boolean scoringLocally() {
        return this.scoringLocally;
    }

    public void enterScoringMode(boolean bl) {
        if (!this.scoringMode()) {
            this.scoringMode = true;
            this.scoringEntry = this.currentMove;
            this.scoringLocally = bl;
            this.scoreGame();
            if (this.window != null) {
                this.window.noteScoringMode(true);
            }
        }
    }

    public void exitScoringMode() {
        if (this.scoringMode()) {
            Debug.assertion(this.scoringEntry != null, "Game: scoringEntry == null while in scoring mode.");
            this.scoringMode = false;
            this.clearMarkedTerritory();
            if (this.scoringLocally) {
                Move move = null;
                while (this.scoringEntry.moveNumber() < this.currentMove.moveNumber()) {
                    move = this.currentMove;
                    this.backup(false);
                }
                if (move != null && move.isVariation() && this.scoringEntryFollowedByNewMove) {
                    this.currentMove.removeVariation(move);
                }
                this.ss.emit();
            }
            this.scoringEntryFollowedByNewMove = false;
            this.scoringLocally = false;
            this.scoringEntry = null;
            if (this.window != null) {
                this.window.noteScoringMode(false);
            }
        }
    }

    private void clearMarkedTerritory() {
        for (int i = 0; i < this.size(); ++i) {
            block4: for (int j = 0; j < this.size(); ++j) {
                int n = this.ss.readAnyStone(i, j);
                switch (n) {
                    case 0: 
                    case 1: 
                    case 3: {
                        continue block4;
                    }
                    default: {
                        this.ss.writeStone(i, j, 3);
                    }
                }
            }
        }
        this.ss.emit();
    }

    public int markRegion(int n, int n2) {
        int n3;
        PositionVector positionVector = this.scoringQueue;
        int n4 = 3;
        positionVector.setSize(0);
        positionVector.addElement(new Position(n, n2));
        while (positionVector.size() != 0) {
            Position position = positionVector.elementAt(positionVector.size() - 1);
            positionVector.removeElementAt(positionVector.size() - 1);
            int[] nArray = new int[]{-1, 1, 0, 0, 0};
            int[] nArray2 = new int[]{0, 0, 0, -1, 1};
            for (n3 = 0; n3 < nArray.length; ++n3) {
                int n5 = position.row + nArray2[n3];
                int n6 = position.column + nArray[n3];
                if (n5 < 0 || n6 < 0 || n5 >= this.size || n6 >= this.size) continue;
                int n7 = this.ss.readAnyStone(n5, n6);
                if (n7 == 3) {
                    this.ss.writeStone(n5, n6, 6, false);
                    positionVector.addElement(new Position(n5, n6));
                    continue;
                }
                if (n7 != 0 && n7 != 1) continue;
                if (n4 == 3) {
                    n4 = n7;
                    continue;
                }
                if (n4 == n7) continue;
                n4 = 7;
            }
        }
        switch (n4) {
            case 1: {
                n4 = 4;
                break;
            }
            case 0: {
                n4 = 5;
            }
        }
        int n8 = 0;
        boolean bl = n4 != 7;
        for (int i = 0; i < this.size; ++i) {
            for (n3 = 0; n3 < this.size; ++n3) {
                if (this.ss.readAnyStone(i, n3) != 6) continue;
                this.ss.writeStone(i, n3, n4, bl);
                ++n8;
            }
        }
        return n8;
    }

    public void scoreGame() {
        int n;
        int n2;
        if (this.getCurrentMove() instanceof GameResultMove) {
            return;
        }
        this.blackTerritory = 0;
        this.whiteTerritory = 0;
        this.dame = 0;
        for (n2 = 0; n2 < this.size; ++n2) {
            for (n = 0; n < this.size; ++n) {
                switch (this.ss.readAnyStone(n2, n)) {
                    case 4: 
                    case 5: {
                        this.ss.writeStone(n2, n, 3);
                    }
                }
            }
        }
        for (n2 = 0; n2 < this.size; ++n2) {
            block10: for (n = 0; n < this.size; ++n) {
                if (this.ss.readAnyStone(n2, n) == 3) {
                    int n3 = this.markRegion(n2, n);
                    int n4 = this.ss.readAnyStone(n2, n);
                    if (n4 == 5) {
                        this.blackTerritory += n3;
                        continue;
                    }
                    if (n4 != 4) continue;
                    this.whiteTerritory += n3;
                    continue;
                }
                if (this.scoringRules != 'C') continue;
                switch (this.ss.readStone(n2, n)) {
                    case 0: {
                        ++this.blackTerritory;
                        continue block10;
                    }
                    case 1: {
                        ++this.whiteTerritory;
                    }
                }
            }
        }
        for (n2 = 0; n2 < this.size; ++n2) {
            for (n = 0; n < this.size; ++n) {
                if (this.ss.readAnyStone(n2, n) != 7) continue;
                this.ss.writeStone(n2, n, 3, false);
                ++this.dame;
            }
        }
        this.ss.emit();
    }

    public SimpleGroupVector groupsInRegion(Position position) {
        SimpleGroupVector simpleGroupVector = new SimpleGroupVector(5, 10);
        PositionVector positionVector = this.scoringQueue;
        SimpleGroup simpleGroup = this.groupAt(position.row, position.column);
        if (simpleGroup != null) {
            Object object;
            int n;
            int n2 = simpleGroup.color();
            simpleGroupVector.addElement(simpleGroup);
            positionVector.setSize(0);
            for (n = 0; n < simpleGroup.size(); ++n) {
                object = simpleGroup.positionAt(n);
                this.ss.writeStone(((Position)object).row, ((Position)object).column, 6, false);
                positionVector.addElement((Position)object);
            }
            while (positionVector.size() != 0) {
                Position position2 = positionVector.elementAt(positionVector.size() - 1);
                positionVector.removeElementAt(positionVector.size() - 1);
                object = new int[]{-1, 1, 0, 0};
                int[] nArray = new int[]{0, 0, -1, 1};
                for (int i = 0; i < ((Object)object).length; ++i) {
                    int n3 = position2.row + nArray[i];
                    int n4 = position2.column + object[i];
                    if (n3 < 0 || n4 < 0 || n3 >= this.size || n4 >= this.size) continue;
                    int n5 = this.ss.readAnyStone(n3, n4);
                    if (n5 == n2) {
                        SimpleGroup simpleGroup2 = this.groupAt(n3, n4);
                        simpleGroupVector.addElement(simpleGroup2);
                        for (int j = 0; j < simpleGroup2.size(); ++j) {
                            Position position3 = simpleGroup2.positionAt(j);
                            this.ss.writeStone(position3.row, position3.column, 6, false);
                            positionVector.addElement(position3);
                        }
                        continue;
                    }
                    if (n5 != 3) continue;
                    this.ss.writeStone(n3, n4, 6, false);
                    positionVector.addElement(new Position(n3, n4));
                }
            }
            for (n = 0; n < simpleGroupVector.size(); ++n) {
                object = simpleGroupVector.elementAt(n);
                for (int i = 0; i < ((SimpleGroup)object).size(); ++i) {
                    Position position4 = ((SimpleGroup)object).positionAt(i);
                    this.ss.writeStone(position4.row, position4.column, n2, false);
                }
            }
            for (n = 0; n < this.size; ++n) {
                for (int i = 0; i < this.size; ++i) {
                    if (this.ss.readAnyStone(n, i) != 6) continue;
                    this.ss.writeStone(n, i, 3, false);
                }
            }
        }
        return simpleGroupVector;
    }

    public void writeSGF(PrintWriter printWriter) {
        Move move;
        if (printWriter == null) {
            printWriter = new PrintWriter(System.out);
        }
        int n = -1;
        while ((move = this.root.variationAt(n)) != null) {
            printWriter.print("(;FF[4]AP[Ergo:" + Ergo.version() + "]\nGM[1]\nSZ[" + this.size() + "]\nGN[" + (this.window == null ? "" : this.window.title(false)) + "]\nRE[" + this.SGFresult() + "]\nPW[" + this.whiteName + "]WR[" + this.whiteRank + "]\nPB[" + this.blackName + "]BR[" + this.blackRank + "]\nPC[" + this.SGFlocation() + "]\nDT[" + this.SGFdate(this.startTime) + "]\nTM[" + this.SGFtime() + "]KM[" + this.komi() + "]\n");
            move.writeSGF(printWriter, this, 4);
            printWriter.print("\n;)\n\n");
            ++n;
        }
    }

    public String SGFtime() {
        return "0";
    }

    public String SGFlocation() {
        return this.SGFlocation != null ? this.SGFlocation : (this.server != null ? this.server.name : "unknown");
    }

    public String SGFdate(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        return n + "-" + (n2 < 10 ? "0" : "") + n2 + "-" + (n3 < 10 ? "0" : "") + n3;
    }

    public String SGFresult() {
        return this.result() == null ? "?" : this.result;
    }
}

