/*
 * Decompiled with CFR 0.152.
 */
package ergo.logic;

import ergo.logic.Game;
import ergo.logic.HandicapMove;
import ergo.logic.Move;
import ergo.logic.PassMove;
import ergo.logic.RootMove;
import ergo.logic.SGFParseException;
import ergo.logic.StoneMove;
import ergo.ui.TerminalWindow;
import ergo.util.Debug;
import ergo.util.Position;
import ergo.util.PositionVector;
import java.io.EOFException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Vector;

public final class SGF {
    private static final int SNAMEINDEX = 0;
    private static final int PTYPEINDEX = 1;
    private static final int VTYPEINDEX = 2;
    private static final int LNAMEINDEX = 3;
    private static final int SGF3_MAXGAMESIZE = 26;
    public static final int nodesPerLine = 4;
    private static final String[][] PROPERTIES = new String[][]{{"AB", "s", "lp", "AddBlack"}, {"AE", "s", "lp", "AddEmpty"}, {"AN", "g", "s", "ANnotation"}, {"AP", "r", ":sn", "APlication"}, {"AR", "", ":lp", "ARrow"}, {"AW", "s", "lp", "AddWhite"}, {"B", "m", "p", "Black"}, {"BL", "m", "r", "BlackLeft"}, {"BM", "m", "d", "BadMove"}, {"BR", "g", "s", "BlackRank"}, {"BT", "g", "s", "BlackTeam"}, {"C", "", "t", "Comment"}, {"CA", "r", "s", "ChAracterset"}, {"CP", "g", "s", "CoPyright"}, {"CR", "", "lp", "CiRcle"}, {"DD", "", "ep", "DD"}, {"DM", "", "d", "DM"}, {"DO", "m", "", "DOubtful"}, {"DT", "g", "s", "DaTe"}, {"EV", "g", "s", "EVent"}, {"FF", "r", "n", "FileFormat"}, {"FG", "", ":ns", "FiGure"}, {"GB", "", "d", "GoodforBlack"}, {"GC", "g", "t", "GameComment"}, {"GM", "r", "n", "GaMe"}, {"GN", "g", "s", "GameName"}, {"GW", "", "d", "GoodforWhite"}, {"HA", "g", "n", "HAndicap"}, {"HO", "", "d", "HOtspot"}, {"IT", "m", "", "InTeresting"}, {"KM", "g", "r", "KoMi"}, {"KO", "m", "", "KO"}, {"LB", "", "", "LaBel"}, {"LN", "", "", "LiNe"}, {"MA", "", "lp", "MArk"}, {"MN", "m", "n", "MoveNumber"}, {"N", "", "s", "Nodename"}, {"OB", "m", "n", "OvertimeBlack"}, {"ON", "g", "t", "OpeNing"}, {"OT", "g", "s", "OverTime"}, {"OW", "m", "n", "OvertimeWhite"}, {"PB", "g", "s", "PlayerBlack"}, {"PC", "g", "s", "PlaCe"}, {"PL", "s", "c", "PLayer"}, {"PM", "", "n", "PrintMove"}, {"PW", "g", "s", "PlayerWhite"}, {"RE", "g", "s", "REsult"}, {"RO", "g", "s", "ROund"}, {"RU", "g", "s", "RUles"}, {"SL", "", "lp", "SeLected"}, {"SO", "g", "s", "SOurce"}, {"SQ", "", "lp", "SQuare"}, {"ST", "r", "n", "STyle"}, {"SZ", "r", ":nn", "SiZe"}, {"TB", "", "ep", "TerritoryBlack"}, {"TE", "m", "d", "TEsuji"}, {"TM", "g", "r", "TiMelimit"}, {"TR", "", "lp", "TRiangle"}, {"TW", "", "ep", "TerritoryWhite"}, {"UC", "", "d", "UnClear"}, {"US", "g", "s", "USer"}, {"V", "", "r", "Value"}, {"VW", "", "ep", "VieW"}, {"W", "m", "p", "White"}, {"WL", "m", "r", "WhitetimeLeft"}, {"WR", "g", "s", "WhiteRank"}, {"WT", "g", "s", "WhiteTeam"}};
    private char prevChar = (char)32;
    private int filepos = 0;
    private int lineNum = 0;
    private int maxfilepos = 0;
    private static final int BUFFSIZE = 500;
    private char[] buffer = new char[500];
    private int bufferIndex = 0;
    private int bufferEnd = 0;
    private TerminalWindow term = null;
    public boolean pedantic = true;

    public SGF() {
    }

    public SGF(TerminalWindow terminalWindow) {
        this.term = terminalWindow;
    }

    public Vector readSGFFile(String string) throws Exception {
        FileReader fileReader = new FileReader(string);
        return this.parseCollection(fileReader);
    }

    char nextChar(Reader reader) throws IOException {
        char c;
        if (this.bufferIndex >= this.bufferEnd) {
            this.bufferEnd = reader.read(this.buffer);
            this.bufferIndex = 0;
            if (this.bufferEnd == -1) {
                throw new EOFException();
            }
        }
        if ((c = this.buffer[this.bufferIndex++]) == '\n' && this.filepos == this.maxfilepos) {
            ++this.lineNum;
        }
        ++this.filepos;
        this.maxfilepos = Math.max(this.filepos, this.maxfilepos);
        return c;
    }

    void backup() throws SGFParseException {
        if (this.bufferIndex < 0) {
            this.error("Internal error: Attempt to backup past beginning of input.");
        } else {
            --this.bufferIndex;
            --this.filepos;
        }
    }

    char skipWhite(Reader reader) throws IOException {
        char c;
        while (Character.isWhitespace(c = this.nextChar(reader))) {
        }
        return c;
    }

    void error(String string) throws SGFParseException {
        String string2 = "Error at line " + (this.lineNum + 1) + ": " + string;
        Debug.backtrace();
        throw new SGFParseException(string2);
    }

    void warn(String string) {
        String string2 = "Warning at line " + (this.lineNum + 1) + ": " + string;
        if (this.term != null) {
            this.term.displayString(string2);
        } else {
            Debug.println(string2);
        }
    }

    static final boolean isUCAlpha(char c) {
        return c >= 'A' && c <= 'Z';
    }

    static final boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || SGF.isUCAlpha(c);
    }

    static final boolean isLineBreakChar(char c) {
        return c == '\n' || c == '\r';
    }

    Vector parseCollection(Reader reader) throws SGFParseException, IOException {
        Vector<Game> vector = new Vector<Game>();
        while (true) {
            try {
                char c;
                while ((c = this.nextChar(reader)) != '(') {
                }
                this.backup();
            }
            catch (EOFException eOFException) {
                if (vector.size() > 0) {
                    return vector;
                }
                this.error("End of file reached while searching for game tree.");
            }
            Game game = this.parseGameTree(reader, true);
            vector.addElement(game);
        }
    }

    Game parseGameTree(Reader reader, boolean bl) throws SGFParseException, IOException {
        Game game = new Game();
        this.parseGameTreeInternal(reader, game, bl);
        game.goToBeginning();
        return game;
    }

    void parseGameTreeInternal(Reader reader, Game game, boolean bl) throws SGFParseException, IOException {
        char c = this.skipWhite(reader);
        if (c == '(') {
            while (true) {
                Move move = game.getCurrentMove();
                char c2 = this.skipWhite(reader);
                if (c2 == ';') {
                    this.backup();
                    Node node = new Node(reader, game);
                    if (node.isMove(game)) {
                        Move move2 = node.toMove(game);
                        if (move2 == null) {
                            this.warn("Ignoring null move.");
                            continue;
                        }
                        if (!game.placeMove(move2, null, false, false)) {
                            this.error("Illegal move node (" + node + ") encountered.");
                            continue;
                        }
                        move = move2;
                        continue;
                    }
                    this.warn("Ignoring non-move node: " + node);
                    continue;
                }
                if (c2 == '(') {
                    this.backup();
                    this.parseGameTreeInternal(reader, game, false);
                    game.goBackward(move);
                    continue;
                }
                if (c2 == ')') {
                    return;
                }
                this.error("Expected ';', '(', or ')'.  Found '" + c2 + "' instead.");
            }
        }
        this.error("Expected '('.  Found '" + c + "' instead.");
    }

    void notePropertySeen(String string, Vector vector, Game game) throws SGFParseException {
        String string2 = (String)vector.elementAt(0);
        if ("SZ".equals(string)) {
            if (string.indexOf(58) != -1) {
                this.error("Non-square board sizes not yet supported.");
            }
            try {
                game.setSize(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                this.warn("Invalid game size (SZ) property: " + string2);
            }
        } else if ("KM".equals(string)) {
            game.setKomi(new Double(string2));
        } else if ("PC".equals(string)) {
            game.SGFlocation = string2;
        } else if ("PB".equals(string)) {
            game.blackName = string2;
        } else if ("PW".equals(string)) {
            game.whiteName = string2;
        } else if ("BR".equals(string)) {
            game.blackRank = string2;
        } else if ("WR".equals(string)) {
            game.whiteRank = string2;
        } else if ("RE".equals(string)) {
            game.result = string2;
        } else if ("FF".equals(string)) {
            try {
                int n = Integer.parseInt(string2);
                if (n != 4) {
                    this.warn("SGF version " + n + " is not fully supported." + "  This file may not load correctly.");
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.warn("Invalid File Format (FF) property: " + string2);
            }
        } else {
            String[] stringArray = SGF.getPropInfo(string);
            if (stringArray == null) {
                this.warn(string + " is not a recognized SGF4 property name.");
            }
            if (stringArray != null && "r".equals(stringArray[1])) {
                game.addSGFproperty(string, vector);
            } else {
                game.getCurrentMove().addSGFproperty(string, vector);
            }
        }
    }

    public static String[] getPropInfo(String string) {
        for (int i = 0; i < PROPERTIES.length; ++i) {
            if (!PROPERTIES[i][0].equals(string)) continue;
            return PROPERTIES[i];
        }
        return null;
    }

    boolean isSimpleText(String string) {
        String[] stringArray = SGF.getPropInfo(string);
        return stringArray == null ? false : "s".equals(stringArray[2]);
    }

    private boolean isText(String string) {
        String[] stringArray = SGF.getPropInfo(string);
        return stringArray == null ? true : "t".equals(stringArray[2]);
    }

    public static void writeText(PrintWriter printWriter, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ']' || c == '\\' || c == ':') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        printWriter.print(stringBuffer.toString());
    }

    class Node {
        private Vector nodeProperties = new Vector();
        private Vector nodeValues = new Vector();

        Node(Reader reader, Game game) throws SGFParseException, IOException {
            char c = SGF.this.skipWhite(reader);
            if (c != ';') {
                SGF.this.error("';' expected at beginning of node.  '" + c + "' found.");
            }
            while (true) {
                if ((c = SGF.this.skipWhite(reader)) == ';' || c == '(' || c == ')') break;
                if (SGF.isAlpha(c)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(c);
                    while (true) {
                        if (SGF.isAlpha(c = SGF.this.skipWhite(reader))) {
                            if (!SGF.isUCAlpha(c)) continue;
                            stringBuffer.append(c);
                            continue;
                        }
                        if (c == '[') break;
                        SGF.this.error("Alphabetic character or '[' expected, '" + c + "' found.");
                    }
                    SGF.this.backup();
                    String string = stringBuffer.toString();
                    this.nodeProperties.addElement(string);
                    Vector<String> vector = new Vector<String>(1, 10);
                    while (SGF.this.skipWhite(reader) == '[') {
                        stringBuffer.setLength(0);
                        if (SGF.this.isSimpleText(string)) {
                            this.readSimpleTextProperty(reader, stringBuffer);
                        } else if (SGF.this.isText(string)) {
                            this.readTextProperty(reader, stringBuffer);
                        } else {
                            while ((c = SGF.this.skipWhite(reader)) != ']') {
                                stringBuffer.append(c);
                            }
                        }
                        vector.addElement(stringBuffer.toString());
                    }
                    SGF.this.backup();
                    this.nodeValues.addElement(vector);
                    SGF.this.notePropertySeen(string, vector, game);
                    continue;
                }
                SGF.this.error("Expected ;, (, ), or an alphabetic character at end of node.  '" + c + "' found.");
            }
            SGF.this.backup();
        }

        void readTextProperty(Reader reader, StringBuffer stringBuffer) throws IOException {
            boolean bl = false;
            char c = SGF.this.prevChar;
            while (true) {
                char c2 = SGF.this.nextChar(reader);
                if (bl) {
                    if (!SGF.isLineBreakChar(c2)) {
                        stringBuffer.append(c2);
                    }
                    bl = false;
                } else if (c2 == '\\') {
                    bl = true;
                } else if (Character.isWhitespace(c2)) {
                    if (SGF.isLineBreakChar(c2)) {
                        if (c2 == c || !SGF.isLineBreakChar(c)) {
                            stringBuffer.append('\n');
                        }
                    } else {
                        c2 = ' ';
                        stringBuffer.append(c2);
                    }
                } else {
                    if (c2 == ']') break;
                    stringBuffer.append(c2);
                }
                c = c2;
            }
        }

        void readSimpleTextProperty(Reader reader, StringBuffer stringBuffer) throws IOException {
            boolean bl = false;
            while (true) {
                int n = SGF.this.nextChar(reader);
                if (bl) {
                    bl = false;
                } else {
                    if (n == 92) {
                        bl = true;
                        continue;
                    }
                    if (Character.isWhitespace((char)n)) {
                        n = 32;
                    } else if (n == 93) break;
                }
                stringBuffer.append((char)n);
            }
        }

        private Vector getPropertyValues(String string) {
            for (int i = 0; i < this.nodeProperties.size(); ++i) {
                if (!string.equals((String)this.nodeProperties.elementAt(i))) continue;
                return (Vector)this.nodeValues.elementAt(i);
            }
            return null;
        }

        private String getPropertyValue(String string) {
            if (string == null) {
                return null;
            }
            Vector vector = this.getPropertyValues(string);
            if (vector != null && vector.size() > 0) {
                return (String)vector.elementAt(0);
            }
            return null;
        }

        private String getColor() {
            if (this.getPropertyValue("B") != null || this.getPropertyValue("HA") != null) {
                return "B";
            }
            if (this.getPropertyValue("W") != null) {
                return "W";
            }
            return null;
        }

        private boolean isMove(Game game) {
            return game.getCurrentMove() instanceof RootMove || this.getColor() != null;
        }

        private Position SGFtoPosition(String string, int n) throws SGFParseException {
            if (string == null || string.length() < 2) {
                SGF.this.error("Invalid move: " + string);
            }
            char c = string.charAt(1);
            char c2 = string.charAt(0);
            int n2 = c2 >= 'a' && c2 <= 'z' ? c2 - 97 : c2 - 65 + 26;
            int n3 = c >= 'a' && c <= 'z' ? c - 97 : c - 65 + 26;
            n3 = n - 1 - n3;
            if (n2 < 0 || n3 < 0) {
                SGF.this.error("Invalid move: " + string);
            } else if (string.length() > 2) {
                SGF.this.warn("Ignoring extra characters in move: " + string);
            }
            return new Position(n3, n2);
        }

        Move toMove(Game game) throws SGFParseException {
            Object object;
            Object object2;
            Move move = game.getCurrentMove();
            int n = game.size();
            int n2 = move.moveNumber() + 1;
            String string = this.getColor();
            int n3 = "B".equals(string) ? 0 : 1;
            String string2 = string + "L";
            String string3 = this.getPropertyValue(string2);
            int n4 = 0;
            String string4 = this.getPropertyValue(string);
            String string5 = this.getPropertyValue("HA");
            Move move2 = null;
            if (string3 != null) {
                try {
                    n4 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    SGF.this.warn("Time left (" + string2 + ") property invalid, using 0 instead.");
                }
            }
            if ("".equals(string4) || n <= 26 && "tt".equals(string4)) {
                move2 = new PassMove(move, n4, n2, n3, true);
            } else if (string4 != null) {
                object2 = this.SGFtoPosition(string4, n);
                move2 = new StoneMove(move, n4, n2, n3, true, (Position)object2);
            } else if (string5 != null) {
                object2 = this.getPropertyValues("AB");
                if (object2 != null) {
                    object = new PositionVector(9);
                    for (int i = 0; i < ((Vector)object2).size(); ++i) {
                        String string6 = (String)((Vector)object2).elementAt(i);
                        ((PositionVector)object).addElement(this.SGFtoPosition(string6, game.size()));
                    }
                    move2 = new HandicapMove(move, n4, n2, true, (PositionVector)object);
                } else {
                    try {
                        int n5 = Integer.parseInt(string5);
                        if (SGF.this.pedantic && n5 < 2) {
                            SGF.this.warn("Invalid HAndicap property.  Value must be >= 2.");
                        }
                        if (n5 < 0 || n5 > 9) {
                            SGF.this.error("Invalid HAndicap property.  Value must be between 1 and 9 inclusive.");
                        }
                        if (n5 != 0) {
                            move2 = new HandicapMove(move, n4, n2, true, n5, n);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        SGF.this.error("Invalid HAndicap property.  Value must be an integer.");
                    }
                }
            } else if (game.getCurrentMove() instanceof RootMove) {
                move2 = game.getCurrentMove();
            }
            if (move2 != null) {
                for (int i = 0; i < this.nodeProperties.size(); ++i) {
                    Vector vector;
                    object = (String)this.nodeProperties.elementAt(i);
                    if (object == null || "HA".equals(object) || ((String)object).equals(string) || ((String)object).equals(string2) || "AB".equals(object) || (vector = this.getPropertyValues((String)object)) == null) continue;
                    if ("C".equals(object)) {
                        for (int j = 0; j < vector.size(); ++j) {
                            move2.addKibitz((String)vector.elementAt(j));
                        }
                        continue;
                    }
                    move2.addSGFproperty((String)object, vector);
                }
            }
            return move2;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Node[");
            for (int i = 0; i < this.nodeProperties.size(); ++i) {
                stringBuffer.append(this.nodeProperties.elementAt(i));
                stringBuffer.append("=");
                stringBuffer.append(this.nodeValues.elementAt(i));
                if (i >= this.nodeProperties.size() - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
    }
}

