/*
 * Decompiled with CFR 0.152.
 */
package ergo.logic;

import ergo.logic.Move;
import ergo.ui.UpdatableBoard;
import ergo.util.Position;
import ergo.util.PositionVector;

public class StoneStasher {
    private static Position privp = new Position(0, 0);
    private UpdatableBoard updatable = null;
    private int[][] stoneArray;
    private int[][] tickArray;
    private boolean quietness;
    private boolean currentMoveChanged;
    private Move currentMove;
    private PositionVector dirties = new PositionVector();
    private static int emitCount = 0;

    StoneStasher(int n) {
        if (n > 0) {
            this.stoneArray = new int[n][n];
            this.tickArray = new int[n][n];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    this.stoneArray[i][j] = 3;
                }
            }
        }
    }

    public void associateUpdatable(UpdatableBoard updatableBoard) {
        this.updatable = updatableBoard;
    }

    public void setQuiet(boolean bl) {
        this.quietness = bl;
    }

    public boolean getQuiet() {
        return this.quietness;
    }

    public void setCurrentMove(Move move) {
        this.currentMoveChanged = true;
        this.currentMove = move;
    }

    public Move getCurrentMove() {
        return this.currentMove;
    }

    public boolean emit() {
        ++emitCount;
        if (!this.quietness && this.updatable != null && this.updatable.isReady()) {
            for (int i = this.dirties.size() - 1; i >= 0; --i) {
                Position position = this.dirties.elementAt(i);
                if (this.tickArray[position.row][position.column] < emitCount) {
                    this.updatable.reflect(position.row, position.column, this.stoneArray[position.row][position.column]);
                    this.tickArray[position.row][position.column] = emitCount;
                }
                this.dirties.removeElementAt(i);
            }
            if (this.currentMoveChanged) {
                this.updatable.noteMove(this.currentMove);
            }
            this.updatable.updateInternal();
            if (this.currentMoveChanged) {
                this.currentMoveChanged = false;
                return true;
            }
        }
        return false;
    }

    public int readStone(int n, int n2) {
        int n3 = this.stoneArray[n][n2];
        switch (n3) {
            case 0: 
            case 1: {
                return n3;
            }
        }
        return 3;
    }

    public int readAnyStone(int n, int n2) {
        return this.stoneArray[n][n2];
    }

    public void writeStone(int n, int n2, int n3) {
        this.writeStone(n, n2, n3, true);
    }

    public void writeStone(int n, int n2, int n3, boolean bl) {
        int n4 = this.stoneArray[n][n2];
        if (n4 != n3) {
            this.stoneArray[n][n2] = n3;
            if (bl) {
                this.dirties.addElement(new Position(n, n2));
            }
        }
    }

    public void setKoPosition(Position position) {
        if (this.updatable != null) {
            this.updatable.setKoPosition(position);
        }
    }
}

