/*
 * Decompiled with CFR 0.152.
 */
package ergo.server;

import ergo.util.Debug;
import ergo.util.ParseException;

public class Rank {
    public static final int KYU = 0;
    public static final int ADAN = 1;
    public static final int PDAN = 2;
    public static final int NR = -1;
    public static final int QQ = -2;
    private int numeric;
    private int type;
    private boolean star;

    public int compareTo(Rank rank) {
        if (this.numeric < rank.numeric) {
            return 1;
        }
        if (this.numeric == rank.numeric) {
            return 0;
        }
        return -1;
    }

    public Rank(String string) throws ParseException {
        if (string.equals("??")) {
            this.type = -2;
            this.numeric = 0;
        } else if (string.equals("NR")) {
            this.type = -1;
            this.numeric = 1;
        } else {
            int n;
            char c;
            try {
                String string2;
                c = string.charAt(string.length() - 1);
                if (c == '*') {
                    this.star = true;
                    c = string.charAt(string.length() - 2);
                    string2 = string.substring(0, string.length() - 2);
                } else {
                    c = string.charAt(string.length() - 1);
                    string2 = string.substring(0, string.length() - 1);
                }
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                Debug.backtrace(exception);
                throw new ParseException("Illegal rank format - last character not found " + string);
            }
            switch (c) {
                case 'k': {
                    this.type = 0;
                    this.numeric = 32 - n;
                    break;
                }
                case 'd': {
                    this.type = 1;
                    this.numeric = 31 + n;
                    break;
                }
                case 'p': {
                    this.type = 2;
                    this.numeric = 40 + n;
                    break;
                }
                default: {
                    throw new ParseException("Illegal rank format - illegal final character " + string);
                }
            }
        }
    }

    private String sstar() {
        return this.star ? "*" : "";
    }

    public String render() {
        switch (this.type) {
            case -2: {
                return "??";
            }
            case -1: {
                return "NR";
            }
            case 0: {
                return Integer.toString(32 - this.numeric) + "k" + this.sstar();
            }
            case 1: {
                return Integer.toString(this.numeric - 31) + "d" + this.sstar();
            }
            case 2: {
                return Integer.toString(this.numeric - 40) + "p" + this.sstar();
            }
        }
        return null;
    }
}

