/*
 * Decompiled with CFR 0.152.
 */
package ergo.server;

import ergo.server.Controller;
import ergo.server.GoServer;
import ergo.server.SimpleServerConnection;
import ergo.ui.GoClient;
import ergo.ui.dlg.ErgoDialog;
import ergo.ui.dlg.YNCDialog;
import ergo.util.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import org.unitarou.io.SnifferInputStream;
import org.unitarou.io.SnifferOutputStream;
import org.unitarou.ml.Message;

public class ServerConnection
implements Runnable,
ActionListener,
SimpleServerConnection {
    private static final Message LB_CONNECT = new Message(class$ergo$server$ServerConnection == null ? (class$ergo$server$ServerConnection = ServerConnection.class$("ergo.server.ServerConnection")) : class$ergo$server$ServerConnection, "lbConnect");
    private static final Message LB_CONNECTING_TO = new Message(class$ergo$server$ServerConnection == null ? (class$ergo$server$ServerConnection = ServerConnection.class$("ergo.server.ServerConnection")) : class$ergo$server$ServerConnection, "lbConnectingTo");
    private static final Message LB_UNKNOWN_HOST = new Message(class$ergo$server$ServerConnection == null ? (class$ergo$server$ServerConnection = ServerConnection.class$("ergo.server.ServerConnection")) : class$ergo$server$ServerConnection, "lbUnknownHost");
    private static final Message MSG_COULDNOT_CONNECT = new Message(class$ergo$server$ServerConnection == null ? (class$ergo$server$ServerConnection = ServerConnection.class$("ergo.server.ServerConnection")) : class$ergo$server$ServerConnection, "msgCouldnotConnect");
    private static final Message MSG_CONNECTION_CLOSED = new Message(class$ergo$server$ServerConnection == null ? (class$ergo$server$ServerConnection = ServerConnection.class$("ergo.server.ServerConnection")) : class$ergo$server$ServerConnection, "msgConnectinoClosed");
    private static final Message LB_NOT_CONNECTED = new Message(class$ergo$server$ServerConnection == null ? (class$ergo$server$ServerConnection = ServerConnection.class$("ergo.server.ServerConnection")) : class$ergo$server$ServerConnection, "lbNotConnect");
    public GoClient client;
    public GoServer server;
    public Controller control;
    private Socket sock;
    private BufferedReader netin;
    private PrintWriter netout;
    private boolean scanForLogin = true;
    private StringBuffer inputBuffer = new StringBuffer(150);
    private String previousLine;
    private Thread controllerThread = null;
    private Thread openConnThread = null;
    private YNCDialog openConnDialog = null;
    static /* synthetic */ Class class$ergo$server$ServerConnection;

    private ServerConnection() {
    }

    public ServerConnection(GoClient goClient) {
        this.client = goClient;
    }

    public String longName() {
        return this.server.name;
    }

    public String shortName() {
        return this.server.shortName();
    }

    public String previousLine() {
        return this.previousLine;
    }

    public boolean open(GoServer goServer) {
        if (this.isConnected()) {
            System.err.println("Attempt to connect to " + goServer.toString());
            System.err.println("  while already connected to " + this.server.toString());
            return false;
        }
        this.server = goServer;
        this.openConnDialog = this.client.openYNCDialog(LB_CONNECT.get(), false, LB_CONNECTING_TO.get(goServer), null, null, ErgoDialog.LB_CANCEL.get(), this);
        this.openConnThread = new Thread(this);
        this.openConnThread.start();
        return true;
    }

    public void run() {
        this.openInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openInternal() {
        try {
            this.sock = new Socket(this.server.name, this.server.port);
            if (Debug.getDebug()) {
                this.netout = new PrintWriter(new SnifferOutputStream(this.sock.getOutputStream(), new FileOutputStream("hErgo.out")), true);
                this.netin = new BufferedReader(new InputStreamReader(new SnifferInputStream(this.sock.getInputStream(), new FileOutputStream("hErgo.in"))));
            } else {
                this.netout = new PrintWriter(this.sock.getOutputStream(), true);
                this.netin = new BufferedReader(new InputStreamReader(this.sock.getInputStream()));
            }
            if (this.client != null) {
                this.client.updateTitle();
            }
            this.scanForLogin = true;
            this.control = new Controller(this, this.client);
            this.controllerThread = new Thread((Runnable)this.control, "Ergo Controller");
            this.controllerThread.start();
            this.client.noteConnected();
        }
        catch (UnknownHostException unknownHostException) {
            this.client.displayString(LB_UNKNOWN_HOST.get(this.server.name));
        }
        catch (IOException iOException) {
            this.client.displayString(MSG_COULDNOT_CONNECT.get(new Object[]{this.server.name, String.valueOf(this.server.port), iOException.getLocalizedMessage()}));
        }
        finally {
            this.openConnThread = null;
            if (this.openConnDialog != null) {
                this.openConnDialog.close();
                this.openConnDialog = null;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.openConnThread != null) {
            this.openConnThread.stop();
        }
        this.openConnDialog = null;
    }

    public synchronized void close() {
        if (this.netin != null) {
            try {
                if (this.controllerThread != null) {
                    this.control.quit();
                    this.controllerThread = null;
                }
                this.netin.close();
                this.netin = null;
                if (this.client != null) {
                    this.client.noteDisconnected();
                    this.client.displayString(MSG_CONNECTION_CLOSED.get());
                }
            }
            catch (IOException iOException) {
                System.err.println("Unable to close input connection to server.");
                System.err.println("Exiting anyway.");
            }
        }
        if (this.netout != null) {
            this.netout.close();
            this.netout = null;
        }
    }

    public boolean isConnected() {
        return this.netin != null;
    }

    public boolean send(String string) {
        return this.send(string, true);
    }

    public boolean send(String string, boolean bl) {
        if (!this.isConnected()) {
            return false;
        }
        if (bl) {
            this.client.displayCommand(string);
        }
        this.netout.println(string);
        this.netout.flush();
        return true;
    }

    private boolean bufferEquals(String string, int n) {
        for (int i = n; i < this.inputBuffer.length(); ++i) {
            if (Character.toLowerCase(this.inputBuffer.charAt(i)) == Character.toLowerCase(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public synchronized String readLine() throws IOException {
        this.inputBuffer.setLength(0);
        int n = 97;
        while (true) {
            int n2;
            if ((n2 = this.netin.read()) == -1) {
                this.close();
                return this.inputBuffer.toString();
            }
            char c = (char)n2;
            if (c == '\r') {
                if (n == 13) continue;
                this.netin.mark(2);
            } else {
                if (c == '\n') break;
                this.inputBuffer.append(c);
            }
            if (n == 13) {
                this.netin.reset();
                this.inputBuffer.setLength(this.inputBuffer.length() - 1);
                break;
            }
            if (this.scanForLogin && c == ':' && (this.bufferEquals("Login:", 1) || this.bufferEquals("Password:", 1))) break;
            n = c;
        }
        this.previousLine = this.inputBuffer.toString();
        return this.previousLine;
    }

    public String toString() {
        return this.isConnected() ? this.server.shortName() : LB_NOT_CONNECTED.get();
    }

    public boolean scanningForLogin() {
        return this.scanForLogin;
    }

    public void stopScanningForLogin() {
        this.scanForLogin = false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

