/*
 * Decompiled with CFR 0.152.
 */
package ergo.ui;

import ergo.ui.BoardCanvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class BoardLayout
implements LayoutManager {
    private Component board;
    private Component north;
    private Component south;
    private Component east;
    private Component west;
    private Component status;
    private Component controls;
    private int boardSize;

    public BoardLayout(int n) {
        this.boardSize = n;
    }

    public void addLayoutComponent(String string, Component component) {
        if (string.equalsIgnoreCase("North")) {
            this.north = component;
        } else if (string.equalsIgnoreCase("South")) {
            this.south = component;
        } else if (string.equalsIgnoreCase("East")) {
            this.east = component;
        } else if (string.equalsIgnoreCase("West")) {
            this.west = component;
        } else if (string.equalsIgnoreCase("Board") || string.equalsIgnoreCase("Center")) {
            this.board = component;
        } else if (string.equalsIgnoreCase("Status") || string.equalsIgnoreCase("Bottom")) {
            this.status = component;
        } else if (string.equalsIgnoreCase("Controls")) {
            this.controls = component;
        }
    }

    public void removeLayoutComponent(Component component) {
        if (component == this.north) {
            this.north = null;
        } else if (component == this.south) {
            this.south = null;
        } else if (component == this.east) {
            this.east = null;
        } else if (component == this.west) {
            this.west = null;
        } else if (component == this.board) {
            this.board = null;
        } else if (component == this.status) {
            this.status = null;
        } else if (component == this.controls) {
            this.controls = null;
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        Cloneable cloneable;
        int n = 0;
        int n2 = 0;
        if (this.east != null && this.east.isVisible()) {
            cloneable = this.east.getPreferredSize();
            n += cloneable.width;
            n2 = Math.max(cloneable.height, n2);
        }
        if (this.west != null && this.west.isVisible()) {
            cloneable = this.west.getPreferredSize();
            n += cloneable.width;
            n2 = Math.max(cloneable.height, n2);
        }
        if (this.board != null && this.board.isVisible()) {
            cloneable = this.board.getPreferredSize();
            n += cloneable.width;
            n2 = Math.max(cloneable.height, n2);
        }
        if (this.north != null && this.north.isVisible()) {
            cloneable = this.north.getPreferredSize();
            n = Math.max(cloneable.width, n);
            n2 += cloneable.height;
        }
        if (this.south != null && this.south.isVisible()) {
            cloneable = this.south.getPreferredSize();
            n = Math.max(cloneable.width, n);
            n2 += cloneable.height;
        }
        if (this.status != null && this.status.isVisible()) {
            cloneable = this.status.getPreferredSize();
            n = Math.max(cloneable.width, n);
            n2 += cloneable.height;
        }
        if (this.controls != null && this.controls.isVisible()) {
            cloneable = this.controls.getPreferredSize();
            n = Math.max(cloneable.width, n);
            n2 += cloneable.height;
        }
        cloneable = container.getInsets();
        return new Dimension(n += ((Insets)cloneable).left + ((Insets)cloneable).right, n2 += ((Insets)cloneable).top + ((Insets)cloneable).bottom);
    }

    public Dimension minimumLayoutSize(Container container) {
        Cloneable cloneable;
        int n = 0;
        int n2 = 0;
        if (this.east != null && this.east.isVisible()) {
            cloneable = this.east.getMinimumSize();
            n += cloneable.width;
            n2 = Math.max(cloneable.height, n2);
        }
        if (this.west != null && this.west.isVisible()) {
            cloneable = this.west.getMinimumSize();
            n += cloneable.width;
            n2 = Math.max(cloneable.height, n2);
        }
        if (this.board != null && this.board.isVisible()) {
            cloneable = this.board.getMinimumSize();
            n += cloneable.width;
            n2 = Math.max(cloneable.height, n2);
        }
        if (this.north != null && this.north.isVisible()) {
            cloneable = this.north.getMinimumSize();
            n = Math.max(cloneable.width, n);
            n2 += cloneable.height;
        }
        if (this.south != null && this.south.isVisible()) {
            cloneable = this.south.getMinimumSize();
            n = Math.max(cloneable.width, n);
            n2 += cloneable.height;
        }
        if (this.status != null && this.status.isVisible()) {
            cloneable = this.status.getMinimumSize();
            n = Math.max(cloneable.width, n);
            n2 += cloneable.height;
        }
        if (this.controls != null && this.controls.isVisible()) {
            cloneable = this.controls.getMinimumSize();
            n = Math.max(cloneable.width, n);
            n2 += cloneable.height;
        }
        cloneable = container.getInsets();
        return new Dimension(n += ((Insets)cloneable).left + ((Insets)cloneable).right, n2 += ((Insets)cloneable).top + ((Insets)cloneable).bottom);
    }

    public void layoutContainer(Container container) {
        Dimension dimension = new Dimension(0, 0);
        Dimension dimension2 = this.east == null ? dimension : this.east.getPreferredSize();
        Dimension dimension3 = this.west == null ? dimension : this.west.getPreferredSize();
        Dimension dimension4 = this.north == null ? dimension : this.north.getPreferredSize();
        Dimension dimension5 = this.south == null ? dimension : this.south.getPreferredSize();
        Dimension dimension6 = this.status == null ? dimension : this.status.getPreferredSize();
        Dimension dimension7 = this.controls == null ? dimension : this.controls.getPreferredSize();
        Insets insets = container.getInsets();
        int n = container.getSize().width;
        int n2 = container.getSize().height;
        int n3 = n - insets.right - insets.left;
        int n4 = insets.top + dimension4.height;
        int n5 = n2 - insets.bottom - dimension6.height - dimension5.height - dimension7.height;
        int n6 = insets.left + dimension3.width;
        int n7 = n - insets.right - dimension2.width;
        int n8 = 0;
        int n9 = 0;
        if (this.board != null && this.board.isVisible()) {
            dimension = this.board.getMinimumSize();
            n9 = Math.max(Math.min(n7 - n6, n5 - n4), Math.min(dimension.width, dimension.height));
            BoardCanvas boardCanvas = (BoardCanvas)this.board;
            n8 = (n9 - 2 * boardCanvas.getBevelWidth()) / this.boardSize * this.boardSize + 2 * boardCanvas.getBevelWidth();
            int n10 = n7 - n6;
            int n11 = n5 - n4;
            n7 = (n6 += (n10 - n8) / 2) + n8;
            n5 = n4 + n8;
            this.board.setBounds(n6, n4, n8, n8);
        }
        int n12 = n5;
        if (this.south != null && this.south.isVisible()) {
            this.south.setBounds(n6, n12, n8, dimension5.height);
            n12 += dimension5.height;
        }
        if (this.controls != null && this.controls.isVisible()) {
            this.controls.setBounds(insets.left, n12, n3, dimension7.height);
            n12 += dimension7.height;
        }
        if (this.status != null && this.status.isVisible()) {
            dimension6.height += n9 - n8;
            this.status.setBounds(insets.left, n12, n3, dimension6.height);
            n12 += dimension6.height;
        }
        if (this.west != null && this.west.isVisible()) {
            this.west.setBounds(insets.left, n4, n6 - insets.left, n8);
        }
        if (this.east != null && this.east.isVisible()) {
            this.east.setBounds(n7, n4, n - insets.right - n7, n8);
        }
        if (this.north != null && this.north.isVisible()) {
            this.north.setBounds(n6, insets.top, n8, n4 - insets.top);
        }
    }
}

