/*
 * Decompiled with CFR 0.152.
 */
package ergo.ui;

import ergo.util.Debug;
import ergo.util.ParseException;
import ergo.util.ParsedMessage;
import java.awt.Color;
import java.awt.SystemColor;
import java.lang.reflect.Field;

public class ColorSpec {
    public static final int RGB = 0;
    public static final int SYSCOL = 1;
    public static final int PLAIN = 2;
    private int type;
    private Color stored;
    private String constructs;
    private static SystemColor s = SystemColor.desktop;

    ColorSpec(String string) throws ParseException {
        this.constructs = string;
        this.type = 2;
        this.stored = Color.white;
        if (this.constructs.startsWith("System.", 0)) {
            String string2 = this.constructs.substring(7).trim();
            SystemColor systemColor = null;
            try {
                Class<?> clazz = Class.forName("java.awt.SystemColor");
                Field field = clazz.getField(string2);
                systemColor = (SystemColor)field.get(null);
            }
            catch (Exception exception) {
                Debug.backtrace(exception);
                return;
            }
            this.stored = systemColor;
            this.type = 1;
        } else {
            Color color;
            ParsedMessage parsedMessage = new ParsedMessage(this.constructs, "%i %i %i");
            this.stored = color = new Color(parsedMessage.intAt(0), parsedMessage.intAt(1), parsedMessage.intAt(2));
            this.type = 0;
        }
    }

    Color getColor() {
        return this.stored;
    }

    String render() {
        return this.constructs;
    }
}

