/*
 * Decompiled with CFR 0.152.
 */
package ergo.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Vector;

public class ColumnLayout
implements LayoutManager2 {
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    private Vector specs = new Vector(5, 10);
    private int defaultAlignment = 1;
    private int defaultVSpace = 0;
    private int margin = 1;
    private boolean equalizeWidths = false;
    private int maxWidth = 0;

    public ColumnLayout(int n, int n2, int n3, boolean bl) {
        if (n == 1 || n == 2 || n == 3) {
            this.defaultAlignment = n;
        }
        this.defaultVSpace = n2;
        this.margin = n3;
        this.equalizeWidths = bl;
    }

    public ColumnLayout() {
    }

    public Constraint makeConstraint(int n, int n2, boolean bl) {
        return new Constraint(n, n2, bl);
    }

    private Component getComponent(Vector vector) {
        return (Component)vector.elementAt(0);
    }

    private Constraint getConstraint(Vector vector) {
        return (Constraint)vector.elementAt(1);
    }

    public void addLayoutComponent(Component component, Object object) {
        this.removeLayoutComponent(component);
        Constraint constraint = !(object instanceof Constraint) ? new Constraint() : (Constraint)object;
        Vector<Object> vector = new Vector<Object>(2);
        vector.addElement(component);
        vector.addElement(constraint);
        this.specs.addElement(vector);
    }

    public void removeLayoutComponent(Component component) {
        for (int i = 0; i < this.specs.size(); ++i) {
            Vector vector = (Vector)this.specs.elementAt(i);
            if (vector.elementAt(0) != component) continue;
            this.specs.removeElementAt(i);
            return;
        }
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        Vector vector;
        int n;
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        int n2 = insets.left + this.margin;
        int n3 = insets.top + this.margin;
        int n4 = dimension.height - insets.bottom - this.margin;
        if (this.equalizeWidths) {
            for (n = 0; n < this.specs.size(); ++n) {
                vector = (Vector)this.specs.elementAt(n);
                this.maxWidth = Math.max(this.maxWidth, this.getComponent((Vector)vector).getPreferredSize().width);
            }
        }
        for (n = 0; n < this.specs.size(); ++n) {
            vector = (Vector)this.specs.elementAt(n);
            Component component = this.getComponent(vector);
            Constraint constraint = this.getConstraint(vector);
            if (!component.isVisible()) continue;
            int n5 = n2;
            int n6 = constraint.alignment;
            int n7 = constraint.spacing;
            Dimension dimension2 = component.getPreferredSize();
            int n8 = dimension2.width;
            if (!constraint.fixedWidth) {
                n8 = Math.max(this.maxWidth, n8);
            }
            if (n6 == 2) {
                n5 += (dimension.width - n2 - insets.right - n8 - this.margin) / 2;
            } else if (n6 == 3) {
                n5 = dimension.width - insets.right - this.margin - n8;
            }
            if (n7 < 0) {
                component.setBounds(n5, n4 -= dimension2.height + n7, n8, dimension2.height);
                continue;
            }
            component.setBounds(n5, n3, n8, dimension2.height);
            n3 += dimension2.height + n7;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(container, "min");
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getLayoutSize(container, "pref");
    }

    public Dimension maximumLayoutSize(Container container) {
        return this.getLayoutSize(container, "max");
    }

    private Dimension getLayoutSize(Container container, String string) {
        Dimension dimension = new Dimension(0, 0);
        Insets insets = container.getInsets();
        for (int i = 0; i < this.specs.size(); ++i) {
            Vector vector = (Vector)this.specs.elementAt(i);
            Component component = this.getComponent(vector);
            Constraint constraint = this.getConstraint(vector);
            if (!component.isVisible()) continue;
            Dimension dimension2 = "pref".equals(string) ? component.getPreferredSize() : ("min".equals(string) ? component.getMinimumSize() : component.getMaximumSize());
            dimension.width = Math.max(this.maxWidth, Math.max(dimension.width, dimension2.width));
            dimension.height += dimension2.height + constraint.spacing;
        }
        dimension.width += insets.left + insets.right + this.margin * 2;
        dimension.height += insets.top + insets.bottom + this.margin * 2;
        return dimension;
    }

    class Constraint {
        int alignment;
        int spacing;
        boolean fixedWidth;

        Constraint() {
            this.alignment = ColumnLayout.this.defaultAlignment;
            this.spacing = ColumnLayout.this.defaultVSpace;
            this.fixedWidth = false;
        }

        Constraint(int n, int n2, boolean bl) {
            this.alignment = ColumnLayout.this.defaultAlignment;
            this.spacing = ColumnLayout.this.defaultVSpace;
            this.fixedWidth = false;
            this.alignment = n;
            this.spacing = n2;
            this.fixedWidth = bl;
        }
    }
}

