/*
 * Decompiled with CFR 0.152.
 */
package ergo.ui;

import ergo.Ergo;
import ergo.logic.Game;
import ergo.logic.HandicapMove;
import ergo.logic.Move;
import ergo.logic.PassMove;
import ergo.logic.RemovalMove;
import ergo.logic.RootMove;
import ergo.logic.StoneMove;
import ergo.server.ServerConnection;
import ergo.ui.AbstractMenuListener;
import ergo.ui.BoardCanvas;
import ergo.ui.BoardLayout;
import ergo.ui.CBMIGroup;
import ergo.ui.ColorSpec;
import ergo.ui.ColumnLayout;
import ergo.ui.CoordinateCanvas;
import ergo.ui.GWPanel;
import ergo.ui.ImageButton;
import ergo.ui.MenuCommand;
import ergo.ui.Optionizable;
import ergo.ui.OutputFocus;
import ergo.ui.PopupContributor;
import ergo.ui.PopupController;
import ergo.ui.RowLayout;
import ergo.ui.StatusPanel;
import ergo.ui.TerminalWindow;
import ergo.ui.TextArea;
import ergo.ui.TextColorManager;
import ergo.ui.VariationMenuItem;
import ergo.ui.WindowsMenuCommand;
import ergo.ui.WindowsMenuCommandSeparator;
import ergo.ui.dlg.YNCDialog;
import ergo.ui.urCheckboxListener;
import ergo.ui.urMenuBar;
import ergo.util.CommandHistory;
import ergo.util.Debug;
import ergo.util.ErgoException;
import ergo.util.Position;
import ergo.util.PositionVector;
import ergo.util.SimpleGroup;
import ergo.util.SimpleGroupVector;
import ergo.util.Util;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;
import nom.rb.common.MosaicConstraints;
import nom.rb.common.MosaicLayout;
import nom.rb.common.MosaicPanel;
import org.unitarou.ml.Message;

public class GameWindow
extends Frame
implements Runnable,
WindowsMenuCommand,
Optionizable,
OutputFocus,
PopupContributor {
    private static final String gwinTermOutString = "Game Window Show Terminal Output";
    private static final String savePromptString = "Game Window prompt for save";
    private static final String NcoordString = "North Board Coordinates";
    private static final String WcoordString = "West Board Coodinates";
    private static final String EcoordString = "East Board Coordinates";
    private static final String ScoordString = "South Board Coordinates";
    private static final String statusString = "Game Window Show Game Status";
    private static final String kibitzString = "Game Window Show Kibitz Area";
    private static final String variationString = "Game Window Show Variation Letters";
    private static final String bsizeString = "Game Window Size";
    private static final Message LB_FILE = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbFile");
    private static final Message LB_SAVE = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbSave");
    private static final Message LB_SAVE_AS = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbSaveAs");
    private static final Message LB_SAVE_TERMINAL_OUTPUT = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbSaveTerminalOutput");
    private static final Message LB_OPEN_GAME = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbOpenGame");
    private static final Message LB_CLOSE = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbClose");
    private static final Message LB_VIEW = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbView");
    private static final Message LB_REFRESH = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbRefresh");
    private static final Message LB_LOCAL = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbLocal");
    private static final Message LB_SERVER = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbServer");
    private static final Message LB_SHOW_TERMINAL_OUTPUT = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbShowTerminalOutput");
    private static final Message LB_SHOW_COORDINATES = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbShowCoordinaltes");
    private static final Message LB_SHOW_VARIATIONS = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbShowVariations");
    private static final Message LB_SHOW_STATUS = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbShowStatus");
    private static final Message LB_NONE = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbNone");
    private static final Message LB_RIGHT = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbRight");
    private static final Message LB_BOTTOM = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbBottom");
    private static final Message LB_SHOW_KIBITZES = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbShowKibitzes");
    private static final Message LB_ALL = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbAll");
    private static final Message LB_CURRENT_MOVE = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbCurrentMove");
    private static final Message LB_STONES_STYLE = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbStonesStyle");
    private static final Message LB_BASIC = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbBasic");
    private static final Message LB_ANTI_ALIASED = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbAntiAliased");
    private static final Message LB_3D = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lb3d");
    private static final Message LB_BOARD_STYLE = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbBoardStyle");
    private static final Message LB_WOODEN = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbWooden");
    private static final Message LB_OPTIONS = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbOptions");
    private static final Message LB_BROWSE = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbBrowse");
    private static final Message LB_SOUND = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbSound");
    private static final Message LB_WINDOW = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbWindow");
    private static final Message LB_COPY_AS_SGF = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbCopyAsSgf");
    private static final Message LB_GAME = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbGame");
    private static final Message LB_PLACE_HANDICAP = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbPlaceHandicap");
    private static final Message LB_PASS = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbPass");
    private static final Message LB_UNDO = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbUndo");
    private static final Message LB_DONE = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbDone");
    private static final Message LB_ADJOURN = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbAdjourn");
    private static final Message LB_RESIGN = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbResign");
    private static final Message LB_CALCULATE_SCORE = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbCalculateScore");
    private static final Message LB_VARITIONS = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbVariations");
    private static final Message LB_DEBUG = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbDebug");
    private static final Message LB_DUMP_BOARD = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbDumpBoard");
    private static final Message LB_DUMP_GROUPS = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbDumpGroups");
    private static final Message FMT_HANDICAP = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "fmtHandicap");
    private static final Message LB_DELETE_VARIATION = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbDeleteVariation");
    private static final Message LB_INSERT_VARIATION_AS_KIBITZ = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbInsertVariationAsKibitz");
    private static final Message LB_BROUSE_TO_POSITION = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbBrouseToPosition");
    private static final Message LB_STATS = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbStats");
    private static final Message LB_SHOW_OBSERVERS = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbShowObservers");
    private static final Message LB_LOAD = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbLoad");
    private static final Message LB_REMOVE_GROUPS = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbRemoveGroups");
    private static final Message LB_PASS_MOVE = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbPassMove");
    private static final Message LB_ASK_RESIGN = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbAskResign");
    private static final Message MSG_ASK_RESIGN = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "msgAskResign");
    private static final Message FMT_FILENAME = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "fmtFilename");
    private static final Message LB_SAVE_ERROR = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbSaveError");
    private static final Message LB_ASK_SAVE_GAME = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "lbAskSaveGame");
    private static final Message MSG_ASK_SAVE_GAME = new Message(class$ergo$ui$GameWindow == null ? (class$ergo$ui$GameWindow = GameWindow.class$("ergo.ui.GameWindow")) : class$ergo$ui$GameWindow, "msgAskSaveGame");
    private PopupController popupControl;
    private PopupHandler popupHandler;
    private ServerConnection conn = null;
    int gameNumber;
    int gameStatus;
    private boolean isParticipating;
    private int ourColor;
    public Game game;
    private TerminalWindow window;
    private boolean browsing = false;
    private boolean savedBrowsing;
    private String filename = null;
    private boolean needsSaving = false;
    private CommandHistory commandHistory = new CommandHistory();
    private boolean showKibitzes = true;
    private boolean showKibitzesForThisMoveOnly = false;
    private boolean tallConfiguration = true;
    private Panel topPanel = new GWPanel();
    private Panel bottomPanel = new GWPanel();
    private CoordinateCanvas northCanvas;
    private CoordinateCanvas southCanvas;
    private CoordinateCanvas eastCanvas;
    private CoordinateCanvas westCanvas;
    private StatusPanel statusPanel;
    private BoardCanvas boardCanvas;
    private Panel boardPanel = new GWPanel();
    private TextArea kibitzArea = new TextArea(6, 40, null, true);
    private TextField inputField = new TextField();
    private mouseListener mouseListen = new mouseListener();
    private ImageButton stepBackButton;
    private ImageButton stepForwardButton;
    private ImageButton toBeginningButton;
    private ImageButton toEndButton;
    private ImageButton fwdKibButton;
    private ImageButton backKibButton;
    private ImageButton fwdBranchButton;
    private ImageButton backBranchButton;
    private urMenuBar menuBar = new urMenuBar(this);
    private menuListener mListen = new menuListener();
    private checkboxListener cListen = new checkboxListener();
    private exclusiveCheckboxListener xListen = new exclusiveCheckboxListener();
    private final Menu fileMenu = this.menuBar.generate(LB_FILE.get());
    private final MenuItem saveItem = this.mListen.generate(this.fileMenu, LB_SAVE.get(), new MenuShortcut(115));
    private final MenuItem saveAsItem = this.mListen.generate(this.fileMenu, LB_SAVE_AS.get(), new MenuShortcut(115, true));
    private final MenuItem saveOutputItem = this.mListen.generate(this.fileMenu, LB_SAVE_TERMINAL_OUTPUT.get());
    private final MenuItem loadItem = this.mListen.generate(this.fileMenu, LB_OPEN_GAME.get(), new MenuShortcut(111, true));
    private MenuItem closeItem = this.mListen.generateWithSep(this.fileMenu, LB_CLOSE.get(), true, new MenuShortcut(119));
    private final Menu viewMenu = this.menuBar.generate(LB_VIEW.get());
    private final Menu refreshMenu = this.mListen.generateMenuWithSep(this.viewMenu, LB_REFRESH.get());
    private final MenuItem refreshLocalItem = this.mListen.generate(this.refreshMenu, LB_LOCAL.get(), new MenuShortcut(114));
    private final MenuItem refreshHostItem = this.mListen.generate(this.refreshMenu, LB_SERVER.get(), new MenuShortcut(114, true));
    private final CheckboxMenuItem focusHereItem = this.cListen.generate(this.viewMenu, LB_SHOW_TERMINAL_OUTPUT.get());
    private final CheckboxMenuItem showCoordinatesItem = this.cListen.generate(this.viewMenu, LB_SHOW_COORDINATES.get());
    private boolean showCoordinates = true;
    private final CheckboxMenuItem showVariationsItem = this.cListen.generate(this.viewMenu, LB_SHOW_VARIATIONS.get());
    private final Menu showStatusMenu = this.mListen.generateMenu(this.viewMenu, LB_SHOW_STATUS.get());
    private final CBMIGroup statusGroup = new CBMIGroup(this.xListen, this.showStatusMenu);
    private final CheckboxMenuItem showStatusNoneItem = this.statusGroup.generate(LB_NONE.get());
    private final CheckboxMenuItem showStatusRightItem = this.statusGroup.generate(LB_RIGHT.get());
    private final CheckboxMenuItem showStatusBottomItem = this.statusGroup.generate(LB_BOTTOM.get());
    private final Menu kibitzMenu = this.mListen.generateMenu(this.viewMenu, LB_SHOW_KIBITZES.get());
    private final CBMIGroup kibitzGroup = new CBMIGroup(this.xListen, this.kibitzMenu);
    private final CheckboxMenuItem kibitzAllItem = this.kibitzGroup.generate(LB_ALL.get());
    private final CheckboxMenuItem kibitzCurrentItem = this.kibitzGroup.generate(LB_CURRENT_MOVE.get());
    private final CheckboxMenuItem kibitzNoneItem = this.kibitzGroup.generate(LB_NONE.get());
    private final Menu stonesMenu = this.mListen.generateMenu(this.viewMenu, LB_STONES_STYLE.get());
    private final CBMIGroup stonesGroup = new CBMIGroup(this.xListen, this.stonesMenu);
    private final CheckboxMenuItem[] stonesItems = new CheckboxMenuItem[]{this.stonesGroup.generate(LB_BASIC.get()), this.stonesGroup.generate(LB_ANTI_ALIASED.get()), this.stonesGroup.generate(LB_3D.get())};
    private final Menu boardMenu = this.mListen.generateMenu(this.viewMenu, LB_BOARD_STYLE.get());
    private final CBMIGroup boardGroup = new CBMIGroup(this.xListen, this.boardMenu);
    private final CheckboxMenuItem[] boardItems = new CheckboxMenuItem[]{this.boardGroup.generate(LB_BASIC.get()), this.boardGroup.generate(LB_WOODEN.get())};
    private final Menu optionsMenu = this.menuBar.generate(LB_OPTIONS.get());
    private final CheckboxMenuItem browsingItem = this.cListen.generate(this.optionsMenu, LB_BROWSE.get());
    private final CheckboxMenuItem soundItem = this.cListen.generate(this.optionsMenu, LB_SOUND.get());
    private boolean sound = Ergo.opser.getBooleanOption("Sound");
    private boolean focusHere;
    private final MenuItem copyAsSGFItem = this.mListen.generateWithSep(this.optionsMenu, LB_COPY_AS_SGF.get(), true, new MenuShortcut(99));
    private final Menu windowsMenu = this.menuBar.generate(LB_WINDOW.get());
    private static WindowsMenuCommandSeparator separatorItem = new WindowsMenuCommandSeparator(11, null);
    private final Menu gameMenu = this.menuBar.generate(LB_GAME.get());
    private final Menu handicapMenu = this.mListen.generateMenu(this.gameMenu, LB_PLACE_HANDICAP.get());
    private final MenuItem passItem = this.mListen.generate(this.gameMenu, LB_PASS.get());
    private final MenuItem undoItem = this.mListen.generateWithSep(this.gameMenu, LB_UNDO.get());
    private final MenuItem doneItem = this.mListen.generate(this.gameMenu, LB_DONE.get());
    private final MenuItem adjournItem = this.mListen.generate(this.gameMenu, LB_ADJOURN.get());
    private final MenuItem resignItem = this.mListen.generate(this.gameMenu, LB_RESIGN.get());
    private final CheckboxMenuItem localScoringItem = this.cListen.generateWithSep(this.gameMenu, LB_CALCULATE_SCORE.get(), true);
    private final Menu variationsMenu = this.menuBar.generate(LB_VARITIONS.get());
    private final Menu debugMenu = this.menuBar.generate(LB_DEBUG.get());
    private final MenuItem dumpBoardItem = this.mListen.generate(this.debugMenu, LB_DUMP_BOARD.get());
    private final MenuItem dumpGroupsItem = this.mListen.generate(this.debugMenu, LB_DUMP_GROUPS.get());
    private String sizeString;
    static /* synthetic */ Class class$ergo$ui$GameWindow;

    private ImageButton makeImageButton(String string) {
        Image image = Ergo.loadImage("/mm/" + string);
        ImageButton imageButton = new ImageButton(image);
        imageButton.addMouseListener(this.mouseListen);
        return imageButton;
    }

    public GameWindow(int n, String string, String string2, String string3, String string4, double d, TerminalWindow terminalWindow, ServerConnection serverConnection, int n2, int n3, int n4, boolean bl) {
        this.window = terminalWindow;
        this.conn = serverConnection;
        this.game = new Game(this, n, string, string2, string3, string4, d, n4, bl, this.conn == null ? null : this.conn.server);
        this.gameNumber = n2;
        this.browsing = false;
        this.isParticipating = n3 != -1;
        this.ourColor = n3;
        this.init();
    }

    public GameWindow(int n, String string, String string2, String string3, String string4, double d, TerminalWindow terminalWindow) {
        this(n, string, string2, string3, string4, d, terminalWindow, null, -1, -1, -1, true);
    }

    public GameWindow(Game game, TerminalWindow terminalWindow) {
        this.window = terminalWindow;
        this.game = game;
        this.gameNumber = -1;
        this.browsing = false;
        this.isParticipating = false;
        this.init();
    }

    public void optionEvent(String string, Object object) {
        if (Ergo.opser.isSameKey(string, statusString)) {
            this.statusPanel = this.configureStatus((String)object);
        } else if (Ergo.opser.isSameKey(string, kibitzString)) {
            this.setKibitzVisible((Boolean)object);
        } else if (TextColorManager.isColorString(string)) {
            this.kibitzArea.setColorVec(TextColorManager.getColorVec());
        } else if (Ergo.opser.isSameKey(string, "Text Window Font")) {
            this.kibitzArea.setFont(Ergo.opser.getFontOption("Text Window Font"));
        } else if (Ergo.opser.isSameKey(string, "Game Window Background Color")) {
            this.setBackground(Ergo.opser.getColorOption("Game Window Background Color"));
            this.repaint();
        }
    }

    private void init() {
        this.popupControl = new PopupController(this, LB_OPTIONS.get());
        this.popupHandler = new PopupHandler();
        GameWindow.separatorItem.appliesTo = this.getClass();
        this.setBrowsing(false);
        this.stepBackButton = this.makeImageButton("back.gif");
        this.stepForwardButton = this.makeImageButton("fwd.gif");
        this.toBeginningButton = this.makeImageButton("backstart.gif");
        this.toEndButton = this.makeImageButton("fwdend.gif");
        this.fwdKibButton = this.makeImageButton("fwdkib.gif");
        this.backKibButton = this.makeImageButton("backkib.gif");
        this.fwdBranchButton = this.makeImageButton("fwdbranch.gif");
        this.backBranchButton = this.makeImageButton("backbranch.gif");
        this.addComponentListener(new SizeListener());
        this.sizeString = "Game Window Size " + this.game.size() + "x" + this.game.size();
        try {
            Ergo.opser.expressOwnership(gwinTermOutString, 2, null, Boolean.FALSE);
            Ergo.opser.expressOwnership(savePromptString, 2, null, Boolean.FALSE);
            Ergo.opser.expressOwnership(NcoordString, 2, null, Boolean.TRUE);
            Ergo.opser.expressOwnership(WcoordString, 2, null, Boolean.TRUE);
            Ergo.opser.expressOwnership(EcoordString, 2, null, Boolean.TRUE);
            Ergo.opser.expressOwnership(ScoordString, 2, null, Boolean.TRUE);
            Ergo.opser.expressOwnership(variationString, 2, null, Boolean.TRUE);
            Ergo.opser.expressOwnership(kibitzString, 2, this, Boolean.TRUE);
            Ergo.opser.expressOwnership(statusString, 9, this, null);
            Ergo.opser.expressOwnership(this.sizeString, 6, null, new Dimension(550, 550));
            Ergo.opser.expressOwnership("Text Window Font", 5, this, null);
            Ergo.opser.expressOwnership("Game Window Background Color", 4, this, new ColorSpec("255 255 255"));
            Ergo.opser.expressOwnership("Stone Style", 1, this, new Integer(2));
            Ergo.opser.expressOwnership("Board Style", 1, this, new Integer(1));
            this.setBackground(Ergo.opser.getColorOption("Game Window Background Color"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String string = (String)Ergo.opser.getOption(statusString);
            if (string == null) {
                string = "Right";
            }
            if (string.equalsIgnoreCase("None")) {
                this.statusGroup.init(this.showStatusNoneItem);
            } else if (string.equalsIgnoreCase("Right")) {
                this.statusGroup.init(this.showStatusRightItem);
                this.tallConfiguration = false;
            } else if (string.equalsIgnoreCase("Bottom")) {
                this.statusGroup.init(this.showStatusBottomItem);
                this.tallConfiguration = true;
            }
        }
        catch (ErgoException ergoException) {
            Debug.backtrace(ergoException);
        }
        this.kibitzGroup.init(this.kibitzAllItem);
        this.stonesGroup.init(this.stonesItems[Ergo.opser.getIntegerOption("Stone Style")]);
        this.boardGroup.init(this.boardItems[Ergo.opser.getIntegerOption("Board Style")]);
        TextColorManager.expressAll(this, 2);
        this.kibitzArea.setColorVec(TextColorManager.getColorVec());
        this.kibitzArea.setFont(Ergo.opser.getFontOption("Text Window Font"));
        this.inputField.addKeyListener(new KeyboardListener());
        this.northCanvas = new CoordinateCanvas("North", this);
        this.southCanvas = new CoordinateCanvas("South", this);
        this.eastCanvas = new CoordinateCanvas("East", this);
        this.westCanvas = new CoordinateCanvas("West", this);
        this.boardCanvas = new BoardCanvas(this, this.game.getSize(), this.game.ss);
        this.statusPanel = this.configureStatus(Ergo.opser.getStringOption(statusString));
        if (Ergo.inApplet) {
            this.copyAsSGFItem.setEnabled(false);
            this.saveOutputItem.setEnabled(false);
            this.saveAsItem.setEnabled(false);
            this.saveItem.setEnabled(false);
            this.loadItem.setEnabled(false);
        }
        this.setSound(Ergo.opser.getBooleanOption("Sound"));
        this.refreshHostItem.setEnabled(false);
        this.setKibitzState(this.showKibitzes, this.showKibitzesForThisMoveOnly);
        this.browsingItem.setState(this.isBrowsing());
        this.localScoringItem.setState(this.game.scoringMode());
        this.focusHere = Ergo.opser.getBooleanOption(gwinTermOutString);
        this.updateFocus();
        this.showCoordinates = Ergo.opser.getBooleanOption(ScoordString);
        this.showCoordinatesItem.setState(this.showCoordinates);
        this.showVariationsItem.setState(Ergo.opser.getBooleanOption(variationString));
        TerminalWindow.registrar.registerMenu(this.windowsMenu, this);
        for (int i = 2; i <= 9; ++i) {
            class HandicapMenuCommand
            extends MenuCommand {
                private int stones;

                HandicapMenuCommand(int n) {
                    super(FMT_HANDICAP.get(new Integer(n)));
                    this.stones = n;
                }

                public void executeCommand(Object object) {
                    Move move = GameWindow.this.game.getCurrentMove();
                    int n = move == null ? 1 : move.moveNumber() + 1;
                    int n2 = 0;
                    if (GameWindow.this.isLocalGame() || GameWindow.this.isBrowsing()) {
                        GameWindow.this.placeMove(new HandicapMove(move, n2, n, GameWindow.this.isBrowsing(), this.stones, GameWindow.this.game.getSize()), false);
                        GameWindow.this.game.ss.emit();
                    } else if (GameWindow.this.game.firstMove() == null && GameWindow.this.gameStatus == 0) {
                        GameWindow.this.conn.send("handicap " + this.stones);
                    } else {
                        Util.beep();
                    }
                }
            }
            this.handicapMenu.add(new HandicapMenuCommand(i));
        }
        if (!this.isParticipating()) {
            this.doneItem.setEnabled(false);
            this.adjournItem.setEnabled(false);
            this.resignItem.setEnabled(false);
        }
        this.layoutComponents();
        this.configureCoordinates();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GameWindow.this.close();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                GameWindow.this.inputField.requestFocus();
            }
        });
        this.inputField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GameWindow.this.inputField.setText("");
                GameWindow.this.window.processCommand(actionEvent.getActionCommand(), GameWindow.this);
            }
        });
        this.noteCurrentMoveChanged();
        this.northCanvas.addMouseListener(this.popupControl);
        this.southCanvas.addMouseListener(this.popupControl);
        this.eastCanvas.addMouseListener(this.popupControl);
        this.westCanvas.addMouseListener(this.popupControl);
        this.boardCanvas.addMouseListener(this.popupControl);
        this.kibitzArea.addMouseListener(this.popupControl);
        this.boardPanel.addMouseListener(this.popupControl);
        this.statusPanel.addMouseListener(this.popupControl);
        this.stepBackButton.addMouseListener(this.popupControl);
        this.stepForwardButton.addMouseListener(this.popupControl);
    }

    private void layoutComponents() {
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.add("Center", this.boardPanel);
        if (this.tallConfiguration) {
            this.topPanel.add("South", this.statusPanel);
        } else {
            this.topPanel.add("East", this.statusPanel);
        }
        this.bottomPanel.setLayout(new BorderLayout());
        this.bottomPanel.add("North", this.kibitzArea);
        this.bottomPanel.add("South", this.inputField);
        MosaicPanel mosaicPanel = new MosaicPanel();
        MosaicLayout mosaicLayout = new MosaicLayout();
        mosaicPanel.setLayout(mosaicLayout);
        mosaicLayout.setConstraints("less expansion", new MosaicConstraints(0, 2, 0.5));
        mosaicLayout.setConstraints("none", new MosaicConstraints(0, 2, 0.0));
        mosaicLayout.setPos(0, 0);
        mosaicPanel.add("less expansion", this.topPanel);
        mosaicLayout.setPos(0, 1);
        mosaicPanel.add("none", this.bottomPanel);
        this.setLayout(new BorderLayout());
        this.add("Center", mosaicPanel);
        this.add("South", this.inputField);
        this.boardPanel.setLayout(new BoardLayout(this.game.size()));
        this.boardPanel.add("Board", this.boardCanvas);
    }

    public void run() {
        this.updateTitle();
        Dimension dimension = Ergo.opser.getSizeOption(this.sizeString);
        if (dimension != null) {
            this.setSize(dimension);
        } else {
            this.pack();
        }
        this.setLocation(Ergo.opser.getNextCascade(this.getSize()));
        this.show();
    }

    public String menuString() {
        return this.title();
    }

    public MenuShortcut menuShortcut() {
        return null;
    }

    public int menuPriority() {
        return 999;
    }

    public void menuSelect(Frame frame) {
        this.toFront();
    }

    public Class appliesTo() {
        return null;
    }

    public void displayString(String string) {
        this.kibitzArea.appendText(string);
    }

    public void displayString(String string, Color color) {
        this.kibitzArea.appendText(string, color);
    }

    public void noteFocusLost() {
        this.focusHere = false;
        this.focusHereItem.setState(this.focusHere);
    }

    public void setKoPosition(Position position) {
        if (this.statusPanel != null) {
            this.statusPanel.setKoPosition(position);
        }
    }

    public CommandHistory getCommandHistory() {
        return this.commandHistory;
    }

    public boolean gameInProgress() {
        return this.gameStatus == 0 || this.gameStatus == 3;
    }

    public void addKibitz(String string, String string2, String string3, boolean bl) {
        String string4 = (string == null ? LB_LOCAL.get() : string) + (string2 == null ? "" : " " + string2) + ": " + string3;
        this.addKibitz1(string4, bl);
    }

    public void addKibitz1(String string, boolean bl) {
        if (!Ergo.inApplet) {
            this.saveItem.setEnabled(true);
            this.saveAsItem.setEnabled(true);
        }
        if (!this.isNetGame()) {
            bl = true;
        }
        Move move = bl ? this.game.getCurrentMove() : this.game.finalServerMove();
        move.addKibitz(string);
        this.displayOneKibitz(string, move.moveNumber() + 1);
    }

    private void displayOneKibitz(String string, int n) {
        if (this.showKibitzes) {
            String string2 = this.showKibitzesForThisMoveOnly ? " " : "#" + n + " ";
            this.kibitzArea.appendText(string2 + string, TerminalWindow.kibitzColor);
        }
    }

    private void updateKibitzArea() {
        if (this.showKibitzesForThisMoveOnly) {
            Move move = this.game.getCurrentMove();
            this.kibitzArea.clearAll();
            Vector vector = move.kibitzes();
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    this.displayOneKibitz((String)vector.elementAt(i), move.moveNumber() + 1);
                }
            }
        }
    }

    public void setKibitzState(boolean bl, boolean bl2) {
        if (bl != this.showKibitzes) {
            this.showKibitzes = bl;
            if (this.showKibitzes) {
                this.bottomPanel.add("South", this.kibitzArea);
            } else {
                this.bottomPanel.remove(this.kibitzArea);
            }
            this.validate();
        }
        this.showKibitzesForThisMoveOnly = bl2;
    }

    public void noteScoringMode(boolean bl) {
        this.localScoringItem.setState(bl);
        if (bl) {
            this.savedBrowsing = this.browsing;
        } else {
            this.setBrowsing(this.savedBrowsing);
        }
        this.statusPanel.refresh();
    }

    public boolean allowMoreItems(Component component) {
        return true;
    }

    public void populatePopupMenu(PopupMenu popupMenu, Component component, int n, int n2) {
        this.popupHandler.populatePopup(popupMenu, component, n, n2);
    }

    public void adjourn() {
        this.statusPanel.stopTicking();
        if (this.gameStatus != 2) {
            this.gameStatus = 1;
        }
        this.statusPanel.refresh();
    }

    public void resign(String string) {
        this.game.setResult(string);
        this.statusPanel.stopTicking();
        this.gameStatus = 2;
        this.statusPanel.refresh();
    }

    public void ensureActive() {
        int n = this.game.currentMove().color();
        this.statusPanel.startTicking(n);
        this.statusPanel.stopTicking(Move.nextColor(n));
        if (this.gameStatus != 0) {
            this.gameStatus = 0;
            this.statusPanel.refresh();
            this.conn.control.sgc.inform(this);
        }
    }

    public int timeLeft() {
        return 0;
    }

    public boolean isOnServer() {
        return this.gameStatus == 0 && !this.isLocalGame();
    }

    public boolean isParticipating() {
        return this.isParticipating;
    }

    public int ourColor() {
        return this.ourColor;
    }

    public void setOurColor(int n) {
        if (n == 0 || n == 1 || n == 12) {
            this.ourColor = n;
        }
    }

    public boolean isTeachingGame() {
        return this.ourColor() == 12;
    }

    public boolean isNetGame() {
        return this.game.isNetGame();
    }

    public boolean isLocalGame() {
        return this.conn == null;
    }

    public boolean isBrowsing() {
        return this.browsing || !this.isNetGame() || this.gameStatus == 1 || this.gameStatus == 2 || this.game.finalServerMove() != this.game.getCurrentMove();
    }

    public void setBrowsing(boolean bl) {
        this.browsing = bl;
        this.browsingItem.setState(this.isBrowsing());
    }

    private void exitBrowsingMode() {
        if (this.isBrowsing()) {
            this.goBackward(-1, false);
            this.goToEnd();
        }
    }

    private void setSound(boolean bl) {
        this.sound = bl;
        this.soundItem.setState(bl);
    }

    public String title() {
        return this.title(true);
    }

    public String title(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl && this.isNetGame()) {
            stringBuffer.append("Game " + this.gameNumber + " -- ");
        }
        stringBuffer.append(this.game.whiteName + " (W");
        if (this.game.whiteRank != null) {
            stringBuffer.append(" " + this.game.whiteRank);
        }
        stringBuffer.append(") vs " + this.game.blackName + " (B");
        if (this.game.blackName != null) {
            stringBuffer.append(" " + this.game.blackRank);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.title();
    }

    public void updateTitle() {
        this.setTitle(this.title());
    }

    public void noteCurrentMoveChanged() {
        this.updateKibitzArea();
        if (this.game.getCurrentMove() instanceof RootMove) {
            this.handicapMenu.setEnabled(true);
        } else {
            this.handicapMenu.setEnabled(false);
        }
    }

    private void insertVariationAsKibitz(Move move) {
        int n = this.inputField.getCaretPosition();
        String string = move.toVariationString();
        String string2 = this.inputField.getText();
        this.inputField.setText(string2.substring(0, n) + string + string2.substring(n));
        this.inputField.setCaretPosition(n + string.length());
    }

    public void placeMove(Move move, boolean bl) {
        if (bl) {
            this.gameStatus = 0;
        }
        this.game.placeMove(move, this.window, this.isBrowsing(), bl);
        if (move instanceof PassMove) {
            this.kibitzArea.appendText(LB_PASS_MOVE.get(new Object[]{new Integer(move.moveNumber()), new Integer(move.color())}));
        }
        if (this.sound) {
            this.window.thwak();
        }
        this.statusPanel.refresh();
        this.noteCurrentMoveChanged();
        this.needsSaving = true;
        if (!Ergo.inApplet) {
            this.saveItem.setEnabled(true);
            this.saveAsItem.setEnabled(true);
        }
    }

    public void placeMove(int n, int n2) {
        Move move = this.game.getCurrentMove();
        if (this.game.scoringMode() && this.game.ss.readStone(n, n2) != 3) {
            if (this.conn != null && this.isNetGame() && this.isParticipating() && !this.isBrowsing()) {
                this.conn.send(new Position(n, n2).toString(), false);
            } else {
                this.placeMove(new RemovalMove(move, new Position(n, n2), move.moveNumber() + 1, true), false);
            }
        } else if (this.isNetGame() && this.isParticipating() && !this.isBrowsing()) {
            if (this.conn != null) {
                this.conn.send(new Position(n, n2).toString(), false);
            } else {
                Debug.println(">>> Ergo: No connection to server.  Move discarded.");
            }
        } else {
            Move move2 = move.variationAt(new Position(n, n2));
            if (move2 != null) {
                this.goForward(1, move2, false, false);
            } else {
                int n3 = move.moveNumber() + 1;
                int n4 = this.timeLeft();
                StoneMove stoneMove = new StoneMove(move, n4, n3, move.nextColor(), this.isBrowsing(), n, n2);
                this.placeMove(stoneMove, false);
            }
        }
    }

    public void goToMove(Move move) {
        if (move != null && move != this.game.getCurrentMove()) {
            int n;
            int n2 = move.moveNumber();
            if (n2 > (n = this.game.getCurrentMove().moveNumber())) {
                this.goForward(n2 - n);
            } else {
                this.goBackward(n - n2, false);
            }
        }
    }

    public void goBackward(int n, boolean bl) {
        boolean bl2 = this.game.scoringMode();
        Move move = this.game.getCurrentMove();
        this.game.goBackward(n, bl);
        if (move != this.game.getCurrentMove()) {
            this.noteCurrentMoveChanged();
            this.game.ss.emit();
            this.statusPanel.refresh();
            if (bl2 && !this.game.scoringMode()) {
                this.noteScoringMode(false);
            } else {
                this.setBrowsing(true);
            }
        }
    }

    public void goBackToKibitz() {
        boolean bl = this.game.scoringMode();
        Move move = this.game.getCurrentMove();
        this.game.goBackToKibitz();
        if (move != this.game.getCurrentMove()) {
            this.noteCurrentMoveChanged();
            this.game.ss.emit();
            this.statusPanel.refresh();
            if (bl && !this.game.scoringMode()) {
                this.noteScoringMode(false);
            } else {
                this.setBrowsing(true);
            }
        }
    }

    public void goForward(int n) {
        this.goForward(n, null, false, false);
    }

    public void goForward(int n, Move move, boolean bl, boolean bl2) {
        Move move2 = this.game.getCurrentMove();
        this.game.goForward(n, move, bl, null, bl2);
        if (move2 != this.game.getCurrentMove()) {
            this.noteCurrentMoveChanged();
            this.game.ss.emit();
            this.statusPanel.refresh();
            if (this.game.finalServerMove() == this.game.getCurrentMove()) {
                this.setBrowsing(false);
            }
        }
    }

    public void goToEnd() {
        Move move = this.game.getCurrentMove();
        this.game.goToEnd();
        if (move != this.game.getCurrentMove()) {
            this.noteCurrentMoveChanged();
            this.game.ss.emit();
            this.statusPanel.refresh();
            this.setBrowsing(false);
        }
    }

    public void undoDuringServerScoring() {
        while (this.game.finalServerMove() instanceof RemovalMove) {
            this.game.undo();
        }
    }

    public void undo() {
        if (this.game.scoringMode()) {
            this.undoDuringServerScoring();
        }
        if (this.conn.server.isNNGStype() || this.conn.server.isWINGtype()) {
            this.game.undo();
        }
        this.noteCurrentMoveChanged();
        this.game.ss.emit();
        this.needsSaving = true;
        if (!Ergo.inApplet) {
            this.saveItem.setEnabled(true);
            this.saveAsItem.setEnabled(true);
        }
        if (this.game.getCurrentMove().parent() instanceof RootMove) {
            this.handicapMenu.setEnabled(true);
        }
    }

    public void updateVariationsMenu() {
        Move move = this.game.getCurrentMove();
        this.variationsMenu.removeAll();
        if (move != null) {
            Move move2;
            int n = -1;
            while ((move2 = move.variationAt(n)) != null) {
                String string = (char)(n + 1 + 97) + " (" + move2.toString() + ")";
                this.variationsMenu.add(new VariationMenuItem(string, move2){

                    public void executeCommand(Object object) {
                        GameWindow.this.placeMove(this.getVariation(), false);
                        GameWindow.this.game.ss.emit();
                    }
                });
                ++n;
            }
        }
    }

    private void updateFocus() {
        this.focusHereItem.setState(this.focusHere);
        if (this.focusHereItem.getState()) {
            this.window.addOutputFocus(this);
        } else {
            this.window.removeOutputFocus(this);
        }
    }

    private boolean save() {
        if (this.filename == null) {
            return this.saveAs();
        }
        this.saveAs(this.filename);
        return false;
    }

    public boolean saveAs() {
        FileDialog fileDialog = new FileDialog((Frame)this, LB_SAVE_AS.get(), 1);
        this.filename = FMT_FILENAME.get(new Object[]{this.game.whiteName, this.game.blackName, Util.getSortableDate()});
        if (this.window.getDefaultDirectory() != null) {
            fileDialog.setDirectory(this.window.getDefaultDirectory());
        }
        fileDialog.setFile(this.filename);
        fileDialog.show();
        this.filename = fileDialog.getFile();
        if (this.filename == null) {
            return true;
        }
        this.filename = fileDialog.getDirectory() + this.filename;
        this.saveAs(this.filename);
        this.window.setDefaultDirectory(fileDialog.getDirectory());
        return false;
    }

    private void saveAs(String string) {
        try {
            PrintWriter printWriter = null;
            if (string != null) {
                printWriter = new PrintWriter(new FileWriter(string));
            }
            this.game.writeSGF(printWriter);
            if (printWriter != null) {
                printWriter.close();
            }
            this.needsSaving = false;
            this.saveItem.setEnabled(false);
        }
        catch (IOException iOException) {
            this.window.displayString(LB_SAVE_ERROR.get(iOException));
        }
    }

    private void copyAsSGF() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.game.writeSGF(printWriter);
        printWriter.flush();
        StringSelection stringSelection = new StringSelection(stringWriter.toString());
        clipboard.setContents(stringSelection, stringSelection);
    }

    public void close() {
        if (this.needsSaving && Ergo.opser.getBooleanOption(savePromptString)) {
            new YNCDialog(this, LB_ASK_SAVE_GAME.get(), true, MSG_ASK_SAVE_GAME.get(this.toString()), new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GameWindow.this.closeInternal(actionEvent.getActionCommand());
                }
            }, true).open();
        } else {
            this.closeInternal("No");
        }
    }

    void closeInternal(String string) {
        if (!"Cancel".equalsIgnoreCase(string)) {
            boolean bl = true;
            if (this.gameNumber != 0 && this.gameStatus == 0 && this.isNetGame()) {
                if (!this.isParticipating()) {
                    this.conn.send("unobserve " + this.gameNumber);
                    bl = false;
                } else if (this.ourColor == 12) {
                    this.conn.send("adjourn");
                }
            }
            if ("Yes".equalsIgnoreCase(string) && this.save()) {
                return;
            }
            this.setVisible(false);
            TerminalWindow.registrar.releaseMenu(this.windowsMenu);
            if (bl) {
                this.window.removeGameWindow(this);
            }
        }
    }

    public void commitSuicide() {
        this.statusPanel.commitSuicide();
        this.dispose();
    }

    public void refresh() {
        this.boardCanvas.refreshLocal();
        this.updateKibitzArea();
        this.statusPanel.refresh();
        this.northCanvas.refresh();
        this.southCanvas.refresh();
        this.eastCanvas.refresh();
        this.westCanvas.refresh();
    }

    public int getBevelWidth() {
        return this.boardCanvas.getBevelWidth();
    }

    public void toggleCoordinates() {
        this.toggleCoordinates(null);
    }

    public void toggleCoordinates(CoordinateCanvas coordinateCanvas) {
        if (coordinateCanvas == null) {
            this.showCoordinates = !this.showCoordinates;
            Boolean bl = this.showCoordinates ? Boolean.TRUE : Boolean.FALSE;
            Ergo.opser.updateOption(NcoordString, bl);
            Ergo.opser.updateOption(WcoordString, bl);
            Ergo.opser.updateOption(EcoordString, bl);
            Ergo.opser.updateOption(ScoordString, bl);
            this.showCoordinatesItem.setState(this.showCoordinates);
            this.configureCoordinates();
        } else {
            this.showCoordinatesItem.setState(false);
            if (coordinateCanvas == this.northCanvas) {
                Ergo.opser.updateOption(NcoordString, Boolean.FALSE);
            }
            if (coordinateCanvas == this.eastCanvas) {
                Ergo.opser.updateOption(EcoordString, Boolean.FALSE);
            }
            if (coordinateCanvas == this.southCanvas) {
                Ergo.opser.updateOption(ScoordString, Boolean.FALSE);
            }
            if (coordinateCanvas == this.westCanvas) {
                Ergo.opser.updateOption(WcoordString, Boolean.FALSE);
            }
            this.boardPanel.remove(coordinateCanvas);
            this.validate();
        }
    }

    private void configureCoordinates() {
        if (Ergo.opser.getBooleanOption(NcoordString)) {
            this.boardPanel.add("North", this.northCanvas);
        } else {
            this.boardPanel.remove(this.northCanvas);
        }
        if (Ergo.opser.getBooleanOption(ScoordString)) {
            this.boardPanel.add("South", this.southCanvas);
        } else {
            this.boardPanel.remove(this.southCanvas);
        }
        if (Ergo.opser.getBooleanOption(EcoordString)) {
            this.boardPanel.add("East", this.eastCanvas);
        } else {
            this.boardPanel.remove(this.eastCanvas);
        }
        if (Ergo.opser.getBooleanOption(WcoordString)) {
            this.boardPanel.add("West", this.westCanvas);
        } else {
            this.boardPanel.remove(this.westCanvas);
        }
        this.validate();
        this.refresh();
    }

    private GWPanel configureBrowser(boolean bl) {
        GWPanel gWPanel = new GWPanel();
        GWPanel gWPanel2 = new GWPanel();
        GWPanel gWPanel3 = new GWPanel();
        if (bl) {
            gWPanel2.setLayout(new ColumnLayout());
            gWPanel2.add(this.stepBackButton);
            gWPanel2.add(this.backBranchButton);
            gWPanel2.add(this.backKibButton);
            gWPanel2.add(this.toBeginningButton);
            gWPanel3.setLayout(new ColumnLayout());
            gWPanel3.add(this.stepForwardButton);
            gWPanel3.add(this.fwdBranchButton);
            gWPanel3.add(this.fwdKibButton);
            gWPanel3.add(this.toEndButton);
            gWPanel.setLayout(new RowLayout(2, 0, 0, false));
        } else {
            gWPanel2.setLayout(new FlowLayout(0, 0, 0));
            gWPanel2.add(this.toBeginningButton);
            gWPanel2.add(this.stepBackButton);
            gWPanel2.add(this.stepForwardButton);
            gWPanel2.add(this.toEndButton);
            gWPanel3.setLayout(new FlowLayout(0, 0, 0));
            gWPanel3.add(this.backBranchButton);
            gWPanel3.add(this.backKibButton);
            gWPanel3.add(this.fwdKibButton);
            gWPanel3.add(this.fwdBranchButton);
            gWPanel.setLayout(new ColumnLayout(2, 0, 0, false));
        }
        gWPanel.add(gWPanel2);
        gWPanel.add(gWPanel3);
        return gWPanel;
    }

    public StatusPanel configureStatus(String string) {
        String string2 = Ergo.opser.getStringOption(statusString);
        if (!string.equalsIgnoreCase(string2)) {
            Ergo.opser.updateOption(statusString, string);
        }
        if (this.statusPanel != null) {
            this.topPanel.remove(this.statusPanel);
        }
        if (!string.equalsIgnoreCase("None")) {
            if (string.equalsIgnoreCase("Bottom")) {
                this.tallConfiguration = true;
                this.statusPanel = new StatusPanel(this, this.configureBrowser(this.tallConfiguration), this.popupControl, !this.tallConfiguration, this.conn);
                this.topPanel.add("South", this.statusPanel);
            } else {
                this.tallConfiguration = false;
                this.statusPanel = new StatusPanel(this, this.configureBrowser(this.tallConfiguration), this.popupControl, !this.tallConfiguration, this.conn);
                this.topPanel.add("East", this.statusPanel);
            }
        }
        this.validate();
        return this.statusPanel;
    }

    public void updateTimers(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.game.currentMove().color();
        this.statusPanel.startTicking(n7);
        this.statusPanel.stopTicking(Move.nextColor(n7));
        this.statusPanel.setTime(0, n5, n6);
        this.statusPanel.setTime(1, n2, n3);
    }

    public void setKibitzVisible(boolean bl) {
        this.showKibitzes = bl;
        if (this.showKibitzes) {
            this.add("South", this.bottomPanel);
        } else {
            this.remove(this.bottomPanel);
        }
        this.validate();
    }

    void displayBoard() {
        System.out.println();
        System.out.println();
        for (int i = this.game.size() - 1; i >= 0; --i) {
            int n;
            for (n = 0; n < this.game.size(); ++n) {
                System.out.print(this.game.ss.readAnyStone(i, n) + " ");
            }
            System.out.print("    ");
            for (n = 0; n < this.game.size(); ++n) {
                if (this.game.groupAt(i, n) == null) {
                    System.out.print(". ");
                    continue;
                }
                System.out.print("G ");
            }
            System.out.println();
        }
    }

    void displayGroups() {
        System.out.println();
        SimpleGroupVector simpleGroupVector = new SimpleGroupVector();
        for (int i = this.game.size() - 1; i >= 0; --i) {
            for (int j = 0; j < this.game.size(); ++j) {
                SimpleGroup simpleGroup = this.game.groupAt(i, j);
                if (simpleGroup == null || simpleGroupVector.indexOf(simpleGroup) != -1) continue;
                System.out.println(simpleGroup.toString());
                simpleGroupVector.addElement(simpleGroup);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class mouseListener
    extends MouseAdapter {
        mouseListener() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof ImageButton && !mouseEvent.isPopupTrigger()) {
                ImageButton imageButton = (ImageButton)component;
                if (imageButton == GameWindow.this.stepBackButton) {
                    GameWindow.this.goBackward(1, false);
                } else if (imageButton == GameWindow.this.stepForwardButton) {
                    GameWindow.this.goForward(1);
                } else if (imageButton == GameWindow.this.toBeginningButton) {
                    GameWindow.this.goBackward(-1, false);
                } else if (imageButton == GameWindow.this.toEndButton) {
                    GameWindow.this.goToEnd();
                } else if (imageButton == GameWindow.this.backKibButton) {
                    GameWindow.this.goBackToKibitz();
                } else if (imageButton == GameWindow.this.fwdKibButton) {
                    GameWindow.this.goForward(-1, null, true, true);
                } else if (imageButton == GameWindow.this.backBranchButton) {
                    GameWindow.this.goBackward(-1, true);
                } else if (imageButton == GameWindow.this.fwdBranchButton) {
                    GameWindow.this.goForward(-1, null, true, false);
                }
            }
        }
    }

    class KeyboardListener
    extends KeyAdapter {
        KeyboardListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            boolean bl = keyEvent.isAltDown() || keyEvent.isMetaDown();
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    if (bl) {
                        GameWindow.this.goForward(-1, null, true, false);
                    } else {
                        String string = GameWindow.this.commandHistory.getPreviousElement();
                        if (string != null) {
                            GameWindow.this.inputField.setText(string);
                            GameWindow.this.inputField.setCaretPosition(string.length() - 1);
                        }
                    }
                    return;
                }
                case 40: {
                    if (bl) {
                        GameWindow.this.goBackward(-1, true);
                    } else {
                        String string = GameWindow.this.commandHistory.getNextElement();
                        if (string != null) {
                            GameWindow.this.inputField.setText(string);
                            GameWindow.this.inputField.setCaretPosition(string.length() - 1);
                        }
                    }
                    return;
                }
                case 37: {
                    if (bl) {
                        GameWindow.this.goBackward(1, false);
                    }
                    return;
                }
                case 39: {
                    if (bl) {
                        GameWindow.this.goForward(1);
                    }
                    return;
                }
            }
        }
    }

    class menuListener
    extends AbstractMenuListener {
        menuListener() {
        }

        public void itemSelected(MenuItem menuItem) {
            if (menuItem == GameWindow.this.closeItem) {
                GameWindow.this.close();
            } else if (menuItem == GameWindow.this.refreshLocalItem) {
                GameWindow.this.refresh();
            } else if (menuItem == GameWindow.this.refreshHostItem) {
                if (GameWindow.this.isNetGame()) {
                    GameWindow.this.conn.send("refresh");
                }
            } else if (menuItem == GameWindow.this.saveItem) {
                GameWindow.this.save();
            } else if (menuItem == GameWindow.this.saveAsItem) {
                GameWindow.this.saveAs();
            } else if (menuItem == GameWindow.this.loadItem) {
                GameWindow.this.window.load();
            } else if (menuItem == GameWindow.this.saveOutputItem) {
                GameWindow.this.window.saveTerminalOutput(GameWindow.this.kibitzArea);
            } else if (menuItem == GameWindow.this.passItem) {
                if (GameWindow.this.isNetGame() && !GameWindow.this.isBrowsing()) {
                    GameWindow.this.conn.send("pass");
                } else {
                    Move move = GameWindow.this.game.getCurrentMove();
                    int n = move.moveNumber() + 1;
                    int n2 = 300;
                    GameWindow.this.placeMove(new PassMove(move, n2, n, move.nextColor(), GameWindow.this.isBrowsing()), false);
                    GameWindow.this.game.ss.emit();
                }
            } else if (menuItem == GameWindow.this.undoItem) {
                if (GameWindow.this.isNetGame() && GameWindow.this.isParticipating() && !GameWindow.this.isBrowsing()) {
                    GameWindow.this.conn.send("undo");
                } else {
                    GameWindow.this.goBackward(1, false);
                }
                GameWindow.this.game.ss.emit();
            } else if (menuItem == GameWindow.this.doneItem) {
                if (GameWindow.this.isNetGame() && GameWindow.this.isParticipating() && !GameWindow.this.isBrowsing()) {
                    GameWindow.this.conn.send("done");
                }
            } else if (menuItem == GameWindow.this.adjournItem) {
                if (GameWindow.this.isNetGame() && GameWindow.this.isParticipating()) {
                    GameWindow.this.conn.send("adjourn");
                }
            } else if (menuItem == GameWindow.this.resignItem) {
                if (GameWindow.this.isNetGame() && GameWindow.this.isParticipating() && !GameWindow.this.isBrowsing()) {
                    ActionListener actionListener = new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            String string = actionEvent.getActionCommand();
                            if ("Yes".equalsIgnoreCase(string)) {
                                GameWindow.this.conn.send("resign");
                            }
                        }
                    };
                    new YNCDialog(GameWindow.this, LB_ASK_RESIGN.get(), true, MSG_ASK_RESIGN.get(), actionListener, false).open();
                }
            } else if (menuItem == GameWindow.this.copyAsSGFItem || menuItem.getLabel().equals(LB_COPY_AS_SGF.get())) {
                GameWindow.this.copyAsSGF();
            } else if (menuItem == GameWindow.this.dumpBoardItem) {
                GameWindow.this.displayBoard();
            } else if (menuItem == GameWindow.this.dumpGroupsItem) {
                GameWindow.this.displayGroups();
            }
        }
    }

    class exclusiveCheckboxListener
    implements ItemListener {
        exclusiveCheckboxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)itemEvent.getSource();
            if (checkboxMenuItem == GameWindow.this.kibitzAllItem) {
                GameWindow.this.setKibitzState(true, false);
            } else if (checkboxMenuItem == GameWindow.this.kibitzCurrentItem) {
                GameWindow.this.setKibitzState(true, true);
            } else if (checkboxMenuItem == GameWindow.this.kibitzNoneItem) {
                GameWindow.this.setKibitzState(false, GameWindow.this.showKibitzesForThisMoveOnly);
            } else if (checkboxMenuItem == GameWindow.this.stonesItems[0]) {
                Ergo.opser.updateOption("Stone Style", new Integer(0));
            } else if (checkboxMenuItem == GameWindow.this.stonesItems[1]) {
                Ergo.opser.updateOption("Stone Style", new Integer(1));
            } else if (checkboxMenuItem == GameWindow.this.stonesItems[2]) {
                Ergo.opser.updateOption("Stone Style", new Integer(2));
            } else if (checkboxMenuItem == GameWindow.this.boardItems[0]) {
                Ergo.opser.updateOption("Board Style", new Integer(0));
            } else if (checkboxMenuItem == GameWindow.this.boardItems[1]) {
                Ergo.opser.updateOption("Board Style", new Integer(1));
            } else if (checkboxMenuItem == GameWindow.this.showStatusNoneItem) {
                GameWindow.this.statusPanel = GameWindow.this.configureStatus("None");
            } else if (checkboxMenuItem == GameWindow.this.showStatusRightItem) {
                GameWindow.this.statusPanel = GameWindow.this.configureStatus("Right");
            } else if (checkboxMenuItem == GameWindow.this.showStatusBottomItem) {
                GameWindow.this.statusPanel = GameWindow.this.configureStatus("Bottom");
            }
        }
    }

    class checkboxListener
    extends urCheckboxListener {
        checkboxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == GameWindow.this.showCoordinatesItem) {
                GameWindow.this.toggleCoordinates();
            } else if (object == GameWindow.this.browsingItem) {
                boolean bl = GameWindow.this.browsing;
                GameWindow.this.setBrowsing(!GameWindow.this.browsing);
                if (bl) {
                    GameWindow.this.exitBrowsingMode();
                }
            } else if (object == GameWindow.this.soundItem) {
                GameWindow.this.setSound(!GameWindow.this.sound);
            } else if (object == GameWindow.this.localScoringItem) {
                if (GameWindow.this.game.scoringMode()) {
                    GameWindow.this.game.exitScoringMode();
                } else {
                    GameWindow.this.game.enterScoringMode(true);
                    if (GameWindow.this.isNetGame() && GameWindow.this.game.scoringMode()) {
                        GameWindow.this.setBrowsing(true);
                    }
                }
                GameWindow.this.noteScoringMode(GameWindow.this.game.scoringMode());
            } else if (object == GameWindow.this.focusHereItem) {
                GameWindow.this.focusHere = !GameWindow.this.focusHere;
                GameWindow.this.updateFocus();
            } else if (object == GameWindow.this.showVariationsItem) {
                Ergo.opser.updateOption("Game Window Variation Letters", new Boolean(GameWindow.this.showVariationsItem.getState()));
            }
        }
    }

    class PopupHandler {
        private VariationMenuItem deleteVarItem;
        private VariationMenuItem sendVarItem;
        private MenuCommand deleteAllItem;
        private MenuCommand browseItem;
        private MenuCommand copySGFItem;
        private MenuCommand statsBlackItem;
        private MenuCommand statsWhiteItem;
        private MenuCommand showObsItem;
        private MenuCommand reloadItem;
        private int row;
        private int col;

        public PopupHandler() {
            this.deleteVarItem = new VariationMenuItem(LB_DELETE_VARIATION.get(), null){

                public void executeCommand(Object object) {
                    Move move = this.getVariation();
                    Move move2 = move.parent();
                    this.setVariation(null);
                    if (move2 != null) {
                        move2.removeVariation(move);
                        GameWindow.this.goBackward(1, false);
                        GameWindow.this.goForward(1);
                    }
                }
            };
            this.sendVarItem = new VariationMenuItem(LB_INSERT_VARIATION_AS_KIBITZ.get(), null){

                public void executeCommand(Object object) {
                    GameWindow.this.insertVariationAsKibitz(this.getVariation());
                }
            };
            this.browseItem = new MenuCommand(LB_BROUSE_TO_POSITION.get()){

                public void executeCommand(Object object) {
                    GameWindow.this.goToMove(((PopupHandler)PopupHandler.this).GameWindow.this.game.findMove(PopupHandler.this.row, PopupHandler.this.col));
                }
            };
            this.deleteAllItem = new MenuCommand(""){

                public void executeCommand(Object object) {
                    SimpleGroupVector simpleGroupVector = ((PopupHandler)PopupHandler.this).GameWindow.this.game.groupsInRegion(new Position(PopupHandler.this.row, PopupHandler.this.col));
                    Move move = ((PopupHandler)PopupHandler.this).GameWindow.this.game.getCurrentMove();
                    if (simpleGroupVector != null) {
                        for (int i = 0; i < simpleGroupVector.size(); ++i) {
                            if (GameWindow.this.conn != null && GameWindow.this.isNetGame() && GameWindow.this.isParticipating() && !GameWindow.this.isBrowsing()) {
                                GameWindow.this.conn.send(simpleGroupVector.elementAt(i).positionAt(0).toString(), false);
                                continue;
                            }
                            RemovalMove removalMove = new RemovalMove(move, simpleGroupVector.elementAt(i).positionAt(0), move.moveNumber() + 1, true);
                            GameWindow.this.placeMove(removalMove, false);
                            move = removalMove;
                        }
                        ((PopupHandler)PopupHandler.this).GameWindow.this.game.ss.emit();
                    }
                }
            };
            this.copySGFItem = new MenuCommand(LB_COPY_AS_SGF.get()){

                public void executeCommand(Object object) {
                    GameWindow.this.copyAsSGF();
                }
            };
            if (Ergo.inApplet) {
                this.copySGFItem.setEnabled(false);
            }
            this.statsBlackItem = new MenuCommand(LB_STATS.get(GameWindow.this.game.blackName)){

                public void executeCommand(Object object) {
                    GameWindow.this.conn.send("stats " + ((PopupHandler)PopupHandler.this).GameWindow.this.game.blackName, true);
                }
            };
            this.statsWhiteItem = new MenuCommand(LB_STATS.get(GameWindow.this.game.whiteName)){

                public void executeCommand(Object object) {
                    GameWindow.this.conn.send("stats " + ((PopupHandler)PopupHandler.this).GameWindow.this.game.whiteName, true);
                }
            };
            this.showObsItem = new MenuCommand(LB_SHOW_OBSERVERS.get()){

                public void executeCommand(Object object) {
                    GameWindow.this.conn.send("all " + ((PopupHandler)PopupHandler.this).GameWindow.this.gameNumber, true);
                }
            };
            this.reloadItem = new MenuCommand(LB_LOAD.get(new Object[]{GameWindow.this.game.whiteName, GameWindow.this.game.blackName})){

                public void executeCommand(Object object) {
                    GameWindow.this.conn.send("load " + ((PopupHandler)PopupHandler.this).GameWindow.this.game.whiteName + "-" + ((PopupHandler)PopupHandler.this).GameWindow.this.game.blackName);
                }
            };
        }

        public void populatePopup(PopupMenu popupMenu, Component component, int n, int n2) {
            this.row = GameWindow.this.boardCanvas.ytorow(n2);
            this.col = GameWindow.this.boardCanvas.xtocol(n);
            if (component == GameWindow.this.boardCanvas) {
                Move move;
                int n3 = GameWindow.this.game.ss.readStone(this.row, this.col);
                if (n3 != 3) {
                    popupMenu.add(this.browseItem);
                }
                int n4 = -1;
                while ((move = GameWindow.this.game.getCurrentMove().variationAt(n4)) != null) {
                    PositionVector positionVector = move.placedPositions(GameWindow.this.game.getSize());
                    if (positionVector != null) {
                        for (int i = 0; i < positionVector.size(); ++i) {
                            Position position = positionVector.elementAt(i);
                            if (position.row != this.row || position.column != this.col) continue;
                            this.deleteVarItem.setVariation(move);
                            this.sendVarItem.setVariation(move);
                            popupMenu.add(this.deleteVarItem);
                            popupMenu.add(this.sendVarItem);
                            break;
                        }
                    }
                    ++n4;
                }
                if (n3 != 3 && GameWindow.this.game.scoringMode()) {
                    String string = LB_REMOVE_GROUPS.get(new Integer(n3));
                    this.deleteAllItem.setLabel(string);
                    popupMenu.add(this.deleteAllItem);
                }
                popupMenu.add(this.copySGFItem);
            }
            if (GameWindow.this.isNetGame()) {
                if (popupMenu.getItemCount() > 0) {
                    popupMenu.addSeparator();
                }
                popupMenu.add(this.statsBlackItem);
                popupMenu.add(this.statsWhiteItem);
                popupMenu.add(this.showObsItem);
                if (GameWindow.this.gameStatus == 1) {
                    popupMenu.add(this.reloadItem);
                }
            }
        }
    }

    class SizeListener
    extends ComponentAdapter {
        SizeListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            Dimension dimension = GameWindow.this.getSize();
            Ergo.opser.updateOption(GameWindow.this.sizeString, dimension);
        }
    }
}

