/*
 * Decompiled with CFR 0.152.
 */
package ergo.ui;

import ergo.Ergo;
import ergo.server.Controller;
import ergo.server.Rank;
import ergo.server.ServerConnection;
import ergo.server.ServerPlayer;
import ergo.ui.AbstractMenuListener;
import ergo.ui.GameWindow;
import ergo.ui.GoClient;
import ergo.ui.MultiBox;
import ergo.ui.MultiCallBackable;
import ergo.ui.MultiWindow;
import ergo.ui.MultiWindowBackable;
import ergo.ui.Optionizable;
import ergo.ui.PositionListener;
import ergo.ui.ServerPlayerContainer;
import ergo.ui.TerminalWindow;
import ergo.ui.TextColorManager;
import ergo.ui.urMenuBar;
import ergo.util.Debug;
import ergo.util.ParseException;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import org.unitarou.ml.Message;

public class ServerGameContainer
implements MultiCallBackable,
MultiWindowBackable,
Optionizable {
    private static final String sgcvisibleString = "Games View Lines";
    private static final String sgcposString = "Games View Position";
    private static final String sgcsortString = "Games View Sort";
    private static final int SORT_NUM = 0;
    private static final int SORT_RANK = 1;
    private static final int SORT_MOVE = 2;
    private static final Message LB_BY_NUMBER = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbByNumber");
    private static final Message LB_BY_RANK = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbByRank");
    private static final Message LB_BY_MOVE = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbByMove");
    private static final Message LB_VIEW = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbView");
    private static final Message LB_REFRESH = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbRefresh");
    private static final Message LB_REFRESH_ALL = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbRefreshAll");
    private static final Message LB_CLOSE = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbClose");
    private static final Message LB_OBSERVE = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbObserve");
    private static final Message LB_Unobserve = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbUnobserve");
    private static final Message LB_SHOW_OBSERVERS = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbShowObservers");
    private static final Message LB_OPTIONS = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbOptions");
    private static final Message LB_GAME = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbGame");
    private static final Message LB_WHITE_NAME = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbWhiteName");
    private static final Message LB_W_RANK = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbWRank");
    private static final Message LB_BLACK_NAME = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbBlackName");
    private static final Message LB_B_RANK = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbBRank");
    private static final Message LB_MOVE = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbMove");
    private static final Message LB_SIZE = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbSize");
    private static final Message LB_HC = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbHc");
    private static final Message LB_KOMI = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbKomi");
    private static final Message LB_BYO = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbByo");
    private static final Message LB_FR = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbFr");
    private static final Message LB_OBS = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbObs");
    private static final Message LB_WINDOW = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbWindow");
    private static final Message LB_GAMES_VIEW_1 = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbGamesView1");
    private static final Message LB_GAMES_VIEW_2 = new Message(class$ergo$ui$ServerGameContainer == null ? (class$ergo$ui$ServerGameContainer = ServerGameContainer.class$("ergo.ui.ServerGameContainer")) : class$ergo$ui$ServerGameContainer, "lbGamesView2");
    private static final String[] sortMethods = new String[]{LB_BY_NUMBER.get(), LB_BY_RANK.get(), LB_BY_MOVE.get()};
    private final Hashtable serverGames = new Hashtable();
    private boolean filled = false;
    private Controller control;
    private ServerConnection conn;
    private GoClient client;
    private MultiBox mb;
    private MultiWindow sgcw;
    private final urMenuBar menuBar = new urMenuBar(null);
    private final menuListener mListen = new menuListener();
    private final Menu viewMenu = this.menuBar.generate(LB_VIEW.get());
    private final MenuItem refreshItem = this.mListen.generate(this.viewMenu, LB_REFRESH.get(), new MenuShortcut(82));
    private final MenuItem refreshaItem = this.mListen.generateWithSep(this.viewMenu, LB_REFRESH_ALL.get(), new MenuShortcut(82, true));
    private final MenuItem closeItem = this.mListen.generate(this.viewMenu, LB_CLOSE.get(), new MenuShortcut(87));
    private final MenuItem obsItem = new MenuItem(LB_OBSERVE.get(), new MenuShortcut(79));
    private final MenuItem unobsItem = new MenuItem(LB_Unobserve.get(), new MenuShortcut(85));
    private final MenuItem allItem = new MenuItem(LB_SHOW_OBSERVERS.get());
    private final PopupMenu obspm = new PopupMenu(LB_OPTIONS.get());
    ServerGame stashedUseful;
    private ServerGame tsg = new ServerGame();
    static /* synthetic */ Class class$ergo$ui$ServerGameContainer;

    public ServerGameContainer(Controller controller, ServerConnection serverConnection, GoClient goClient) {
        this.control = controller;
        this.conn = serverConnection;
        this.client = goClient;
        String string = "";
        String string2 = "l";
        String[] stringArray = new String[]{string2, string2, string2, string2, string2, string2, string2, string2, string2, string2, string2, string2};
        String[] stringArray2 = new String[]{LB_GAME.get(), LB_WHITE_NAME.get(), LB_W_RANK.get(), LB_BLACK_NAME.get(), LB_B_RANK.get(), LB_MOVE.get(), LB_SIZE.get(), LB_HC.get(), LB_KOMI.get(), LB_BYO.get(), LB_FR.get(), LB_OBS.get()};
        String[] stringArray3 = new String[]{"99.", "WWWWWWWWWW", "99k*", "WWWWWWWWWW", "99k*", "999", "19", "9", "-0.5", "99", "T", "99"};
        Ergo.opser.expressOwnership(sgcvisibleString, 1, null, new Integer(10));
        Ergo.opser.expressOwnership(sgcsortString, 1, null, new Integer(0));
        Ergo.opser.expressOwnership(Ergo.opser.savingString, 2, this, new Boolean(true));
        TextColorManager.expressAll(this, 4);
        Ergo.opser.expressOwnership("Info Window Font", 5, this, null);
        int n = Ergo.opser.getIntegerOption(sgcsortString);
        try {
            this.mb = new MultiBox(this, stringArray, stringArray3, stringArray2, Ergo.opser.getIntegerOption(sgcvisibleString), n);
        }
        catch (Exception exception) {
            Debug.backtrace(exception);
        }
        this.sgcw = new MultiWindow(this, this.mb, n);
        PositionListener positionListener = new PositionListener(sgcposString, this.sgcw, new Point(100, 500), Ergo.opser);
        TerminalWindow.registrar.registerWindowsMenuCommand(this.sgcw);
        this.mb.setColorVec(TextColorManager.getColorVec());
        this.mb.setFont(Ergo.opser.getFontOption("Info Window Font"));
        this.mb.add(this.obspm);
        MenuBar menuBar = new MenuBar();
        menuBar.add(this.viewMenu);
        menuBar.add(this.sgcw.getSortMenu());
        menuBar.add(TerminalWindow.registrar.registerMenu(new Menu(LB_WINDOW.get()), this.sgcw));
        this.sgcw.setMenuBar(menuBar);
    }

    public void winDestroyed() {
        this.filled = false;
    }

    public String[] sortMethods() {
        return sortMethods;
    }

    public int defaultSortMethod() {
        return 0;
    }

    public String windowName() {
        return LB_GAMES_VIEW_1.get(this.conn.toString());
    }

    public String menuString() {
        return LB_GAMES_VIEW_2.get();
    }

    public MenuShortcut menuShortcut() {
        return new MenuShortcut(71);
    }

    public int menuPriority() {
        return 101;
    }

    public void menuSelect(Frame frame) {
        this.sgcw.setVisible(true);
        this.sgcw.toFront();
        if (!this.filled) {
            this.filled = true;
            this.conn.send("games", false);
        }
    }

    public Class appliesTo() {
        return null;
    }

    public void optionEvent(String string, Object object) {
        if (Ergo.opser.isSameKey(Ergo.opser.savingString, string)) {
            Ergo.opser.updateOption(sgcvisibleString, new Integer(this.mb.visLines()));
        } else if (TextColorManager.isColorString(string)) {
            this.mb.setColorVec(TextColorManager.getColorVec());
        } else if (Ergo.opser.isSameKey(string, "Info Window Font")) {
            this.mb.setFont(Ergo.opser.getFontOption("Info Window Font"));
            this.sgcw.pack();
        }
    }

    public int eventOn(Object object, MouseEvent mouseEvent, int n) {
        ServerGame serverGame = (ServerGame)object;
        if (mouseEvent.getID() == 501) {
            if (mouseEvent.isMetaDown()) {
                this.obspm.removeAll();
                if (serverGame.gw == null) {
                    this.obspm.add(this.obsItem);
                } else {
                    this.obspm.add(this.unobsItem);
                }
                this.obspm.add(this.allItem);
                this.obspm.show(this.mb.listCanvas, mouseEvent.getX(), mouseEvent.getY());
            } else if (mouseEvent.getClickCount() == 2) {
                if (serverGame.gw == null) {
                    this.conn.send("observe " + this.stashedUseful.num, false);
                } else {
                    serverGame.gw.menuSelect(null);
                }
            }
        }
        this.stashedUseful = serverGame;
        return 0;
    }

    public boolean actionOn(Event event, Object object) {
        if (event.target == this.obsItem) {
            this.conn.send("observe " + this.stashedUseful.num, false);
        } else if (event.target == this.unobsItem) {
            this.conn.send("unobserve " + this.stashedUseful.num, false);
        } else if (event.target == this.allItem) {
            this.conn.send("all " + this.stashedUseful.num, false);
        }
        return true;
    }

    public Enumeration Games() {
        return this.serverGames.elements();
    }

    public ServerGame nextGame(Enumeration enumeration) {
        return (ServerGame)enumeration.nextElement();
    }

    public void inform(GameWindow gameWindow) {
        ServerGame serverGame = this.byNames(gameWindow.game.whiteName, gameWindow.game.blackName);
        if (serverGame == null) {
            return;
        }
        serverGame.gw = gameWindow;
        this.updateGame(serverGame, false);
    }

    public void uninform(GameWindow gameWindow) {
        ServerGame serverGame = this.byNames(gameWindow.game.whiteName, gameWindow.game.blackName);
        if (serverGame == null) {
            return;
        }
        serverGame.gw = null;
        this.updateGame(serverGame, false);
    }

    public synchronized ServerGame byNames(String string, String string2) {
        this.tsg.imbue(string, string2);
        return (ServerGame)this.serverGames.get(this.tsg);
    }

    public int compare(int n, Object object, Object object2) {
        ServerGame serverGame = (ServerGame)object;
        ServerGame serverGame2 = (ServerGame)object2;
        switch (n) {
            case 0: {
                if (serverGame.num > serverGame2.num) {
                    return 1;
                }
                return -1;
            }
            case 1: {
                Rank rank = serverGame.wrank.compareTo(serverGame.brank) < 0 ? serverGame.wrank : serverGame.brank;
                Rank rank2 = serverGame2.wrank.compareTo(serverGame2.brank) < 0 ? serverGame2.wrank : serverGame2.brank;
                return rank.compareTo(rank2);
            }
            case 2: {
                if (serverGame.move > serverGame2.move) {
                    return 1;
                }
                return -1;
            }
        }
        return 0;
    }

    private void checkGameWindow(ServerGame serverGame) {
        serverGame.gw = this.client.getGameWindowByNumber(serverGame.num);
        if (serverGame.gw != null && !serverGame.gw.isOnServer()) {
            serverGame.gw = null;
        }
    }

    public void addGame(ServerGame serverGame, boolean bl) {
        this.serverGames.put(serverGame, serverGame);
        this.checkGameWindow(serverGame);
        this.mb.insertEntry(serverGame, serverGame.render(), bl);
    }

    public void updateGame(ServerGame serverGame, boolean bl) {
        this.checkGameWindow(serverGame);
        this.mb.updateEntry(serverGame, serverGame.render());
    }

    public void removeGame(ServerGame serverGame, boolean bl) {
        if (serverGame == null) {
            return;
        }
        this.serverGames.remove(serverGame);
        this.mb.removeEntry(serverGame, bl);
    }

    public void clear() {
        Enumeration enumeration = this.Games();
        while (enumeration.hasMoreElements()) {
            this.removeGame(this.nextGame(enumeration), true);
        }
    }

    public void destroy() {
        this.clear();
        TerminalWindow.registrar.deregisterWindowsMenuCommand(this.sgcw);
        this.sgcw.dispose();
    }

    public void update() {
        this.mb.refresh();
    }

    public void show() {
        this.sgcw.show();
    }

    public void setSort(int n) {
        Ergo.opser.updateOption(sgcsortString, new Integer(n));
        this.mb.reSort(n);
        this.mb.refresh();
    }

    public void disapply(int n, String string, String string2) {
        Object object;
        ServerPlayerContainer serverPlayerContainer = this.control.spc;
        Enumeration enumeration = serverPlayerContainer.Players();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            object = serverPlayerContainer.nextPlayer(enumeration);
            String string3 = Integer.toString(n);
            if (((ServerPlayer)object).observing.equals(string3)) {
                ((ServerPlayer)object).observing = "--";
                serverPlayerContainer.updatePlayer((ServerPlayer)object, true);
                bl = true;
            }
            if (!((ServerPlayer)object).playing.equals(string3)) continue;
            ((ServerPlayer)object).playing = "--";
            serverPlayerContainer.updatePlayer((ServerPlayer)object, true);
            bl = true;
        }
        if (bl) {
            serverPlayerContainer.update();
        }
        object = this.byNames(string, string2);
        this.removeGame((ServerGame)object, false);
    }

    public void applyreflect(ServerGame serverGame, boolean bl) {
        ServerPlayerContainer serverPlayerContainer = this.control.spc;
        ServerPlayer serverPlayer = serverPlayerContainer.byName(serverGame.wname);
        ServerPlayer serverPlayer2 = serverPlayerContainer.byName(serverGame.bname);
        String string = Integer.toString(serverGame.num);
        if (serverPlayer != null) {
            serverPlayer.playing = string;
            serverPlayerContainer.updatePlayer(serverPlayer, bl);
        }
        if (serverPlayer2 != null) {
            serverPlayer2.playing = string;
            serverPlayerContainer.updatePlayer(serverPlayer2, bl);
        }
    }

    public void apply(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, boolean bl) {
        try {
            ServerGame serverGame = this.byNames(string2, string4);
            if (serverGame == null) {
                serverGame = new ServerGame();
                serverGame.imbue(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12);
                this.addGame(serverGame, bl);
            } else {
                serverGame.imbue(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12);
                this.updateGame(serverGame, bl);
            }
            this.applyreflect(serverGame, bl);
        }
        catch (ParseException parseException) {
            Debug.backtrace(parseException);
        }
    }

    public void apply(String string, String string2, String string3, String string4, String string5, String string6) {
        try {
            ServerGame serverGame = this.byNames(string2, string4);
            if (serverGame == null) {
                serverGame = new ServerGame();
                serverGame.imbue(string, string2, string3, string4, string5, string6);
                this.addGame(serverGame, false);
                this.applyreflect(serverGame, false);
            }
        }
        catch (ParseException parseException) {
            Debug.backtrace(parseException);
        }
    }

    public void apply(String string, String string2, String string3, String string4, String string5) {
        try {
            ServerGame serverGame = this.byNames(string2, string4);
            if (serverGame == null) {
                serverGame = new ServerGame();
                serverGame.imbue(string, string2, string3, string4, string5);
                this.addGame(serverGame, false);
                this.applyreflect(serverGame, false);
            }
        }
        catch (ParseException parseException) {
            Debug.backtrace(parseException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ServerGame {
        int num;
        String wname;
        Rank wrank;
        String bname;
        Rank brank;
        String size = "?";
        String handi = "?";
        String komi = "?";
        String byo = "?";
        int move = 0;
        String freeness = "?";
        String observers = "0";
        GameWindow gw = null;

        ServerGame() {
        }

        public void imbue(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12) throws ParseException {
            this.size = string7;
            this.handi = string8;
            this.komi = string9;
            this.byo = string10;
            this.freeness = string11;
            this.observers = string12;
            this.imbue(string, string2, string3, string4, string5, string6);
        }

        public void imbue(String string, String string2, String string3, String string4, String string5, String string6) throws ParseException {
            this.move = Integer.parseInt(string6);
            this.imbue(string, string2, string3, string4, string5);
        }

        public void imbue(String string, String string2, String string3, String string4, String string5) throws ParseException {
            this.num = Integer.parseInt(string);
            this.wrank = new Rank(string3);
            this.brank = new Rank(string5);
            this.imbue(string2, string4);
        }

        public void imbue(String string, String string2) {
            this.wname = string;
            this.bname = string2;
        }

        public String[] render() {
            String[] stringArray = new String[]{Integer.toString(this.num) + ".", this.wname, this.wrank.render(), this.bname, this.brank.render(), Integer.toString(this.move), this.size, this.handi, this.komi, this.byo, this.freeness, this.observers, this.gw == null ? null : ""};
            return stringArray;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ServerGame)) {
                return false;
            }
            ServerGame serverGame = (ServerGame)object;
            return serverGame.wname.equals(this.wname) && serverGame.bname.equals(this.bname);
        }

        public int hashCode() {
            return this.wname.hashCode() * this.bname.hashCode();
        }
    }

    class menuListener
    extends AbstractMenuListener {
        menuListener() {
        }

        public void itemSelected(MenuItem menuItem) {
            if (menuItem == ServerGameContainer.this.refreshItem) {
                ServerGameContainer.this.conn.send("games", false);
            } else if (menuItem == ServerGameContainer.this.refreshaItem) {
                ServerGameContainer.this.conn.send("games", false);
            } else if (menuItem == ServerGameContainer.this.closeItem) {
                ServerGameContainer.this.sgcw.destroyed();
            }
        }
    }
}

