/*
 * Decompiled with CFR 0.152.
 */
package ergo.ui;

import ergo.Ergo;
import ergo.logic.GameResultMove;
import ergo.logic.Move;
import ergo.server.SimpleServerConnection;
import ergo.ui.ColorSpec;
import ergo.ui.ColumnLayout;
import ergo.ui.ErgoCanvas;
import ergo.ui.GameWindow;
import ergo.ui.ImageLabel;
import ergo.ui.OodInnaBox;
import ergo.ui.Optionizable;
import ergo.ui.Optionizer;
import ergo.ui.RawImage;
import ergo.ui.RowLayout;
import ergo.ui.StoneMaker;
import ergo.ui.TimerCanvas;
import ergo.util.Debug;
import ergo.util.Position;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.MouseListener;

class StatusPanel
extends Panel
implements Optionizable {
    private static Optionizer opser = Ergo.opser;
    private Insets insets = new Insets(5, 5, 5, 5);
    private boolean tallConfiguration = true;
    private int spacing = 10;
    private short margin = (short)4;
    private short indent = (short)10;
    private String statusString = "Status font";
    private Font statusFont;
    private FontMetrics metrics;
    private int lineHeight;
    private PlayerStatusCanvas blackStatus;
    private PlayerStatusCanvas whiteStatus;
    private CurrentMoveCanvas currentMove;
    private MessagesCanvas messages;
    private GameStatusCanvas gstatus;
    private TimerCanvas blackTimer;
    private TimerCanvas whiteTimer;
    private Panel blackPanel = new BorderPanel();
    private Panel whitePanel = new BorderPanel();
    private GameWindow gwin;
    private Position ko = null;
    private MouseListener popupControl;
    private Panel browser;
    private Image blarge;
    private Image wlarge;
    private Image bsmall;
    private Image wsmall;
    private Image btiny;
    private Image wtiny;

    public StatusPanel(GameWindow gameWindow, Panel panel, MouseListener mouseListener2, boolean bl, SimpleServerConnection simpleServerConnection) {
        this.gwin = gameWindow;
        this.browser = panel;
        this.popupControl = mouseListener2;
        this.tallConfiguration = bl;
        try {
            opser.expressOwnership(this.statusString, 5, this, null);
            this.statusFont = opser.getFontOption(this.statusString);
            opser.expressOwnership("Game Window Background Color", 4, this, new ColorSpec("255 255 230"));
            this.setBackground(opser.getColorOption("Game Window Background Color"));
        }
        catch (Exception exception) {
            Debug.backtrace(exception);
        }
        this.metrics = this.getFontMetrics(this.statusFont);
        this.lineHeight = this.metrics.getHeight();
        this.blackTimer = new TimerCanvas(simpleServerConnection, this.gwin.ourColor() == 1);
        this.whiteTimer = new TimerCanvas(simpleServerConnection, this.gwin.ourColor() == 0);
        this.blackStatus = new PlayerStatusCanvas(0);
        this.whiteStatus = new PlayerStatusCanvas(1);
        this.currentMove = new CurrentMoveCanvas();
        this.messages = new MessagesCanvas();
        this.gstatus = new GameStatusCanvas();
        this.blarge = this.makeStoneImage(0, this.blackTimer.getStoneDiameter());
        this.wlarge = this.makeStoneImage(1, this.whiteTimer.getStoneDiameter());
        this.bsmall = this.makeStoneImage(0, this.lineHeight + 2);
        this.wsmall = this.makeStoneImage(1, this.lineHeight + 2);
        this.btiny = this.makeStoneImage(0, this.lineHeight - 2);
        this.wtiny = this.makeStoneImage(1, this.lineHeight - 2);
        this.blackTimer.addMouseListener(mouseListener2);
        this.whiteTimer.addMouseListener(mouseListener2);
        this.blackStatus.addMouseListener(mouseListener2);
        this.whiteStatus.addMouseListener(mouseListener2);
        this.currentMove.addMouseListener(mouseListener2);
        this.messages.addMouseListener(mouseListener2);
        this.gstatus.addMouseListener(mouseListener2);
        this.configure();
    }

    private void configure() {
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        ImageLabel imageLabel = new ImageLabel(this.blarge);
        ImageLabel imageLabel2 = new ImageLabel(this.wlarge);
        panel.addMouseListener(this.popupControl);
        panel2.addMouseListener(this.popupControl);
        imageLabel.addMouseListener(this.popupControl);
        imageLabel2.addMouseListener(this.popupControl);
        panel.add(imageLabel);
        panel.add(this.blackTimer);
        this.blackPanel.setLayout(new BorderLayout());
        this.blackPanel.add("North", panel);
        this.blackPanel.add("South", this.blackStatus);
        panel2.add(imageLabel2);
        panel2.add(this.whiteTimer);
        this.whitePanel.setLayout(new BorderLayout());
        this.whitePanel.add("North", panel2);
        this.whitePanel.add("South", this.whiteStatus);
        if (this.tallConfiguration) {
            ColumnLayout columnLayout = new ColumnLayout(1, 5, 2, true);
            this.setLayout(columnLayout);
            this.add(this.blackPanel);
            this.add(this.whitePanel);
            this.add(this.gstatus);
            this.add(this.currentMove);
            this.add(this.messages);
            this.add((Component)this.browser, columnLayout.makeConstraint(2, 0, true));
        } else {
            RowLayout rowLayout = new RowLayout(1, 5, 2, true);
            this.setLayout(rowLayout);
            Panel panel3 = new Panel();
            panel3.setLayout(new BorderLayout());
            panel3.add("North", this.blackPanel);
            panel3.add("South", this.whitePanel);
            BorderPanel borderPanel = new BorderPanel();
            ColumnLayout columnLayout = new ColumnLayout(1, 0, 2, true);
            borderPanel.setLayout(columnLayout);
            borderPanel.add(this.gstatus);
            borderPanel.add(this.currentMove);
            borderPanel.add(this.messages);
            this.add(panel3);
            this.add(borderPanel);
            this.add(this.browser);
        }
    }

    public void setConfiguration(boolean bl) {
        if (bl != this.tallConfiguration) {
            this.tallConfiguration = bl;
            this.configure();
        }
    }

    public void commitSuicide() {
        this.blackTimer.commitSuicide();
        this.whiteTimer.commitSuicide();
    }

    public Insets getInsets() {
        return this.insets;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.blackPanel.getPreferredSize();
        Dimension dimension2 = this.whitePanel.getPreferredSize();
        Dimension dimension3 = this.currentMove.getPreferredSize();
        Dimension dimension4 = this.messages.getPreferredSize();
        Dimension dimension5 = this.gstatus.getPreferredSize();
        if (this.tallConfiguration) {
            return new Dimension(this.insets.left + Math.max(Math.max(dimension.width, dimension2.width), Math.max(dimension3.width, dimension4.width)) + this.insets.right, this.insets.top + dimension.height + this.spacing + dimension2.height + this.spacing + dimension3.height + this.spacing + dimension4.height + this.spacing + dimension5.height + this.insets.bottom);
        }
        return new Dimension(this.insets.left + Math.max(dimension.width, dimension2.width) + this.spacing + Math.max(dimension3.width, dimension4.width) + this.insets.right, this.insets.top + Math.max(Math.max(dimension.height + dimension2.height, dimension3.height + dimension4.height + dimension5.height), this.browser.getPreferredSize().height) + this.insets.bottom);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void optionEvent(String string, Object object) {
        if (opser.isSameKey(string, this.statusString)) {
            this.statusFont = (Font)object;
            this.setFont(this.statusFont);
        } else if (opser.isSameKey(string, "Game Window Background Color")) {
            this.setBackground(opser.getColorOption("Game Window Background Color"));
            this.repaint();
        }
    }

    public void refresh() {
        this.blackStatus.repaint();
        this.whiteStatus.repaint();
        this.gstatus.repaint();
        this.currentMove.repaint();
        this.messages.repaint();
    }

    public void setKoPosition(Position position) {
        this.ko = position;
        this.whiteStatus.repaint();
    }

    private TimerCanvas playerTimer(int n) {
        switch (n) {
            case 0: {
                return this.blackTimer;
            }
            case 1: {
                return this.whiteTimer;
            }
        }
        return null;
    }

    public void setTime(int n, int n2, int n3) {
        TimerCanvas timerCanvas = this.playerTimer(n);
        if (timerCanvas != null) {
            timerCanvas.setTime(n2, n3);
        }
    }

    public void stopTicking(int n) {
        TimerCanvas timerCanvas = this.playerTimer(n);
        if (timerCanvas != null) {
            timerCanvas.stopTicking();
        }
    }

    public void startTicking(int n) {
        TimerCanvas timerCanvas = this.playerTimer(n);
        if (timerCanvas != null) {
            timerCanvas.startTicking();
        }
    }

    public void stopTicking() {
        this.stopTicking(0);
        this.stopTicking(1);
    }

    private Image makeStoneImage(int n, int n2) {
        int n3 = opser.getIntegerOption("Board Style");
        int n4 = n3 == 1 ? OodInnaBox.getAverageColor() : opser.getColorOption("Board Color").getRGB();
        int n5 = opser.getIntegerOption("Stone Style");
        RawImage rawImage = StoneMaker.makeStoneImage(n, false, n2, n5, n4, 0.0);
        return this.createImage(rawImage.mis());
    }

    class GameStatusCanvas
    extends ErgoCanvas {
        GameStatusCanvas() {
        }

        public void paint(Graphics graphics) {
            this.update(graphics);
        }

        public void update(Graphics graphics) {
            if (this.getSize().height != this.height || this.getSize().width != this.width) {
                this.width = this.getSize().width;
                this.height = this.getSize().height;
            }
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.width, this.height);
            graphics.setColor(this.getForeground());
            int n = StatusPanel.this.metrics.getHeight();
            int n2 = StatusPanel.this.margin + StatusPanel.this.metrics.getAscent();
            int n3 = n2 + n;
            int n4 = n3 + n;
            graphics.drawString("Handicap: " + ((StatusPanel)StatusPanel.this).gwin.game.handicap(), (int)StatusPanel.this.margin, n2);
            graphics.drawString("Komi: " + ((StatusPanel)StatusPanel.this).gwin.game.komi(), (int)StatusPanel.this.margin, n3);
            int n5 = ((StatusPanel)StatusPanel.this).gwin.game.byotime();
            graphics.drawString("Byo-yomi: " + (n5 == -1 ? "None" : "" + n5), (int)StatusPanel.this.margin, n4);
        }

        public Dimension getPreferredSize() {
            return new Dimension(StatusPanel.this.metrics.stringWidth("My dog has fleas."), StatusPanel.this.metrics.getHeight() * 3 + StatusPanel.this.margin * 2);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    class MessagesCanvas
    extends ErgoCanvas {
        MessagesCanvas() {
        }

        public void paint(Graphics graphics) {
            this.update(graphics);
        }

        public void update(Graphics graphics) {
            if (this.getSize().height != this.height || this.getSize().width != this.width) {
                this.width = this.getSize().width;
                this.height = this.getSize().height;
            }
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.width, this.height);
            graphics.setColor(this.getForeground());
            int n = StatusPanel.this.metrics.getHeight();
            int n2 = StatusPanel.this.margin + StatusPanel.this.metrics.getAscent();
            int n3 = n2 + n;
            int n4 = n2 + n / 2;
            if (((StatusPanel)StatusPanel.this).gwin.game.scoringMode()) {
                int n5 = ((StatusPanel)StatusPanel.this).gwin.game.blackTerritory();
                int n6 = ((StatusPanel)StatusPanel.this).gwin.game.whiteTerritory();
                int n7 = ((StatusPanel)StatusPanel.this).gwin.game.capturedBlack();
                int n8 = ((StatusPanel)StatusPanel.this).gwin.game.capturedWhite();
                double d = ((StatusPanel)StatusPanel.this).gwin.game.komi();
                String string = n5 + "+" + n8 + "=" + (n5 + n8);
                String string2 = n6 + "+" + n7 + "+" + d + "=" + ((double)(n6 + n7) + d);
                graphics.drawImage(StatusPanel.this.btiny, StatusPanel.this.margin, StatusPanel.this.margin, this);
                graphics.drawString(string, StatusPanel.this.margin + StatusPanel.this.btiny.getWidth(this) + 5, n2);
                graphics.drawImage(StatusPanel.this.wtiny, StatusPanel.this.margin, this.height - StatusPanel.this.wtiny.getHeight(this) - StatusPanel.this.margin, this);
                graphics.drawString(string2, StatusPanel.this.margin + StatusPanel.this.wtiny.getWidth(this) + 5, n3);
            } else if (((StatusPanel)StatusPanel.this).gwin.gameStatus == 1) {
                graphics.setColor(Color.red);
                graphics.drawString("Adjourned", this.width / 2 - StatusPanel.this.metrics.stringWidth("Adjourned") / 2, n4);
            } else if (((StatusPanel)StatusPanel.this).gwin.gameStatus == 2) {
                graphics.setColor(Color.red);
                graphics.drawString("Game Over", this.width / 2 - StatusPanel.this.metrics.stringWidth("Game Over") / 2, n2);
                String string = ((StatusPanel)StatusPanel.this).gwin.game.SGFresult();
                graphics.drawString(string, this.width / 2 - StatusPanel.this.metrics.stringWidth(string) / 2, n3);
            } else if (((StatusPanel)StatusPanel.this).gwin.game.isFree()) {
                graphics.setColor(Color.red);
                String string = "FREE GAME";
                graphics.drawString(string, this.width / 2 - StatusPanel.this.metrics.stringWidth(string) / 2, n4);
                graphics.setColor(this.getForeground());
            }
            graphics.setColor(this.getForeground());
        }

        public Dimension getPreferredSize() {
            return new Dimension(StatusPanel.this.metrics.stringWidth("My dog has fleas."), StatusPanel.this.metrics.getHeight() * 2 + StatusPanel.this.margin * 2);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    class CurrentMoveCanvas
    extends ErgoCanvas {
        private String widthString = "#123  C19  (Ko @ C18)";

        CurrentMoveCanvas() {
        }

        public void paint(Graphics graphics) {
            this.needsRedisplay = true;
            this.update(graphics);
        }

        public void update(Graphics graphics) {
            if (this.getSize().height != this.height || this.getSize().width != this.width) {
                this.width = this.getSize().width;
                this.height = this.getSize().height;
            }
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.width, this.height);
            graphics.setColor(this.getForeground());
            int n = StatusPanel.this.margin + StatusPanel.this.metrics.getAscent();
            Move move = ((StatusPanel)StatusPanel.this).gwin.game.getCurrentMove();
            if (move.moveNumber() < 0) {
                graphics.drawString("---", (int)StatusPanel.this.margin, n);
            } else if (move instanceof GameResultMove) {
                graphics.drawString(move.toString(), (int)StatusPanel.this.margin, n);
            } else {
                String string = "#" + (move.moveNumber() + 1) + " ";
                int n2 = StatusPanel.this.margin;
                graphics.drawString(string, n2, n);
                Image image = move.color() == 0 ? StatusPanel.this.bsmall : StatusPanel.this.wsmall;
                graphics.drawImage(image, n2 += StatusPanel.this.metrics.stringWidth(string), n - StatusPanel.this.metrics.getAscent(), this);
                graphics.drawString(move.toString() + (StatusPanel.this.ko == null ? "" : " (Ko @ " + StatusPanel.this.ko + ")"), n2 += image.getWidth(this) + 5, n);
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(StatusPanel.this.metrics.stringWidth(this.widthString) + StatusPanel.this.margin * 2 + StatusPanel.this.bsmall.getWidth(this), StatusPanel.this.metrics.getHeight() + StatusPanel.this.margin * 2);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    class PlayerStatusCanvas
    extends ErgoCanvas {
        private int player;
        private String widthString = "Prisoners: 999";

        PlayerStatusCanvas(int n) {
            this.player = n;
            this.setFont(StatusPanel.this.statusFont);
        }

        public void paint(Graphics graphics) {
            this.needsRedisplay = true;
            this.update(graphics);
        }

        public void update(Graphics graphics) {
            if (this.getSize().height != this.height || this.getSize().width != this.width) {
                this.width = this.getSize().width;
                this.height = this.getSize().height;
            }
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.width, this.height);
            graphics.setColor(this.getForeground());
            int n = StatusPanel.this.margin + StatusPanel.this.metrics.getAscent();
            short s = StatusPanel.this.margin;
            int n2 = 0;
            boolean bl = this.player == 0;
            n2 = bl ? ((StatusPanel)StatusPanel.this).gwin.game.capturedWhite() : ((StatusPanel)StatusPanel.this).gwin.game.capturedBlack();
            graphics.drawString("Prisoners: " + n2, (int)s, n);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension();
            dimension.width = StatusPanel.this.metrics.stringWidth(this.widthString) + StatusPanel.this.indent;
            dimension.height = StatusPanel.this.metrics.getHeight();
            dimension.height += StatusPanel.this.margin * 2;
            return dimension;
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    class BorderPanel
    extends Panel
    implements Optionizable {
        BorderPanel() {
            try {
                opser.expressOwnership("Game Window Background Color", 4, this, new ColorSpec("255 255 230"));
                this.setBackground(opser.getColorOption("Game Window Background Color"));
            }
            catch (Exception exception) {
                Debug.backtrace(exception);
            }
        }

        public Insets getInsets() {
            return new Insets(3, 3, 3, 3);
        }

        public void optionEvent(String string, Object object) {
            if (opser.isSameKey(string, "Game Window Background Color")) {
                this.setBackground(opser.getColorOption("Game Window Background Color"));
                this.repaint();
            }
        }

        public void paint(Graphics graphics) {
            this.update(graphics);
        }

        public void update(Graphics graphics) {
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n - 1, n2 - 1);
            graphics.setColor(this.getForeground());
            graphics.drawRect(1, 1, n - 2, n2 - 2);
        }
    }
}

