/*
 * Decompiled with CFR 0.152.
 */
package ergo.ui;

import ergo.ui.ColorSpec;
import ergo.ui.Optionizable;
import ergo.ui.Optionizer;
import ergo.util.Debug;
import ergo.util.ParseException;
import java.awt.Color;

public class TextColorManager {
    private static Optionizer opser;
    public static Optionizable[] targets;

    public static void setOpser(Optionizer optionizer) {
        opser = optionizer;
    }

    public static Color[] getColorVec() {
        Color[] colorArray = new Color[]{opser.getColorOption(TextColorManager.opser.textcolString), opser.getColorOption(TextColorManager.opser.textbackString), opser.getColorOption(TextColorManager.opser.texthighString), opser.getColorOption(TextColorManager.opser.texthighbackString)};
        return colorArray;
    }

    public static void expressAll(Optionizable optionizable, int n) {
        for (int i = 0; i < 4; ++i) {
            TextColorManager.targets[i] = i < n ? optionizable : null;
        }
        try {
            opser.expressOwnership(TextColorManager.opser.textcolString, 4, targets[0], new ColorSpec("System.textText"));
            opser.expressOwnership(TextColorManager.opser.textbackString, 4, targets[1], new ColorSpec("System.window"));
            opser.expressOwnership(TextColorManager.opser.texthighString, 4, targets[2], new ColorSpec("System.textHighlightText"));
            opser.expressOwnership(TextColorManager.opser.texthighbackString, 4, targets[3], new ColorSpec("System.textHighlight"));
        }
        catch (ParseException parseException) {
            Debug.backtrace(parseException);
        }
    }

    public static boolean isColorString(String string) {
        return opser.isSameKey(string, TextColorManager.opser.textcolString) || opser.isSameKey(string, TextColorManager.opser.textbackString) || opser.isSameKey(string, TextColorManager.opser.texthighString) || opser.isSameKey(string, TextColorManager.opser.texthighbackString);
    }

    static {
        targets = new Optionizable[4];
    }
}

