/*
 * Decompiled with CFR 0.152.
 */
package ergo.util;

import ergo.util.ParseException;
import java.util.Vector;

public class ParsedMessage {
    public String message;
    public int endIndex = 0;
    private char escapeChar = (char)37;
    private Vector fields = new Vector();

    public ParsedMessage(String string, String string2) throws ParseException {
        this.parse(string, string2, Integer.MAX_VALUE);
    }

    public ParsedMessage(String string, String string2, int n) throws ParseException {
        this.parse(string, string2, n);
    }

    public ParsedMessage(String string, String string2, int n, char c) throws ParseException {
        this(string, string2, n);
        this.escapeChar = c;
    }

    public char escapeChar() {
        return this.escapeChar;
    }

    private void parse(String string, String string2, int n) throws ParseException {
        this.message = string;
        int n2 = string.length();
        int n3 = string2.length();
        int n4 = this.endIndex;
        int n5 = 0;
        boolean bl = false;
        while (this.fields.size() < n) {
            if (n4 >= n2 || n5 >= n3) {
                if (n >= Integer.MAX_VALUE || this.fields.size() >= n) break;
                throw new ParseException("Too few fields parsed");
            }
            char c = string.charAt(n4);
            char c2 = string2.charAt(n5);
            int n6 = n4++;
            boolean bl2 = false;
            if (c2 == this.escapeChar) {
                if (bl) {
                    if (c2 != c) {
                        throw new ParseException("No Match at " + n4 + ".  Expected '" + c2 + "'.  Got '" + c + "'.");
                    }
                } else {
                    bl = true;
                }
            } else if (!bl) {
                if (c2 == ' ') {
                    while (n4 < n2 && Character.isWhitespace(string.charAt(n4))) {
                        ++n4;
                    }
                } else {
                    if (c2 != c) {
                        throw new ParseException("No match at " + n4 + ".  Expected '" + c2 + "'.  Got '" + c + "'.");
                    }
                    ++n4;
                }
                bl = false;
            } else {
                switch (c2) {
                    case 'i': {
                        bl2 = true;
                        while (n4 < n2 && (Character.isDigit(c = string.charAt(n4)) || bl2 && c == '-')) {
                            bl2 = false;
                            ++n4;
                        }
                        if (n6 == n4) {
                            throw new ParseException("No match at " + n4 + ".  Integer expected.");
                        }
                        try {
                            this.fields.addElement(new Integer(string.substring(n6, n4)));
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new ParseException("No match at " + n4 + ".  Integer expected.");
                        }
                    }
                    case 'f': {
                        bl2 = true;
                        while (n4 < n2 && (Character.isDigit(c = string.charAt(n4)) || c == '.' || bl2 && c == '-')) {
                            bl2 = false;
                            ++n4;
                        }
                        if (n6 == n4) {
                            throw new ParseException("No match at " + n4 + ".  Simple float expected.");
                        }
                        try {
                            this.fields.addElement(new Double(string.substring(n6, n4)));
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new ParseException("No match at " + n4 + ".  Integer expected.");
                        }
                    }
                    case 'c': {
                        this.fields.addElement(new Character(c));
                        ++n4;
                        break;
                    }
                    case 'a': {
                        while (n4 < n2 && Character.isLetterOrDigit(string.charAt(n4))) {
                            ++n4;
                        }
                        if (n6 == n4) {
                            throw new ParseException("No match at " + n4 + ".  Alphanumeric expected.");
                        }
                        this.fields.addElement(string.substring(n6, n4));
                        break;
                    }
                    case 's': {
                        while (n4 < n2 && !Character.isWhitespace(string.charAt(n4))) {
                            ++n4;
                        }
                        if (n6 == n4) {
                            throw new ParseException("No match at " + n4 + ".  Non-whitespace string expected.");
                        }
                        this.fields.addElement(string.substring(n6, n4));
                        break;
                    }
                    case 'w': {
                        while (n4 < n2 && (Character.isLetterOrDigit(c = string.charAt(n4)) || c == '*')) {
                            ++n4;
                        }
                        if (n6 == n4) {
                            throw new ParseException("No match at " + n4 + ".  Word expected.");
                        }
                        this.fields.addElement(string.substring(n6, n4));
                        break;
                    }
                    case ' ': {
                        if (c != ' ') {
                            throw new ParseException("No match at " + n4 + ".  Expected ' ', got '" + c + "'.");
                        }
                        ++n4;
                        break;
                    }
                    case 'r': {
                        this.fields.addElement(string.substring(n4));
                        n4 = n2;
                        break;
                    }
                    default: {
                        throw new ParseException("Unrecognized escape sequence: " + this.escapeChar + c2);
                    }
                }
                bl = false;
            }
            ++n5;
        }
        this.endIndex = n4;
    }

    public String stringAt(int n) throws ParseException {
        Object object = this.matchAt(n);
        return object.toString();
    }

    public int intAt(int n) throws ParseException {
        Object object = this.matchAt(n);
        if (!(object instanceof Integer)) {
            throw new ParseException("Illegal field access - not an Integer.");
        }
        return (Integer)object;
    }

    public double doubleAt(int n) throws ParseException {
        Object object = this.matchAt(n);
        if (!(object instanceof Double)) {
            throw new ParseException("Illegal field access - not a Double.");
        }
        return (Double)object;
    }

    public Object matchAt(int n) throws ParseException {
        if (n >= this.fields.size()) {
            throw new ParseException("Illegal field access - asked for " + n + ".");
        }
        return this.fields.elementAt(n);
    }

    public void continueParse(String string) throws ParseException {
        this.parse(this.message, string, Integer.MAX_VALUE);
    }

    public ParsedMessage continueParseQuietly(String string) {
        try {
            this.parse(this.message, string, Integer.MAX_VALUE);
            return this;
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void continueParse(String string, int n) throws ParseException {
        this.parse(this.message, string, n);
    }

    public String rest() {
        return this.message.substring(this.endIndex);
    }

    public String message() {
        return this.message;
    }

    public int endIndex() {
        return this.endIndex;
    }
}

