/*
 * Decompiled with CFR 0.152.
 */
package ergo.util;

import ergo.util.Position;
import ergo.util.PositionVector;

public class SimpleGroup {
    private int color;
    private PositionVector positions = new PositionVector();
    protected PositionVector liberties = new PositionVector(4);

    public int size() {
        return this.positions.size();
    }

    public int color() {
        return this.color;
    }

    public boolean isMember(Position position) {
        for (int i = 0; i < this.positions.size(); ++i) {
            if (!position.equals(this.positions.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public Position positionAt(int n) {
        return this.positions.elementAt(n);
    }

    public SimpleGroup(int n) {
        this.color = n;
    }

    public int numberOfLiberties() {
        return this.liberties.size();
    }

    public void addPosition(Position position) {
        if (this.isLiberty(position)) {
            this.removeLiberty(position);
        }
        if (!this.isMember(position)) {
            this.positions.addElement(position);
        }
    }

    public void removePosition(Position position) {
        for (int i = 0; i < this.positions.size(); ++i) {
            if (!this.positions.elementAt(i).equals(position)) continue;
            this.positions.removeElementAt(i);
            this.addLiberty(position);
        }
    }

    public void addLiberty(Position position) {
        if (!this.isLiberty(position)) {
            this.liberties.addElement(position);
        }
    }

    public void removeLiberty(Position position) {
        for (int i = 0; i < this.liberties.size(); ++i) {
            if (!position.equals(this.liberties.elementAt(i))) continue;
            this.liberties.removeElementAt(i);
            return;
        }
    }

    public Position libertyAt(int n) {
        return this.liberties.elementAt(n);
    }

    public boolean isLiberty(Position position) {
        for (int i = 0; i < this.liberties.size(); ++i) {
            if (!position.equals(this.liberties.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return (this.color == 0 ? "Black: " : "White: ") + this.positions.toString() + " -- " + this.liberties.toString();
    }

    public boolean equals(SimpleGroup simpleGroup) {
        int n;
        if (this.numberOfLiberties() != simpleGroup.numberOfLiberties() || this.size() != simpleGroup.size()) {
            return false;
        }
        for (n = 0; n < this.positions.size(); ++n) {
            if (simpleGroup.isMember(this.positions.elementAt(n))) continue;
            return false;
        }
        for (n = 0; n < this.liberties.size(); ++n) {
            if (simpleGroup.isLiberty(this.liberties.elementAt(n))) continue;
            return false;
        }
        return true;
    }
}

