/*
 * Decompiled with CFR 0.152.
 */
package nom.rb.common;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import nom.rb.common.MosaicLayout;
import nom.rb.common.MosaicNode;
import nom.rb.common.MosaicSlice;

final class MosaicInteriorNode
extends MosaicNode {
    protected int m_cols = 0;
    protected int m_rows = 0;
    protected MosaicSlice[] m_col = null;
    protected MosaicSlice[] m_row = null;
    protected MosaicNode[][] m_node = null;
    protected int m_sashSize = 0;
    protected int m_activeColSash = 0;
    protected int m_activeRowSash = 0;
    protected int m_colSashOfs = 0;
    protected int m_rowSashOfs = 0;

    protected MosaicInteriorNode(MosaicLayout mosaicLayout) {
        super(mosaicLayout);
    }

    protected void initializeGeometry() {
        int n;
        this.m_minSize = new Dimension(0, 0);
        this.m_prefSize = new Dimension(0, 0);
        this.m_weightx = 0.0;
        this.m_weighty = 0.0;
        if (this.m_cols == 0 || this.m_rows == 0) {
            this.m_size = new Dimension(0, 0);
            return;
        }
        this.m_col = new MosaicSlice[this.m_cols];
        this.m_row = new MosaicSlice[this.m_rows];
        for (n = 0; n < this.m_rows; ++n) {
            this.m_row[n] = new MosaicSlice();
        }
        for (int i = 0; i < this.m_cols; ++i) {
            this.m_col[i] = new MosaicSlice();
            for (n = 0; n < this.m_rows; ++n) {
                MosaicNode mosaicNode = this.m_node[i][n];
                if (mosaicNode == null) continue;
                mosaicNode.initializeGeometry();
                this.m_col[i].expand(mosaicNode.m_minSize.width, mosaicNode.m_prefSize.width);
                this.m_row[n].expand(mosaicNode.m_minSize.height, mosaicNode.m_prefSize.height);
            }
        }
        this.adjustWeight();
        this.createSashes();
        this.m_size = new Dimension(this.m_prefSize);
    }

    protected void adjustWeight() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.m_cols; ++n2) {
            for (n = 0; n < this.m_rows; ++n) {
                MosaicNode mosaicNode = this.m_node[n2][n];
                if (mosaicNode == null) continue;
                this.m_col[n2].m_weight += mosaicNode.m_weightx * (double)mosaicNode.m_prefSize.width;
                this.m_row[n].m_weight += mosaicNode.m_weighty * (double)mosaicNode.m_prefSize.height;
            }
        }
        for (n2 = 0; n2 < this.m_cols; ++n2) {
            this.m_col[n2].m_size = this.m_col[n2].m_prefSize;
            this.m_minSize.width += this.m_col[n2].m_minSize;
            this.m_prefSize.width += this.m_col[n2].m_prefSize;
            if (this.m_col[n2].m_sizeSum > 1) {
                this.m_col[n2].m_weight /= (double)this.m_col[n2].m_sizeSum;
            }
            this.m_weightx += this.m_col[n2].m_weight;
        }
        if (this.m_weightx == 0.0) {
            for (n2 = 0; n2 < this.m_cols; ++n2) {
                this.m_col[n2].m_weight = 1.0 / (double)this.m_cols;
            }
        } else {
            for (n2 = 0; n2 < this.m_cols; ++n2) {
                this.m_col[n2].m_weight /= this.m_weightx;
            }
        }
        for (n = 0; n < this.m_rows; ++n) {
            this.m_row[n].m_size = this.m_row[n].m_prefSize;
            this.m_minSize.height += this.m_row[n].m_minSize;
            this.m_prefSize.height += this.m_row[n].m_prefSize;
            if (this.m_row[n].m_sizeSum > 1) {
                this.m_row[n].m_weight /= (double)this.m_row[n].m_sizeSum;
            }
            this.m_weighty += this.m_row[n].m_weight;
        }
        if (this.m_weighty == 0.0) {
            for (n = 0; n < this.m_rows; ++n) {
                this.m_row[n].m_weight = 1.0 / (double)this.m_rows;
            }
        } else {
            for (n = 0; n < this.m_rows; ++n) {
                this.m_row[n].m_weight /= this.m_weighty;
            }
        }
    }

    protected void createSashes() {
        this.m_sashSize = this.m_layout.getSashSize(this.m_parent == null);
        if (this.m_sashSize == 0) {
            return;
        }
        int n = (this.m_cols - 1) * this.m_sashSize;
        this.m_minSize.width += n;
        this.m_prefSize.width += n;
        n = (this.m_rows - 1) * this.m_sashSize;
        this.m_minSize.height += n;
        this.m_prefSize.height += n;
    }

    protected void finalizeGeometry(int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        int n6;
        int n7;
        this.m_orgx = n;
        this.m_orgy = n2;
        Dimension dimension = new Dimension(n3, n4);
        if (this.m_cols > 0) {
            if (n3 <= this.m_minSize.width) {
                for (n7 = 0; n7 < this.m_cols; ++n7) {
                    this.m_col[n7].m_size = this.m_col[n7].m_minSize;
                }
                dimension.width = this.m_minSize.width;
            } else {
                n6 = n3 - this.m_size.width;
                if (n6 > 0) {
                    this.distributeExtraSpace(n6, this.m_cols, this.m_col);
                } else if (n6 < 0) {
                    this.collectExtraSpace(-n6, this.m_cols, this.m_col);
                }
            }
            this.m_col[0].m_org = this.m_orgx;
            for (n7 = 1; n7 < this.m_cols; ++n7) {
                this.m_col[n7].m_org = this.m_col[n7 - 1].m_org + this.m_col[n7 - 1].m_size + this.m_sashSize;
            }
        }
        if (this.m_rows > 0) {
            if (n4 <= this.m_minSize.height) {
                for (n5 = 0; n5 < this.m_rows; ++n5) {
                    this.m_row[n5].m_size = this.m_row[n5].m_minSize;
                }
                dimension.height = this.m_minSize.height;
            } else {
                n6 = n4 - this.m_size.height;
                if (n6 > 0) {
                    this.distributeExtraSpace(n6, this.m_rows, this.m_row);
                } else if (n6 < 0) {
                    this.collectExtraSpace(-n6, this.m_rows, this.m_row);
                }
            }
            this.m_row[0].m_org = this.m_orgy;
            for (n5 = 1; n5 < this.m_rows; ++n5) {
                this.m_row[n5].m_org = this.m_row[n5 - 1].m_org + this.m_row[n5 - 1].m_size + this.m_sashSize;
            }
        }
        this.m_size = dimension;
        for (n7 = 0; n7 < this.m_cols; ++n7) {
            for (n5 = 0; n5 < this.m_rows; ++n5) {
                if (this.m_node[n7][n5] == null) continue;
                this.m_node[n7][n5].finalizeGeometry(this.m_col[n7].m_org, this.m_row[n5].m_org, this.m_col[n7].m_size, this.m_row[n5].m_size, bl);
            }
        }
    }

    protected void distributeExtraSpace(int n, int n2, MosaicSlice[] mosaicSliceArray) {
        int n3;
        int n4;
        int n5 = n;
        while (n5 > 0) {
            n = n5;
            double d = 0.0;
            for (n4 = 0; n4 < n2; ++n4) {
                if (mosaicSliceArray[n4].m_size >= mosaicSliceArray[n4].m_prefSize) continue;
                d += mosaicSliceArray[n4].m_weight;
            }
            if (d == 0.0) break;
            for (n4 = 0; n4 < n2; ++n4) {
                if (mosaicSliceArray[n4].m_size >= mosaicSliceArray[n4].m_prefSize || !(mosaicSliceArray[n4].m_weight > 0.0)) continue;
                n3 = (int)Math.ceil(mosaicSliceArray[n4].m_weight / d * (double)n);
                if (n3 > n5) {
                    n3 = n5;
                }
                if (mosaicSliceArray[n4].m_size + n3 > mosaicSliceArray[n4].m_prefSize) {
                    n3 = mosaicSliceArray[n4].m_prefSize - mosaicSliceArray[n4].m_size;
                }
                mosaicSliceArray[n4].m_size += n3;
                n5 -= n3;
            }
        }
        if (n5 > 0) {
            n = n5;
            for (n4 = 0; n4 < n2; ++n4) {
                n3 = (int)Math.ceil(mosaicSliceArray[n4].m_weight * (double)n);
                if (n3 > n5) {
                    n3 = n5;
                }
                mosaicSliceArray[n4].m_size += n3;
                n5 -= n3;
            }
        }
    }

    protected void collectExtraSpace(int n, int n2, MosaicSlice[] mosaicSliceArray) {
        int n3;
        int n4;
        double d;
        int n5 = n;
        while (n5 > 0) {
            n = n5;
            d = 0.0;
            for (n4 = 0; n4 < n2; ++n4) {
                if (mosaicSliceArray[n4].m_size <= mosaicSliceArray[n4].m_prefSize) continue;
                d += mosaicSliceArray[n4].m_weight;
            }
            if (d == 0.0) break;
            for (n4 = 0; n4 < n2; ++n4) {
                if (mosaicSliceArray[n4].m_size <= mosaicSliceArray[n4].m_prefSize || !(mosaicSliceArray[n4].m_weight > 0.0)) continue;
                n3 = (int)Math.ceil(mosaicSliceArray[n4].m_weight / d * (double)n);
                if (n3 > n5) {
                    n3 = n5;
                }
                if (mosaicSliceArray[n4].m_size - n3 < mosaicSliceArray[n4].m_prefSize) {
                    n3 = mosaicSliceArray[n4].m_size - mosaicSliceArray[n4].m_prefSize;
                }
                mosaicSliceArray[n4].m_size -= n3;
                n5 -= n3;
            }
        }
        while (n5 > 0) {
            n = n5;
            d = 0.0;
            for (n4 = 0; n4 < n2; ++n4) {
                if (mosaicSliceArray[n4].m_size <= mosaicSliceArray[n4].m_minSize) continue;
                d += mosaicSliceArray[n4].m_weight;
            }
            if (d == 0.0) break;
            for (n4 = 0; n4 < n2; ++n4) {
                if (mosaicSliceArray[n4].m_size <= mosaicSliceArray[n4].m_minSize || !(mosaicSliceArray[n4].m_weight > 0.0)) continue;
                n3 = (int)Math.ceil(mosaicSliceArray[n4].m_weight / d * (double)n);
                if (n3 > n5) {
                    n3 = n5;
                }
                if (mosaicSliceArray[n4].m_size - n3 < mosaicSliceArray[n4].m_minSize) {
                    n3 = mosaicSliceArray[n4].m_size - mosaicSliceArray[n4].m_minSize;
                }
                mosaicSliceArray[n4].m_size -= n3;
                n5 -= n3;
            }
        }
        while (n5 > 0) {
            int n6 = 0;
            for (n4 = 0; n4 < n2; ++n4) {
                if (mosaicSliceArray[n4].m_size <= mosaicSliceArray[n4].m_minSize) continue;
                ++n6;
            }
            int n7 = (n5 + n6 - 1) / n6;
            for (n4 = 0; n4 < n2; ++n4) {
                if (mosaicSliceArray[n4].m_size <= mosaicSliceArray[n4].m_minSize) continue;
                n3 = Math.min(n5, n7);
                if (mosaicSliceArray[n4].m_size - n3 < mosaicSliceArray[n4].m_minSize) {
                    n3 = mosaicSliceArray[n4].m_size - mosaicSliceArray[n4].m_minSize;
                }
                mosaicSliceArray[n4].m_size -= n3;
                n5 -= n3;
            }
        }
    }

    protected MosaicInteriorNode ensureCapacity(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = 3 * ((this.m_cols + 2) / 3);
        if (this.m_cols <= n) {
            this.m_cols = n5 = n + 1;
            n4 = 3 * ((n5 + 2) / 3);
        } else {
            n4 = n6;
        }
        int n7 = 3 * ((this.m_rows + 2) / 3);
        if (this.m_rows <= n2) {
            this.m_rows = n5 = n2 + 1;
            n3 = 3 * ((n5 + 2) / 3);
        } else {
            n3 = n7;
        }
        if (n6 < n4 || n7 < n3) {
            MosaicNode[][] mosaicNodeArray = new MosaicNode[n4][n3];
            for (int i = 0; i < n6; ++i) {
                for (int j = 0; j < n7; ++j) {
                    mosaicNodeArray[i][j] = this.m_node[i][j];
                }
            }
            this.m_node = mosaicNodeArray;
        }
        return this;
    }

    protected void handleEvent(Event event) {
        int n = -1;
        int n2 = -1;
        for (int i = 1; i < this.m_cols; ++i) {
            if (event.x < this.m_col[i].m_org - this.m_sashSize) {
                n2 = i - 1;
                break;
            }
            if (event.x >= this.m_col[i].m_org) continue;
            n = i - 1;
            break;
        }
        if (n2 < 0 && n < 0) {
            n2 = this.m_cols - 1;
        }
        int n3 = -1;
        int n4 = -1;
        for (int i = 1; i < this.m_rows; ++i) {
            if (event.y < this.m_row[i].m_org - this.m_sashSize) {
                n4 = i - 1;
                break;
            }
            if (event.y >= this.m_row[i].m_org) continue;
            n3 = i - 1;
            break;
        }
        if (n4 < 0 && n3 < 0) {
            n4 = this.m_rows - 1;
        }
        if (n2 >= 0 && n4 >= 0) {
            if (this.m_node[n2][n4] != null) {
                this.m_node[n2][n4].handleEvent(event);
            } else {
                this.m_layout.defaultCursor();
            }
            return;
        }
        if (this.m_layout.m_frame != null) {
            int n5 = n >= 0 ? (n3 >= 0 ? this.m_layout.crossSashCursor : this.m_layout.colSashCursor) : this.m_layout.rowSashCursor;
            if (this.m_layout.m_frame.getCursor().getType() != n5) {
                this.m_layout.m_frame.setCursor(Cursor.getPredefinedCursor(n5));
            }
        }
        if (event.id == 501) {
            if (n >= 0) {
                this.m_activeColSash = n + 1;
                this.m_colSashOfs = this.m_col[this.m_activeColSash].m_org - event.x;
            }
            if (n3 >= 0) {
                this.m_activeRowSash = n3 + 1;
                this.m_rowSashOfs = this.m_row[this.m_activeRowSash].m_org - event.y;
            }
            this.m_layout.m_activeNode = this;
        }
    }

    protected void drag(int n, int n2) {
        int n3;
        boolean bl = false;
        if (this.m_activeColSash > 0) {
            n3 = n + this.m_colSashOfs - this.m_col[this.m_activeColSash].m_org;
            if (this.m_col[this.m_activeColSash].m_size - n3 < this.m_col[this.m_activeColSash].m_minSize) {
                n3 = this.m_col[this.m_activeColSash].m_size - this.m_col[this.m_activeColSash].m_minSize;
            } else if (this.m_col[this.m_activeColSash - 1].m_size + n3 < this.m_col[this.m_activeColSash - 1].m_minSize) {
                n3 = this.m_col[this.m_activeColSash - 1].m_minSize - this.m_col[this.m_activeColSash - 1].m_size;
            }
            if (n3 != 0) {
                this.m_col[this.m_activeColSash].m_org += n3;
                this.m_col[this.m_activeColSash].m_size -= n3;
                this.m_col[this.m_activeColSash - 1].m_size += n3;
                bl = true;
            }
        }
        if (this.m_activeRowSash > 0) {
            n3 = n2 + this.m_rowSashOfs - this.m_row[this.m_activeRowSash].m_org;
            if (this.m_row[this.m_activeRowSash].m_size - n3 < this.m_row[this.m_activeRowSash].m_minSize) {
                n3 = this.m_row[this.m_activeRowSash].m_size - this.m_row[this.m_activeRowSash].m_minSize;
            } else if (this.m_row[this.m_activeRowSash - 1].m_size + n3 < this.m_row[this.m_activeRowSash - 1].m_minSize) {
                n3 = this.m_row[this.m_activeRowSash - 1].m_minSize - this.m_row[this.m_activeRowSash - 1].m_size;
            }
            if (n3 != 0) {
                this.m_row[this.m_activeRowSash].m_org += n3;
                this.m_row[this.m_activeRowSash].m_size -= n3;
                this.m_row[this.m_activeRowSash - 1].m_size += n3;
                bl = true;
            }
        }
        if (bl) {
            this.fixDrag(this.m_layout.m_liveDrag);
        }
    }

    protected void releaseSash() {
        if (!this.m_layout.m_liveDrag) {
            this.fixDrag(true);
        }
        this.m_activeColSash = 0;
        this.m_activeRowSash = 0;
        this.m_layout.m_activeNode = null;
    }

    protected void fixDrag(boolean bl) {
        this.m_layout.m_panel.dontPropagateInvalidate();
        for (int i = 0; i < this.m_cols; ++i) {
            for (int j = 0; j < this.m_rows; ++j) {
                if (this.m_node[i][j] == null) continue;
                this.m_node[i][j].finalizeGeometry(this.m_col[i].m_org, this.m_row[j].m_org, this.m_col[i].m_size, this.m_row[j].m_size, bl);
            }
        }
        this.m_layout.m_panel.propagateInvalidate();
        this.m_layout.m_panel.repaint(this.m_orgx, this.m_orgy, this.m_size.width, this.m_size.height);
    }

    protected void paint(Graphics graphics) {
        int n;
        int n2;
        if (this.m_sashSize > 0) {
            for (n2 = 1; n2 < this.m_cols; ++n2) {
                this.paintColSash(this.m_col[n2].m_org - this.m_sashSize, graphics);
            }
            for (n = 1; n < this.m_rows; ++n) {
                int n3 = this.m_row[n].m_org - this.m_sashSize;
                this.paintRowSash(n3, graphics);
                if (this.m_sashSize <= 4) continue;
                for (n2 = 1; n2 < this.m_cols; ++n2) {
                    this.paintCrossSash(this.m_col[n2].m_org - this.m_sashSize, n3, graphics);
                }
            }
        }
        for (n2 = 0; n2 < this.m_cols; ++n2) {
            for (n = 0; n < this.m_rows; ++n) {
                if (this.m_node[n2][n] != null) {
                    this.m_node[n2][n].paint(graphics);
                    continue;
                }
                graphics.clearRect(this.m_col[n2].m_org, this.m_row[n].m_org, this.m_col[n2].m_size, this.m_row[n].m_size);
            }
        }
    }

    protected void paintColSash(int n, Graphics graphics) {
        if (this.m_sashSize <= 4) {
            graphics.setColor(Color.gray);
            graphics.fillRect(n, this.m_orgy, this.m_sashSize, this.m_size.height);
            return;
        }
        int n2 = n + this.m_sashSize - 1;
        int n3 = this.m_orgy + this.m_size.height - 1;
        graphics.setColor(Color.lightGray);
        graphics.fillRect(n, this.m_orgy + 1, this.m_sashSize - 2, this.m_size.height - 1);
        graphics.setColor(Color.white);
        graphics.drawLine(n + 1, this.m_orgy + 1, n + 1, n3 - 1);
        graphics.drawLine(n, this.m_orgy, n2 - 2, this.m_orgy);
        graphics.setColor(Color.gray);
        graphics.drawLine(n2 - 1, this.m_orgy, n2 - 1, n3);
        graphics.drawLine(n, n3, n2 - 2, n3);
        graphics.setColor(Color.black);
        graphics.drawLine(n2, this.m_orgy, n2, n3);
    }

    protected void paintRowSash(int n, Graphics graphics) {
        if (this.m_sashSize <= 4) {
            graphics.setColor(Color.gray);
            graphics.fillRect(this.m_orgx, n, this.m_size.width, this.m_sashSize);
            return;
        }
        int n2 = this.m_orgx + this.m_size.width - 1;
        int n3 = n + this.m_sashSize - 1;
        graphics.setColor(Color.lightGray);
        graphics.fillRect(this.m_orgx + 1, n, this.m_size.width - 1, this.m_sashSize - 2);
        graphics.setColor(Color.white);
        graphics.drawLine(this.m_orgx + 1, n + 1, n2 - 1, n + 1);
        graphics.drawLine(this.m_orgx, n, this.m_orgx, n3 - 2);
        graphics.setColor(Color.gray);
        graphics.drawLine(this.m_orgx, n3 - 1, n2, n3 - 1);
        graphics.drawLine(n2, n, n2, n3 - 2);
        graphics.setColor(Color.black);
        graphics.drawLine(this.m_orgx, n3, n2, n3);
    }

    protected void paintCrossSash(int n, int n2, Graphics graphics) {
        int n3 = n + this.m_sashSize - 1;
        int n4 = n2 + this.m_sashSize - 1;
        graphics.setColor(Color.white);
        graphics.drawLine(n + 1, n2, n + 1, n2);
        graphics.drawLine(n + 1, n4 - 1, n + 1, n4);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(n + 2, n2 + 1, n3 - 2, n2 + 1);
        graphics.fillRect(n + 2, n4 - 1, this.m_sashSize - 4, 2);
        graphics.drawLine(n, n4, n, n4);
        graphics.setColor(Color.gray);
        graphics.drawLine(n3 - 1, n2, n3 - 1, n2);
        graphics.drawLine(n3 - 1, n4, n3 - 1, n4);
    }

    protected void print(String string) {
        System.out.println(string + "interior node cols=" + this.m_cols + " rows=" + this.m_rows);
        super.print(string + "o ");
        for (int i = 0; i < this.m_cols; ++i) {
            for (int j = 0; j < this.m_rows; ++j) {
                if (this.m_node[i][j] == null) continue;
                System.out.println(string + "o child (" + i + "," + j + ")");
                this.m_node[i][j].print(string + "  ");
            }
        }
    }
}

