/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.lang;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import org.unitarou.lang.Log;

public class LogAgency {
    private static final Log defaultLog_s_ = new SysoutLog();
    private static int level_s_ = 2;

    public static Log getLog() {
        return defaultLog_s_;
    }

    public static int getLevel() {
        return level_s_;
    }

    public static void setLevel(int n) {
        if (n < 0 || 4 < n) {
            throw new IllegalArgumentException();
        }
        level_s_ = n;
    }

    private static class SysoutLog
    implements Log {
        private final StringBuffer buffer_ = new StringBuffer();
        private final MessageFormat format_ = new MessageFormat("{0,date,yyyy-MM-dd HH:mm:ss,SSS} [{1,choice,0#TRACE|1#DEBUG|2#INFO|3#WARN|4#ERROR}] {2}");

        private SysoutLog() {
        }

        public void error(Throwable throwable, String string) {
            this.handle(4, string, throwable);
        }

        public void error(String string) {
            this.handle(4, string, null);
        }

        public void warn(Throwable throwable, String string) {
            this.handle(3, string, throwable);
        }

        public void warn(String string) {
            this.handle(3, string, null);
        }

        public void info(Throwable throwable, String string) {
            this.handle(2, string, throwable);
        }

        public void info(String string) {
            this.handle(2, string, null);
        }

        public void debug(Throwable throwable, String string) {
            this.handle(1, string, throwable);
        }

        public void debug(String string) {
            this.handle(1, string, null);
        }

        public boolean isDebugEnabled() {
            return true;
        }

        public void trace(Throwable throwable, String string) {
            this.handle(0, string, throwable);
        }

        public void trace(String string) {
            this.handle(0, string, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handle(int n, String string, Throwable throwable) {
            if (n < level_s_) {
                return;
            }
            SysoutLog sysoutLog = this;
            synchronized (sysoutLog) {
                this.buffer_.setLength(0);
                Object[] objectArray = new Object[]{new Date(), new Integer(n), string};
                this.format_.format(objectArray, this.buffer_, new FieldPosition(0));
                System.out.println(this.buffer_.toString());
                if (throwable != null) {
                    throwable.printStackTrace(System.out);
                }
            }
        }
    }
}

