/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.ml;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Classes;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogAgency;

public class Messages {
    private static final Log logger_s_ = LogAgency.getLog();
    private static final String MESSAGES_NAME = "messages";
    private static final String BAD_PATTERN = "<<BAD PATTERN>>";
    private static final Map messageMap_s_ = new TreeMap();
    private static Locale currentLocale_s_ = Locale.getDefault();
    private final ResourceBundle resourceBundle_;
    private final String bundleName_;
    private final ClassLoader classLoader_;
    private final Set usedKeySet_;
    static /* synthetic */ Class class$org$unitarou$ml$Messages;

    public static Messages create() {
        Messages messages = (Messages)messageMap_s_.get(MESSAGES_NAME);
        if (messages == null) {
            messages = new Messages(MESSAGES_NAME, (class$org$unitarou$ml$Messages == null ? (class$org$unitarou$ml$Messages = Messages.class$("org.unitarou.ml.Messages")) : class$org$unitarou$ml$Messages).getClassLoader());
        }
        return messages;
    }

    public static Messages createByPackage(Class clazz) {
        ArgumentChecker.throwIfNull(clazz);
        return Messages.createByPackage(clazz, MESSAGES_NAME, clazz.getClassLoader());
    }

    public static Messages createByPackage(Class clazz, ClassLoader classLoader) {
        ArgumentChecker.throwIfNull(clazz, classLoader);
        return Messages.createByPackage(clazz, MESSAGES_NAME, classLoader);
    }

    public static Messages createByPackage(Class clazz, String string) {
        ArgumentChecker.throwIfNull(clazz, string);
        return Messages.createByPackage(clazz, string, clazz.getClassLoader());
    }

    public static Messages createByPackage(Class clazz, String string, ClassLoader classLoader) {
        ArgumentChecker.throwIfNull(clazz, string, classLoader);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Classes.packageName(clazz)).append('.').append(string);
        String string2 = stringBuffer.toString();
        Messages messages = (Messages)messageMap_s_.get(string2);
        if (messages == null) {
            messages = new Messages(string2, classLoader);
        }
        return messages;
    }

    public static String createKey(Class clazz, String string) {
        ArgumentChecker.throwIfNull(clazz, string);
        String string2 = Classes.simpleName(clazz);
        StringBuffer stringBuffer = new StringBuffer(string2.length() + string.length() + 1);
        stringBuffer.append(string2);
        if (string.length() != 0) {
            stringBuffer.append('.').append(string);
        }
        return stringBuffer.toString();
    }

    public static String createLongKey(Class clazz, String string) {
        ArgumentChecker.throwIfNull(clazz, string);
        if (string.length() == 0) {
            return clazz.getName();
        }
        return clazz.getName() + '.' + string;
    }

    public static void changeLocale(Locale locale) {
        ArgumentChecker.throwIfNull(locale);
        if (locale.equals(currentLocale_s_)) {
            return;
        }
        currentLocale_s_ = locale;
        Iterator iterator = messageMap_s_.values().iterator();
        while (iterator.hasNext()) {
            ((Messages)iterator.next()).makeResoureBundle();
        }
    }

    public static void inspectUnusedMessages() {
        if (!logger_s_.isDebugEnabled()) {
            return;
        }
        Iterator iterator = messageMap_s_.values().iterator();
        while (iterator.hasNext()) {
            Messages messages = (Messages)iterator.next();
            Enumeration<String> enumeration = messages.resourceBundle_.getKeys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (messages.usedKeySet_.contains(string)) continue;
                logger_s_.debug(string + " (bundleName: " + messages.bundleName_ + ")is not used.");
            }
        }
    }

    private Messages(String string, ClassLoader classLoader) {
        this.bundleName_ = string;
        this.classLoader_ = classLoader;
        this.usedKeySet_ = Collections.synchronizedSet(new HashSet());
        this.resourceBundle_ = this.makeResoureBundle();
        messageMap_s_.put(string, this);
    }

    private ResourceBundle makeResoureBundle() {
        try {
            return ResourceBundle.getBundle(this.bundleName_, currentLocale_s_, this.classLoader_);
        }
        catch (MissingResourceException missingResourceException) {
            logger_s_.warn("Can not find resource bundle. Use pseudo object. Bundle name=" + this.bundleName_ + ", Class loader=" + this.classLoader_ + ", Current locale=" + currentLocale_s_);
            return new PseudoResourceBundle();
        }
    }

    public boolean contains(String string) {
        ArgumentChecker.throwIfNull(string);
        try {
            this.resourceBundle_.getString(string);
            return true;
        }
        catch (MissingResourceException missingResourceException) {
            return false;
        }
    }

    public String get(String string) {
        ArgumentChecker.throwIfNull(string);
        return this.getString(string);
    }

    public String get(String string, Object object) {
        return this.get(string, new Object[]{object});
    }

    public String get(String string, Object[] objectArray) {
        ArgumentChecker.throwIfNull(string, objectArray);
        String string2 = this.getString(string);
        try {
            return MessageFormat.format(string2, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger_s_.warn("Bad pattern. key:" + string + ", pattern:" + string2 + ", reason:" + illegalArgumentException.getLocalizedMessage());
            return BAD_PATTERN;
        }
    }

    private String getString(String string) {
        String string2;
        try {
            string2 = this.resourceBundle_.getString(string);
            if (logger_s_.isDebugEnabled()) {
                this.usedKeySet_.add(string);
            }
        }
        catch (MissingResourceException missingResourceException) {
            logger_s_.warn("Cannot find the key='" + string + "' in " + this.bundleName_);
            logger_s_.debug(missingResourceException, "Plz find a lost key from:");
            string2 = "!" + string + "!";
        }
        return string2.trim();
    }

    public Properties getAll() {
        Properties properties = new Properties();
        Enumeration<String> enumeration = this.resourceBundle_.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            properties.setProperty(string, this.getString(string));
        }
        return properties;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class PseudoResourceBundle
    extends ResourceBundle {
        private PseudoResourceBundle() {
        }

        protected Object handleGetObject(String string) {
            return null;
        }

        public Enumeration getKeys() {
            return new Vector().elements();
        }
    }
}

