#!/bin/env ruby
# 2009 Katayama<katayama.ttsuy@gmail.com>
# License under GPL-3
# refer from http://uhideyuki.sakura.ne.jp/uDiary/?date=20081127
# 

require 'ldap'
require 'plugin'

class LdapLogin

attr_accessor(:conn)
  def initialize(host,binddn="",bindpass="")
    connect(host,binddn,bindpass)
  end

  def search_dn(basedn,attr,val)
    filter = attr + '=' + val
    @conn.search2(basedn,LDAP::LDAP_SCOPE_SUBTREE,filter,"dn")
  end

  def search_grpdn(basedn,grp_dns,name,memberattr)
    grp_dns.split(/\r\n/).each {|grp_dn|
      grp_cn = grp_dn.split(/,/)[0]
      filter = '(&(memberUid=' + name + ')(' + grp_cn + '))'
      result = @conn.search2(basedn,LDAP::LDAP_SCOPE_SUBTREE,filter,"dn")
      if result.size != 0
        return true
      end
    }
    return false
  end

  def bind_dn(dn,pass,namme)
    begin
      @conn.simple_bind(dn, pass)
    rescue
      false      
    end
  end

  private
  def connect(host,binddn="",bindpass="")
    begin
      @conn = LDAP::Conn.new(host, LDAP::LDAP_PORT) 
      @conn.set_option(LDAP::LDAP_OPT_PROTOCOL_VERSION,3)
    rescue
      false
    end
    if binddn !=""
      @conn = @conn.bind(binddn,bindpass)
    end
  end
 
end
