# -*- coding: utf-8 -*-
# $Id: auth_ldap.rb
# Tatsuya Katayama

require 'hiki/auth/ldap'
require 'hiki/session'
require 'logger'

@conf['ldap.host'] ||= ''
@conf['ldap.basedn'] ||= ''
@conf['ldap.userattr'] ||= ''
@conf['ldap.memberattr'] ||= ''
@conf['ldap.binddn'] ||= ''
@conf['ldap.bindpass'] ||= ''
@conf['ldap.permitusers'] ||= ''
@conf['ldap.permitgrps'] ||= ''

def saveconf_auth_ldap
  if @mode == 'saveconf' then
    @conf['ldap.host'] = @cgi.params['ldap.host'][0]
    @conf['ldap.basedn'] = @cgi.params['ldap.basedn'][0]
    @conf['ldap.userattr'] = @cgi.params['ldap.userattr'][0]
    @conf['ldap.memberattr'] = @cgi.params['ldap.memberattr'][0]
    @conf['ldap.binddn'] = @cgi.params['ldap.binddn'][0]
    @conf['ldap.bindpass'] = @cgi.params['ldap.bindpass'][0]
    @conf['ldap.permitusers'] = @cgi.params['ldap.permitusers'][0]
    @conf['ldap.permitgrps'] = @cgi.params['ldap.permitgrps'][0]
  end
end


def auth?
  return false if !@user || @conf['ldap.host']==""
  return true
end

def login(name,pass)
  hostname = @conf['ldap.host']
  basedn = @conf['ldap.basedn']
  userattr = @conf['ldap.userattr']
  memberattr = @conf['ldap.memberattr']
  binddn = @conf['ldap.binddn']
  bindpass = @conf['ldap.bindpass']
  permitusers = @conf['ldap.permitusers']
  permitgrps = @conf['ldap.permitgrps']

  return if @user
  return nil unless pass
  name ||= @conf.admin_name
  if @conf.password.empty? || pass.crypt( @conf.password ) == @conf.password && name == @conf.admin_name
    @user = @conf.admin_name
  elsif @conf['user.list']
    if @conf['user.list'].has_key?(name) && @conf['user.list'][name] == password.crypt(@conf['user.list'][name])
      @user = name
    end
  else
    ldap_conn = LdapLogin.new(hostname,binddn,bindpass)
    if permitusers == "" && permitgrps != ""
      permitgrps.split(/,/).each {|grp_dn|
        if ldap_conn.search_grpdn(basedn,grp_dn,name,memberattr) == true
          uid_dn = ldap_conn.search_dn(basedn,userattr,name)[0]["dn"][0]
          if ldap_conn.bind_dn(uid_dn,pass,name)
            @user = name
          end
        end
      }
    elsif permitusers != "" && permitgrps == ""
      if permitusers.index(name)
        uid_dn = ldap_conn.search_dn(basedn,userattr,name)[0]["dn"][0]
        if ldap_conn.bind_dn(uid_dn,pass,name)
          @user = name
        end
      end
    elsif permitusers != "" && permitgrps != ""
      if permitusers.index(name)
        uid_dn = ldap_conn.search_dn(basedn,userattr,name)[0]["dn"][0]
        if ldap_conn.bind_dn(uid_dn,pass,name)
          @user = name
          return true
        end
      else
      permitgrps.split(/,/).each {|grp_dn|
        if ldap_conn.search_grpdn(basedn,grp_dn,name,memberattr) == true
          uid_dn = ldap_conn.search_dn(basedn,userattr,name)[0]["dn"][0]
          if ldap_conn.bind_dn(uid_dn,pass,name)
            @user = name
          end
        end
      }
      end
    end
  end
  false
end

add_conf_proc('auth_ldap', label_auth_ldap_config) do
  saveconf_auth_ldap
  <<-HTML
  <h3 class="subtitle">#{label_auth_ldap_host}</h3>
  <p>#{label_auth_ldap_host_msg}</p>
  <p><input name="ldap.host" size="40" value="#{CGI::escapeHTML(@conf['ldap.host']||"")}"></p>

  <h3 class="subtitle">#{label_auth_ldap_basedn}</h3>
  <p>#{label_auth_ldap_basedn_msg}</p>
  <p><input name="ldap.basedn" size="40" value="#{CGI::escapeHTML(@conf['ldap.basedn']||"")}"></p>

  <h3 class="subtitle">#{label_auth_ldap_binddn}</h3>
  <p>#{label_auth_ldap_binddn_msg}</p>
  <p><input name="ldap.binddn" size="40" value="#{CGI::escapeHTML(@conf['ldap.binddn'])||""}"></p>

  <h3 class="subtitle">#{label_auth_ldap_bindpass}</h3>
  <p>#{label_auth_ldap_bindpass_msg}</p>
  <p><input type="password" name="ldap.bindpass" size="40" value="#{CGI::escapeHTML(@conf['ldap.bindpass'])||""}"></p>

  <h3 class="subtitle">#{label_auth_ldap_permitusers}</h3>
  <p>#{label_auth_ldap_permitusers_msg}</p>
  <p><input name="ldap.permitusers" size="40" value="#{CGI::escapeHTML(@conf['ldap.permitusers'])||""}"></p>

  <h3 class="subtitle">#{label_auth_ldap_userattr}</h3>
  <p>#{label_auth_ldap_userattr_msg}</p>
  <p><input name="ldap.userattr" size="40" value="#{CGI::escapeHTML(@conf['ldap.userattr'])||""}"></p>

  <h3 class="subtitle">#{label_auth_ldap_memberattr}</h3>
  <p>#{label_auth_ldap_memberattr_msg}</p>
  <p><input name="ldap.memberattr" size="40" value="#{CGI::escapeHTML(@conf['ldap.memberattr'])||""}"></p>

  <h3 class="subtitle">#{label_auth_ldap_permitgrps}</h3>
  <p>#{label_auth_ldap_permitgrps_msg}</p>
  <p><textarea name="ldap.permitgrps" cols="40" rows="8">#{CGI::escapeHTML(@conf['ldap.permitgrps'])||""}</textarea></p>

  HTML
end
