/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class CopyResourceAction
extends SelectionListenerAction
implements ISelectionValidator {
    public static final String ID = "org.eclipse.ui.CopyResourceAction";
    private Shell shell;
    protected CopyFilesAndFoldersOperation operation;

    public static IPath getNewNameFor(IPath originalName, IWorkspace workspace) {
        return CopyFilesAndFoldersOperation.getAutoNewNameFor(originalName, workspace);
    }

    public CopyResourceAction(Shell shell) {
        this(shell, IDEWorkbenchMessages.CopyResourceAction_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.copy_resource_action_context");
    }

    CopyResourceAction(Shell shell, String name) {
        super(name);
        this.setToolTipText(IDEWorkbenchMessages.CopyResourceAction_toolTip);
        this.setId(ID);
        if (shell == null) {
            throw new IllegalArgumentException();
        }
        this.shell = shell;
    }

    protected CopyFilesAndFoldersOperation createOperation() {
        return new CopyFilesAndFoldersOperation(this.getShell());
    }

    IContainer getInitialContainer() {
        List resources = this.getSelectedResources();
        if (resources.size() > 0) {
            IResource resource = (IResource)resources.get(0);
            return resource.getParent();
        }
        return null;
    }

    protected IResource[] getResources(List resourceList) {
        return resourceList.toArray(new IResource[resourceList.size()]);
    }

    Shell getShell() {
        return this.shell;
    }

    public String isValid(Object destination) {
        IWorkspaceRoot root = IDEWorkbenchPlugin.getPluginWorkspace().getRoot();
        IContainer container = (IContainer)root.findMember((IPath)destination);
        if (container != null) {
            CopyFilesAndFoldersOperation newOperation = this.createOperation();
            List sources = this.getSelectedResources();
            IResource[] resources = sources.toArray(new IResource[sources.size()]);
            return newOperation.validateDestination(container, resources);
        }
        return null;
    }

    IPath queryDestinationResource() {
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.shell, this.getInitialContainer(), true, IDEWorkbenchMessages.CopyResourceAction_selectDestination);
        dialog.setValidator(this);
        dialog.showClosedProjects(false);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result != null && result.length == 1) {
            return (IPath)result[0];
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block6: {
            block5: {
                try {
                    this.operation = this.createOperation();
                    List sources = this.getSelectedResources();
                    IPath destination = this.queryDestinationResource();
                    if (destination == null) {
                        Object var5_3 = null;
                        this.operation = null;
                        return;
                    }
                    IWorkspaceRoot root = IDEWorkbenchPlugin.getPluginWorkspace().getRoot();
                    IContainer container = (IContainer)root.findMember(destination);
                    if (container == null) {
                        break block5;
                    }
                    this.runOperation(this.getResources(sources), container);
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.operation = null;
                    throw throwable;
                }
            }
            Object var5_4 = null;
            this.operation = null;
            return;
        }
        Object var5_6 = null;
        this.operation = null;
    }

    protected void runOperation(IResource[] resources, IContainer destination) {
        this.operation.copyResources(resources, destination);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!super.updateSelection(selection)) {
            return false;
        }
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        List selectedResources = this.getSelectedResources();
        if (selectedResources.size() == 0) {
            return false;
        }
        IContainer firstParent = ((IResource)selectedResources.get(0)).getParent();
        if (firstParent == null) {
            return false;
        }
        Iterator resourcesEnum = selectedResources.iterator();
        while (resourcesEnum.hasNext()) {
            IResource currentResource = (IResource)resourcesEnum.next();
            if (!currentResource.exists()) {
                return false;
            }
            if (currentResource.getType() == 4) {
                return false;
            }
            IContainer parent = currentResource.getParent();
            if (parent == null || parent.equals((Object)firstParent)) continue;
            return false;
        }
        return true;
    }
}

