/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.composite;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorStringValueInfo;
import com.clustercontrol.monitor.run.composite.StringValueListComposite;
import com.clustercontrol.monitor.run.dialog.StringValueInfoCreateDialog;
import com.clustercontrol.monitor.run.util.StringValueInfoManager;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class StringValueInfoComposite
extends Composite {
    public static final int WIDTH_TITLE = 5;
    public static final int WIDTH_VALUE = 2;
    private StringValueListComposite m_infoList = null;
    private Button m_buttonAdd = null;
    private Button m_buttonModify = null;
    private Button m_buttonDelete = null;
    private Button m_buttonUp = null;
    private Button m_buttonDown = null;
    private Combo m_comboFailurePriority = null;

    public StringValueInfoComposite(Composite parent, int style, ArrayList tableDefine) {
        super(parent, style);
        this.initialize(tableDefine);
    }

    private void initialize(ArrayList tableDefine) {
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 15;
        this.setLayout((Layout)layout);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"successful.select.value")) + " : ");
        this.m_infoList = new StringValueListComposite(this, 2048, tableDefine);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 13;
        this.m_infoList.setLayoutData(gridData);
        Composite composite = new Composite((Composite)this, 0);
        layout = new GridLayout(1, true);
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        this.m_buttonAdd = this.createButton(composite, Messages.getString((String)"add"));
        this.m_buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                StringValueInfoCreateDialog dialog = new StringValueInfoCreateDialog(shell);
                if (dialog.open() == 0) {
                    StringValueInfoManager.getInstance().add(dialog.getInputData());
                    StringValueInfoComposite.this.m_infoList.update();
                }
            }
        });
        this.m_buttonModify = this.createButton(composite, Messages.getString((String)"modify"));
        this.m_buttonModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String identifier = StringValueInfoComposite.this.getSelectIdentifier();
                if (identifier != null) {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    StringValueInfoCreateDialog dialog = new StringValueInfoCreateDialog(shell, identifier);
                    if (dialog.open() == 0) {
                        Table table = StringValueInfoComposite.this.m_infoList.getTableViewer().getTable();
                        int selectIndex = table.getSelectionIndex();
                        StringValueInfoManager.getInstance().modify(dialog.getInputData());
                        StringValueInfoComposite.this.m_infoList.update();
                        table.setSelection(selectIndex);
                    }
                } else {
                    MessageBox box = new MessageBox(StringValueInfoComposite.this.getShell(), 40);
                    box.setText(Messages.getString((String)"warning"));
                    box.setMessage(Messages.getString((String)"message.monitor.30"));
                    box.open();
                }
            }
        });
        this.m_buttonDelete = this.createButton(composite, Messages.getString((String)"delete"));
        this.m_buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MonitorStringValueInfo info = StringValueInfoComposite.this.m_infoList.getFilterItem();
                if (info != null) {
                    String detail = info.getDescription();
                    MessageBox box = new MessageBox(StringValueInfoComposite.this.getShell(), 296);
                    box.setText(Messages.getString((String)"confirmed"));
                    Object[] args = new String[]{detail};
                    String message = Messages.getString((String)"message.monitor.31", (Object[])args);
                    box.setMessage(message);
                    if (box.open() == 32) {
                        StringValueInfoManager.getInstance().delete(StringValueInfoComposite.this.getSelectIdentifier());
                        StringValueInfoComposite.this.m_infoList.update();
                    }
                } else {
                    MessageBox box = new MessageBox(StringValueInfoComposite.this.getShell(), 40);
                    box.setText(Messages.getString((String)"warning"));
                    box.setMessage(Messages.getString((String)"message.monitor.30"));
                    box.open();
                }
            }
        });
        label = new Label(composite, 0);
        this.m_buttonUp = this.createButton(composite, Messages.getString((String)"up"));
        this.m_buttonUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String identifier = StringValueInfoComposite.this.getSelectIdentifier();
                if (identifier != null) {
                    if (StringValueInfoManager.getInstance().upOrder(identifier)) {
                        StringValueInfoComposite.this.m_infoList.update();
                        StringValueInfoComposite.this.selectItem(identifier);
                    }
                } else {
                    MessageBox box = new MessageBox(StringValueInfoComposite.this.getShell(), 40);
                    box.setText(Messages.getString((String)"warning"));
                    box.setMessage(Messages.getString((String)"message.monitor.30"));
                    box.open();
                }
            }
        });
        this.m_buttonDown = this.createButton(composite, Messages.getString((String)"down"));
        this.m_buttonDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String identifier = StringValueInfoComposite.this.getSelectIdentifier();
                if (identifier != null) {
                    if (StringValueInfoManager.getInstance().downOrder(StringValueInfoComposite.this.getSelectIdentifier())) {
                        StringValueInfoComposite.this.m_infoList.update();
                        StringValueInfoComposite.this.selectItem(identifier);
                    }
                } else {
                    MessageBox box = new MessageBox(StringValueInfoComposite.this.getShell(), 40);
                    box.setText(Messages.getString((String)"warning"));
                    box.setMessage(Messages.getString((String)"message.monitor.30"));
                    box.open();
                }
            }
        });
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"failure.select.value")) + " : ");
        this.m_comboFailurePriority = new Combo((Composite)this, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboFailurePriority.setLayoutData((Object)gridData);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_CRITICAL);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_WARNING);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_INFO);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_UNKNOWN);
        this.m_comboFailurePriority.setText(PriorityConstant.STRING_UNKNOWN);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
    }

    public void setInputData(MonitorInfo info) {
        if (info != null) {
            this.m_infoList.setInputData(info);
            this.m_comboFailurePriority.setText(PriorityConstant.typeToString((int)info.getFailurePriority()));
        }
    }

    public ValidateResult createInputData(MonitorInfo info) {
        ValidateResult validateResult = this.m_infoList.createInputData(info);
        if (validateResult != null) {
            return validateResult;
        }
        info.setFailurePriority(PriorityConstant.stringToType((String)this.m_comboFailurePriority.getText()));
        return null;
    }

    public void setEnabled(boolean enabled) {
        this.m_buttonAdd.setEnabled(enabled);
        this.m_buttonModify.setEnabled(enabled);
        this.m_buttonDelete.setEnabled(enabled);
        this.m_buttonUp.setEnabled(enabled);
        this.m_buttonDown.setEnabled(enabled);
        this.m_comboFailurePriority.setEnabled(enabled);
    }

    protected Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        button.setText(label);
        return button;
    }

    protected String getSelectIdentifier() {
        StructuredSelection selection = (StructuredSelection)this.m_infoList.getTableViewer().getSelection();
        if (selection.getFirstElement() instanceof MonitorStringValueInfo) {
            MonitorStringValueInfo filterInfo = (MonitorStringValueInfo)selection.getFirstElement();
            return filterInfo.getIdentifier();
        }
        return null;
    }

    protected void selectItem(String identifier) {
        Table table = this.m_infoList.getTableViewer().getTable();
        TableItem[] items = table.getItems();
        if (items == null || identifier == null) {
            return;
        }
        int i = 0;
        while (i < items.length) {
            MonitorStringValueInfo filterInfo;
            if (items[i].getData() instanceof MonitorStringValueInfo && identifier.equals((filterInfo = (MonitorStringValueInfo)items[i].getData()).getIdentifier())) {
                table.select(i);
                return;
            }
            ++i;
        }
    }

    protected ValidateResult setValidateResult(String id, String message) {
        ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        return validateResult;
    }

    public boolean isNotify() {
        return this.m_infoList.isNotify();
    }
}

