/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.logtransfer.ejb.session;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.factory.AddLogTransfer;
import com.clustercontrol.logtransfer.factory.DeleteLogTransfer;
import com.clustercontrol.logtransfer.factory.ModifyLogTransfer;
import com.clustercontrol.logtransfer.factory.SelectLogTransfer;
import com.clustercontrol.util.Messages;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.jms.JMSException;
import javax.naming.NamingException;

public abstract class LogTransferControllerBean
implements SessionBean {
    private SessionContext m_context;

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.m_context = ctx;
    }

    public boolean addLogTransfer(LogTransferInfo info) throws CreateException, NamingException, JMSException {
        Principal pri = this.m_context.getCallerPrincipal();
        AddLogTransfer logTransfer = new AddLogTransfer();
        return logTransfer.add(info, pri.getName());
    }

    public boolean modifyLogTransfer(LogTransferInfo info) throws CreateException, FinderException, RemoveException, NamingException, JMSException {
        Principal pri = this.m_context.getCallerPrincipal();
        ModifyLogTransfer logTransfer = new ModifyLogTransfer();
        return logTransfer.modify(info, pri.getName());
    }

    public boolean deleteLogTransfer(String transferId) throws FinderException, RemoveException, NamingException, JMSException {
        DeleteLogTransfer logTransfer = new DeleteLogTransfer();
        return logTransfer.delete(transferId);
    }

    public LogTransferInfo getLogTransfer(String transferId) throws CreateException, FinderException, NamingException {
        SelectLogTransfer logTransfer = new SelectLogTransfer();
        LogTransferInfo info = logTransfer.getLogTransfer(transferId);
        return info;
    }

    public ArrayList getLogTransferList() throws CreateException, FinderException, NamingException {
        SelectLogTransfer logTransfer = new SelectLogTransfer();
        ArrayList list = logTransfer.getLogTransferList();
        return list;
    }

    public ArrayList getLogTransferListTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"logtransfer.id", (Locale)locale), -1, 100, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"description", (Locale)locale), -1, 200, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"scope", (Locale)locale), 2, 200, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"valid", (Locale)locale) + "/" + Messages.getString((String)"invalid", (Locale)locale), 4, 80, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"creator.name", (Locale)locale), -1, 80, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"create.time", (Locale)locale), -1, 130, 16384));
        tableDefine.add(6, new TableColumnInfo(Messages.getString((String)"modifier.name", (Locale)locale), -1, 80, 16384));
        tableDefine.add(7, new TableColumnInfo(Messages.getString((String)"update.time", (Locale)locale), -1, 130, 16384));
        return tableDefine;
    }

    public ArrayList getLogTransferFileListTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"file.path", (Locale)locale), -1, 300, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"semantics.interval.sec", (Locale)locale), -1, 100, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"file.first.existence.check", (Locale)locale), 15, 170, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"valid", (Locale)locale) + "/" + Messages.getString((String)"invalid", (Locale)locale), 4, 80, 16384));
        return tableDefine;
    }
}

