/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.jobmanagement.action.GetJobTree;
import com.clustercontrol.jobmanagement.action.GetJobTreeOneLevel;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.composite.JobTreeContentProvider;
import com.clustercontrol.jobmanagement.composite.JobTreeLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class JobTreeComposite
extends Composite {
    private TreeViewer m_viewer = null;
    private JobTreeItem m_selectItem = null;
    private boolean m_treeOnly = false;
    private String m_parentJobId = null;
    private String m_jobId = null;

    public JobTreeComposite(Composite parent, int style) {
        super(parent, style);
        this.m_treeOnly = false;
        this.initialize();
    }

    public JobTreeComposite(Composite parent, int style, boolean treeOnly) {
        super(parent, style);
        this.m_treeOnly = treeOnly;
        this.initialize();
    }

    public JobTreeComposite(Composite parent, int style, String parentJobId, String jobId) {
        super(parent, style);
        this.m_treeOnly = true;
        this.m_parentJobId = parentJobId;
        this.m_jobId = jobId;
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Tree tree = new Tree((Composite)this, 2052);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        tree.setLayoutData((Object)gridData);
        this.m_viewer = new TreeViewer(tree);
        this.m_viewer.setContentProvider((IContentProvider)new JobTreeContentProvider());
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new JobTreeLabelProvider());
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                JobTreeComposite.this.m_selectItem = (JobTreeItem)selection.getFirstElement();
            }
        });
        this.update();
    }

    public TreeViewer getTreeViewer() {
        return this.m_viewer;
    }

    public Tree getTree() {
        return this.m_viewer.getTree();
    }

    public void update() {
        JobTreeItem jobTree = null;
        this.m_selectItem = null;
        if (this.m_jobId == null) {
            GetJobTree getJobTree = new GetJobTree();
            jobTree = getJobTree.getJobTree(this.m_treeOnly);
        } else {
            GetJobTreeOneLevel getJobTree = new GetJobTreeOneLevel();
            jobTree = getJobTree.getJobTreeOneLevel(this.m_parentJobId, this.m_jobId);
        }
        this.m_viewer.setInput((Object)jobTree);
        this.m_viewer.expandToLevel(2);
    }

    public JobTreeItem getSelectItem() {
        return this.m_selectItem;
    }

    public void setSelectItem(JobTreeItem item) {
        this.m_selectItem = item;
    }
}

